(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6969,        259]
NotebookOptionsPosition[      4070,        163]
NotebookOutlinePosition[      5737,        214]
CellTagsIndexPosition[      5619,        208]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["DigitCount::base", "ObjectName",
 CellID->1601],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"DigitCount", "::", "\<\"base\"\>"}], ":", 
  " ", "\<\"The base `1` at position 2 of `2` should be an integer greater \
than 1.\"\>"}]], "Message", "MSG",
 CellID->968099222],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["DigitCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitCount"]], "InlineFormula"],
 " is not an integer or not greater than 1."
}], "Notes",
 CellID->16990],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["DigitCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitCount"]], "InlineFormula"],
 " specifies the base to use in determining the digits of the first",
 " ",
 "argument."
}], "Notes",
 CellID->19067]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134118431],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->30137442],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["DigitCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitCount"]], "InlineFormula"],
 " is less than 1."
}], "ExampleText",
 CellID->59638031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"303100331", ",", "0"}], "]"}]], "Input",
 CellTags->"DigitCount::base",
 CellLabel->"In[1]:=",
 CellID->21125],

Cell[BoxData[
 RowBox[{
  RowBox[{"DigitCount", "::", "\<\"base\"\>"}], ":", 
  " ", "\<\"The base \\!\\(0\\) at position 2 of \
\\!\\(DigitCount[\\(\\(303100331, 0\\)\\)]\\) should be an integer greater \
than 1.\"\>"}]], "Message", "MSG",
 CellTags->"DigitCount::base",
 CellID->20214144],

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"303100331", ",", "0"}], "]"}]], "Output",
 CellTags->"DigitCount::base",
 CellLabel->"Out[1]=",
 CellID->538176788]
}, Open  ]],

Cell["\<\
This input counts the number of times that the digit 0 occurs in the base 10 \
representation of the number in the first argument.\
\>", "ExampleText",
 CellID->66289649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"303100331", ",", "10", ",", "0"}], "]"}]], "Input",
 CellTags->"DigitCount::base",
 CellLabel->"In[2]:=",
 CellID->85143278],

Cell[BoxData["3"], "Output",
 CellTags->"DigitCount::base",
 CellLabel->"Out[2]=",
 CellID->2010947]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DigitCount::base - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 38.2612154}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DigitCount::base", "synonyms" -> {}, "title" -> 
    "DigitCount::base", "type" -> "Message", "uri" -> "ref/message/base"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2050, 81, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134118431]},
 "DigitCount::base"->{
  Cell[2874, 114, 164, 5, 70, "Input",
   CellTags->"DigitCount::base",
   CellID->21125],
  Cell[3041, 121, 290, 7, 70, "Message",
   CellTags->"DigitCount::base",
   CellID->20214144],
  Cell[3334, 130, 169, 5, 70, "Output",
   CellTags->"DigitCount::base",
   CellID->538176788],
  Cell[3723, 146, 178, 5, 70, "Input",
   CellTags->"DigitCount::base",
   CellID->85143278],
  Cell[3904, 153, 100, 3, 70, "Output",
   CellTags->"DigitCount::base",
   CellID->2010947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4982, 185},
 {"DigitCount::base", 5124, 189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->1601],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 209, 5, 70, "Message",
 CellID->968099222],
Cell[1471, 56, 255, 8, 70, "Notes",
 CellID->16990],
Cell[1729, 66, 284, 10, 70, "Notes",
 CellID->19067]
}, Closed]],
Cell[CellGroupData[{
Cell[2050, 81, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134118431],
Cell[CellGroupData[{
Cell[2435, 95, 147, 5, 70, "ExampleSection",
 CellID->30137442],
Cell[2585, 102, 264, 8, 70, "ExampleText",
 CellID->59638031],
Cell[CellGroupData[{
Cell[2874, 114, 164, 5, 70, "Input",
 CellTags->"DigitCount::base",
 CellID->21125],
Cell[3041, 121, 290, 7, 70, "Message",
 CellTags->"DigitCount::base",
 CellID->20214144],
Cell[3334, 130, 169, 5, 70, "Output",
 CellTags->"DigitCount::base",
 CellID->538176788]
}, Open  ]],
Cell[3518, 138, 180, 4, 70, "ExampleText",
 CellID->66289649],
Cell[CellGroupData[{
Cell[3723, 146, 178, 5, 70, "Input",
 CellTags->"DigitCount::base",
 CellID->85143278],
Cell[3904, 153, 100, 3, 70, "Output",
 CellTags->"DigitCount::base",
 CellID->2010947]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4043, 161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

