(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9496,        340]
NotebookOptionsPosition[      5610,        221]
NotebookOutlinePosition[      7773,        282]
CellTagsIndexPosition[      7639,        276]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["EllipticReducedHalfPeriods::nind", "ObjectName",
 CellID->17280],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticReducedHalfPeriods", "::", "\<\"nind\"\>"}], ":", 
  " ", "\<\"Half-periods `1` are not independent.\"\>"}]], "Message", "MSG",
 CellID->608308886],

Cell[TextData[{
 "Generated when the imaginary part of ",
 StyleBox["u", "MR",
  FontSlant->"Italic"],
 " and ",
 StyleBox["v", "MR",
  FontSlant->"Italic"],
 " in ",
 StyleBox["EllipticReducedHalfPeriods[{", "MR"],
 StyleBox["u", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["v", "MR",
  FontSlant->"Italic"],
 StyleBox["}]", "MR"],
 " is zero."
}], "Notes",
 CellID->9532],

Cell[TextData[{
 "This message can also be generated by",
 " ",
 "related functions, such as ",
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WeierstrassInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFormula"],
 ", that use ",
 Cell[BoxData["EllipticReducedHalfPeriods"], "InlineFormula"],
 " internally."
}], "Notes",
 CellID->803]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->784963187],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->25606582],

Cell[TextData[{
 "An error occurs in this example because the arguments in ",
 Cell[BoxData["EllipticReducedHalfPeriods"], "InlineFormula"],
 " are real numbers."
}], "ExampleText",
 CellID->105166691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticReducedHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"1.0", ",", "1.5"}], "}"}], "]"}]], "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"In[1]:=",
 CellID->19851],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticReducedHalfPeriods", "::", "\<\"nind\"\>"}], ":", 
  " ", "\<\"Half-periods \\!\\({1.`, 1.5`}\\) are not independent.\"\>"}]], \
"Message", "MSG",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->67021592],

Cell[BoxData[
 RowBox[{"EllipticReducedHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"1.`", ",", "1.5`"}], "}"}], "]"}]], "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"Out[1]=",
 CellID->146943767]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData["EllipticReducedHalfPeriods"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->2054600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticReducedHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"1.0", ",", 
    RowBox[{"1.5", "+", 
     RowBox[{"2.3", " ", "I"}]}]}], "}"}], "]"}]], "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"In[2]:=",
 CellID->314399122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"2.3`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"Out[2]=",
 CellID->14476944]
}, Open  ]],

Cell[TextData[{
 "This message can also be generated by related functions that are computed",
 " ",
 "using ",
 Cell[BoxData["EllipticReducedHalfPeriods"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->288619882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassInvariants", "[", 
  RowBox[{"{", 
   RowBox[{"1.0", ",", "1.0"}], "}"}], "]"}]], "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"In[3]:=",
 CellID->5786],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticReducedHalfPeriods", "::", "\<\"nind\"\>"}], ":", 
  " ", "\<\"Half-periods \\!\\({1.`, 1.`}\\) are not independent.\"\>"}]], \
"Message", "MSG",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->174903422],

Cell[BoxData[
 RowBox[{"WeierstrassInvariants", "[", 
  RowBox[{"{", 
   RowBox[{"1.`", ",", "1.`"}], "}"}], "]"}]], "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellLabel->"Out[3]=",
 CellID->36903507]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticReducedHalfPeriods::nind - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 34.9970428}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "EllipticReducedHalfPeriods::nind", "synonyms" -> {}, 
    "title" -> "EllipticReducedHalfPeriods::nind", "type" -> "Message", "uri" -> 
    "ref/message/nind"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2419, 96, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->784963187]},
 "EllipticReducedHalfPeriods::nind"->{
  Cell[3180, 126, 216, 6, 70, "Input",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->19851],
  Cell[3399, 134, 255, 6, 70, "Message",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->67021592],
  Cell[3657, 142, 222, 6, 70, "Output",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->146943767],
  Cell[4074, 160, 273, 8, 70, "Input",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->314399122],
  Cell[4350, 170, 251, 8, 70, "Output",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->14476944],
  Cell[4858, 192, 210, 6, 70, "Input",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->5786],
  Cell[5071, 200, 255, 6, 70, "Message",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->174903422],
  Cell[5329, 208, 215, 6, 70, "Output",
   CellTags->"EllipticReducedHalfPeriods::nind",
   CellID->36903507]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6574, 244},
 {"EllipticReducedHalfPeriods::nind", 6732, 248}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 70, 1, 70, "ObjectName",
 CellID->17280],
Cell[CellGroupData[{
Cell[798, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1276, 49, 190, 4, 70, "Message",
 CellID->608308886],
Cell[1469, 55, 391, 17, 70, "Notes",
 CellID->9532],
Cell[1863, 74, 519, 17, 70, "Notes",
 CellID->803]
}, Closed]],
Cell[CellGroupData[{
Cell[2419, 96, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->784963187],
Cell[CellGroupData[{
Cell[2804, 110, 147, 5, 70, "ExampleSection",
 CellID->25606582],
Cell[2954, 117, 201, 5, 70, "ExampleText",
 CellID->105166691],
Cell[CellGroupData[{
Cell[3180, 126, 216, 6, 70, "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->19851],
Cell[3399, 134, 255, 6, 70, "Message",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->67021592],
Cell[3657, 142, 222, 6, 70, "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->146943767]
}, Open  ]],
Cell[3894, 151, 155, 5, 70, "ExampleText",
 CellID->2054600],
Cell[CellGroupData[{
Cell[4074, 160, 273, 8, 70, "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->314399122],
Cell[4350, 170, 251, 8, 70, "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->14476944]
}, Open  ]],
Cell[4616, 181, 217, 7, 70, "ExampleText",
 CellID->288619882],
Cell[CellGroupData[{
Cell[4858, 192, 210, 6, 70, "Input",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->5786],
Cell[5071, 200, 255, 6, 70, "Message",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->174903422],
Cell[5329, 208, 215, 6, 70, "Output",
 CellTags->"EllipticReducedHalfPeriods::nind",
 CellID->36903507]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5583, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

