(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9238,        319]
NotebookOptionsPosition[      5506,        207]
NotebookOutlinePosition[      7944,        276]
CellTagsIndexPosition[      7792,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindFit::notlm
FindMinimum::notlm\
\>", "ObjectName",
 CellID->26543],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"notlm\"\>"}], ":", 
  " ", "\<\"The objective function for the method LevenbergMarquardt must be \
in a least-squares form: Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] \
f[i][x]^2,{i,1,n}] with positive w[i].\"\>"}]], "Message", "MSG",
 CellID->17259554],

Cell[TextData[{
 "Generated ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " is used with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 ", and the first argument is not given as a sum of squares."
}], "Notes",
 CellID->30964]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376231182],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->22497670],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " does not have the required form for use with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 " ",
 "."
}], "ExampleText",
 CellID->649023918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"9", "+", 
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"4", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Input",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellLabel->"In[1]:=",
 CellID->1112],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"notlm\"\>"}], ":", 
  " ", "\<\"The objective function for the method LevenbergMarquardt must be \
in a least-squares form: Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] \
f[i][x]^2,{i,1,n}] with positive w[i].\"\>"}]], "Message", "MSG",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->649451834],

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"9", "+", 
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"4", " ", "x"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Output",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellLabel->"Out[1]=",
 CellID->488946592]
}, Open  ]],

Cell[TextData[{
 "This shows a valid objective function for use with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 "."
}], "ExampleText",
 CellID->480614282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"4", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Input",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellLabel->"In[2]:=",
 CellID->15545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.`"}], ",", 
     RowBox[{"y", "\[Rule]", "3.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellLabel->"Out[2]=",
 CellID->544730283]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindFit::notlm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 38.2955382}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindFit::notlm FindMinimum::notlm", "synonyms" -> {}, 
    "title" -> "FindFit::notlm", "type" -> "Message", "uri" -> 
    "ref/message/notlm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2085, 81, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376231182]},
 "FindFit::notlm"->{
  Cell[3000, 117, 515, 16, 70, "Input",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->1112],
  Cell[3518, 135, 359, 7, 70, "Message",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->649451834],
  Cell[3880, 144, 528, 16, 70, "Output",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->488946592],
  Cell[4610, 172, 539, 17, 70, "Input",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->15545],
  Cell[5152, 191, 288, 9, 70, "Output",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->544730283]},
 "FindMinimum::notlm"->{
  Cell[3000, 117, 515, 16, 70, "Input",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->1112],
  Cell[3518, 135, 359, 7, 70, "Message",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->649451834],
  Cell[3880, 144, 528, 16, 70, "Output",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->488946592],
  Cell[4610, 172, 539, 17, 70, "Input",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->15545],
  Cell[5152, 191, 288, 9, 70, "Output",
   CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
   CellID->544730283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6436, 230},
 {"FindFit::notlm", 6576, 234},
 {"FindMinimum::notlm", 7185, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 79, 4, 70, "ObjectName",
 CellID->26543],
Cell[CellGroupData[{
Cell[807, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1285, 52, 322, 7, 70, "Message",
 CellID->17259554],
Cell[1610, 61, 438, 15, 70, "Notes",
 CellID->30964]
}, Closed]],
Cell[CellGroupData[{
Cell[2085, 81, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376231182],
Cell[CellGroupData[{
Cell[2470, 95, 147, 5, 70, "ExampleSection",
 CellID->22497670],
Cell[2620, 102, 355, 11, 70, "ExampleText",
 CellID->649023918],
Cell[CellGroupData[{
Cell[3000, 117, 515, 16, 70, "Input",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->1112],
Cell[3518, 135, 359, 7, 70, "Message",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->649451834],
Cell[3880, 144, 528, 16, 70, "Output",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->488946592]
}, Open  ]],
Cell[4423, 163, 162, 5, 70, "ExampleText",
 CellID->480614282],
Cell[CellGroupData[{
Cell[4610, 172, 539, 17, 70, "Input",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->15545],
Cell[5152, 191, 288, 9, 70, "Output",
 CellTags->{"FindFit::notlm", "FindMinimum::notlm"},
 CellID->544730283]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5479, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

