(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7438,        274]
NotebookOptionsPosition[      4525,        178]
NotebookOutlinePosition[      6201,        229]
CellTagsIndexPosition[      6082,        223]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FindMaximum::fmgz", "ObjectName",
 CellID->15212],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMaximum", "::", "\<\"fmgz\"\>"}], ":", 
  " ", "\<\"Encountered a gradient that is effectively zero. The result \
returned may not be a maximum; it may be a minimum or a saddle \
point.\"\>"}]], "Message", "MSG",
 CellID->93059500],

Cell["\<\
Generated when the gradient of the objective function is zero to within \
numerical error at a point that is checked by the algorithm.\
\>", "Notes",
 CellID->26761],

Cell["\<\
If the function has a maximum, this error can often be corrected by choosing \
different starting values, or by giving two starting values for each \
variable.\
\>", "Notes",
 CellID->16265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459466440],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->429700084],

Cell["\<\
An error occurs in this example because the starting point corresponds to a \
saddle point.\
\>", "ExampleText",
 CellID->33856805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"y", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindMaximum::fmgz",
 CellLabel->"In[1]:=",
 CellID->11995],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMaximum", "::", "\<\"fmgz\"\>"}], ":", 
  " ", "\<\"Encountered a gradient that is effectively zero. The result \
returned may not be a maximum; it may be a minimum or a saddle \
point.\"\>"}]], "Message", "MSG",
 CellTags->"FindMaximum::fmgz",
 CellID->53836525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->"FindMaximum::fmgz",
 CellLabel->"Out[1]=",
 CellID->3715428]
}, Open  ]],

Cell["\<\
The maximum is computed without difficulty if different starting values are \
used.\
\>", "ExampleText",
 CellID->490414830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"y", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindMaximum::fmgz",
 CellLabel->"In[2]:=",
 CellID->28304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.25`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.7071067811869883`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"FindMaximum::fmgz",
 CellLabel->"Out[2]=",
 CellID->416945430]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMaximum::fmgz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 46.8582574}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindMaximum::fmgz", "synonyms" -> {}, "title" -> 
    "FindMaximum::fmgz", "type" -> "Message", "uri" -> "ref/message/fmgz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1949, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->459466440]},
 "FindMaximum::fmgz"->{
  Cell[2651, 102, 385, 13, 70, "Input",
   CellTags->"FindMaximum::fmgz",
   CellID->11995],
  Cell[3039, 117, 302, 7, 70, "Message",
   CellTags->"FindMaximum::fmgz",
   CellID->53836525],
  Cell[3344, 126, 265, 9, 70, "Output",
   CellTags->"FindMaximum::fmgz",
   CellID->3715428],
  Cell[3783, 146, 385, 13, 70, "Input",
   CellTags->"FindMaximum::fmgz",
   CellID->28304],
  Cell[4171, 161, 288, 10, 70, "Output",
   CellTags->"FindMaximum::fmgz",
   CellID->416945430]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5439, 200},
 {"FindMaximum::fmgz", 5582, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->15212],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 270, 6, 70, "Message",
 CellID->93059500],
Cell[1534, 57, 175, 4, 70, "Notes",
 CellID->26761],
Cell[1712, 63, 200, 5, 70, "Notes",
 CellID->16265]
}, Closed]],
Cell[CellGroupData[{
Cell[1949, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459466440],
Cell[CellGroupData[{
Cell[2334, 87, 148, 5, 70, "ExampleSection",
 CellID->429700084],
Cell[2485, 94, 141, 4, 70, "ExampleText",
 CellID->33856805],
Cell[CellGroupData[{
Cell[2651, 102, 385, 13, 70, "Input",
 CellTags->"FindMaximum::fmgz",
 CellID->11995],
Cell[3039, 117, 302, 7, 70, "Message",
 CellTags->"FindMaximum::fmgz",
 CellID->53836525],
Cell[3344, 126, 265, 9, 70, "Output",
 CellTags->"FindMaximum::fmgz",
 CellID->3715428]
}, Open  ]],
Cell[3624, 138, 134, 4, 70, "ExampleText",
 CellID->490414830],
Cell[CellGroupData[{
Cell[3783, 146, 385, 13, 70, "Input",
 CellTags->"FindMaximum::fmgz",
 CellID->28304],
Cell[4171, 161, 288, 10, 70, "Output",
 CellTags->"FindMaximum::fmgz",
 CellID->416945430]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4498, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

