(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8020,        289]
NotebookOptionsPosition[      5131,        194]
NotebookOutlinePosition[      6826,        246]
CellTagsIndexPosition[      6706,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FindMaximum::notlm", "ObjectName",
 CellID->11588],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMaximum", "::", "\<\"notlm\"\>"}], ":", 
  " ", "\<\"The objective function for the method LevenbergMarquardt must be \
in a least-squares form: Sum[-f[i][x]^2,{i,1,n}] or Sum[w[i] \
f[i][x]^2,{i,1,n}] with negative w[i].\"\>"}]], "Message", "MSG",
 CellID->173008883],

Cell[TextData[{
 "Generated when F",
 StyleBox["indMaximum", "MR"],
 " is used with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 ", and the first argument is not given as a sum of squares."
}], "Notes",
 CellID->30776]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->489175635],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->225230335],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 " does not have the required form for use with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 " ."
}], "ExampleText",
 CellID->12983457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"4", "x"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Input",
 CellTags->"FindMaximum::notlm",
 CellLabel->"In[1]:=",
 CellID->32428],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMaximum", "::", "\<\"notlm\"\>"}], ":", 
  " ", "\<\"The objective function for the method LevenbergMarquardt must be \
in a least-squares form: Sum[-f[i][x]^2,{i,1,n}] or Sum[w[i] \
f[i][x]^2,{i,1,n}] with negative w[i].\"\>"}]], "Message", "MSG",
 CellTags->"FindMaximum::notlm",
 CellID->905759592],

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"4", " ", "x"}], "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Output",
 CellTags->"FindMaximum::notlm",
 CellLabel->"Out[1]=",
 CellID->277879331]
}, Open  ]],

Cell[TextData[{
 "This shows a valid objective function for use with ",
 StyleBox["Method->LevenbergMarquardt", "MR"],
 "."
}], "ExampleText",
 CellID->149843105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"4", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "LevenbergMarquardt"}]}], "]"}]], "Input",
 CellTags->"FindMaximum::notlm",
 CellLabel->"In[2]:=",
 CellID->24984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.`"}], ",", 
     RowBox[{"y", "\[Rule]", "3.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->"FindMaximum::notlm",
 CellLabel->"Out[2]=",
 CellID->298613965]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMaximum::notlm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 54.2646970}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindMaximum::notlm", "synonyms" -> {}, "title" -> 
    "FindMaximum::notlm", "type" -> "Message", "uri" -> 
    "ref/message/notlm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1833, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->489175635]},
 "FindMaximum::notlm"->{
  Cell[2743, 104, 486, 16, 70, "Input",
   CellTags->"FindMaximum::notlm",
   CellID->32428],
  Cell[3232, 122, 340, 7, 70, "Message",
   CellTags->"FindMaximum::notlm",
   CellID->905759592],
  Cell[3575, 131, 498, 16, 70, "Output",
   CellTags->"FindMaximum::notlm",
   CellID->277879331],
  Cell[4275, 159, 519, 17, 70, "Input",
   CellTags->"FindMaximum::notlm",
   CellID->24984],
  Cell[4797, 178, 268, 9, 70, "Output",
   CellTags->"FindMaximum::notlm",
   CellID->298613965]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6054, 217},
 {"FindMaximum::notlm", 6198, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 56, 1, 70, "ObjectName",
 CellID->11588],
Cell[CellGroupData[{
Cell[784, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1262, 49, 307, 6, 70, "Message",
 CellID->173008883],
Cell[1572, 57, 224, 7, 70, "Notes",
 CellID->30776]
}, Closed]],
Cell[CellGroupData[{
Cell[1833, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->489175635],
Cell[CellGroupData[{
Cell[2218, 83, 148, 5, 70, "ExampleSection",
 CellID->225230335],
Cell[2369, 90, 349, 10, 70, "ExampleText",
 CellID->12983457],
Cell[CellGroupData[{
Cell[2743, 104, 486, 16, 70, "Input",
 CellTags->"FindMaximum::notlm",
 CellID->32428],
Cell[3232, 122, 340, 7, 70, "Message",
 CellTags->"FindMaximum::notlm",
 CellID->905759592],
Cell[3575, 131, 498, 16, 70, "Output",
 CellTags->"FindMaximum::notlm",
 CellID->277879331]
}, Open  ]],
Cell[4088, 150, 162, 5, 70, "ExampleText",
 CellID->149843105],
Cell[CellGroupData[{
Cell[4275, 159, 519, 17, 70, "Input",
 CellTags->"FindMaximum::notlm",
 CellID->24984],
Cell[4797, 178, 268, 9, 70, "Output",
 CellTags->"FindMaximum::notlm",
 CellID->298613965]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5104, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

