(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18473,        623]
NotebookOptionsPosition[      7507,        291]
NotebookOutlinePosition[     15860,        535]
CellTagsIndexPosition[     15632,        526]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::bbound
FindMaximum::bbound
FindFit::bbound
FindRoot::bbound\
\>", "ObjectName",
 CellID->11034],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bbound\"\>"}], ":", 
  " ", "\<\"Search region bound `1` for variable number `2` is not a number \
or Infinity.\"\>"}]], "Message", "MSG",
 CellID->11314144],

Cell["\<\
Generated when an expression that is not a number is  encountered in a \
position where the specification for the limits of the  search region is \
expected.\
\>", "Notes",
 CellID->12677],

Cell[TextData[{
 "The search specification is  the second argument in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ", and the third argument in ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258228942],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39558505],

Cell["\<\
An error occurs in this example because one of the limits on the search \
region is not a number.\
\>", "ExampleText",
 CellID->235411771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "4", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"In[1]:=",
 CellID->29798],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"bbound\"\>"}], ":", 
  " ", "\<\"Search region bound \\!\\(x\\) for variable number \\!\\(1\\) is \
not a number or Infinity.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->11635184],

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "4", ",", "x"}], "}"}]}], "]"}]], "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"Out[1]=",
 CellID->43341539]
}, Open  ]],

Cell[TextData[{
 "This shows a valid specification of limits on the search region in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellID->24444972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "4", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"In[2]:=",
 CellID->28028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4.712388980281876`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"Out[2]=",
 CellID->46212157]
}, Open  ]],

Cell["\<\
An error occurs in this example because the variables used to specify the \
limits on the search region do not have numerical values.\
\>", "ExampleText",
 CellID->348320846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "xmin", ",", "xmax"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"In[3]:=",
 CellID->11877],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"bbound\"\>"}], ":", 
  " ", "\<\"Search region bound \\!\\(xmin\\) for variable number \\!\\(1\\) \
is not a number or Infinity.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->623509153],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "xmin", ",", "xmax"}], "}"}]}], 
  "]"}]], "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"Out[3]=",
 CellID->212640307]
}, Open  ]],

Cell["\<\
A root is computed if numerical values are assigned for the symbolic \
parameters.\
\>", "ExampleText",
 CellID->292127602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"xmin", "=", "4"}], ",", 
     RowBox[{"xmax", "=", "8"}]}], "}"}], ",", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "6", ",", "xmin", ",", "xmax"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"In[4]:=",
 CellID->30438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "6.623022216633708`"}], "}"}]], "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellLabel->"Out[4]=",
 CellID->96525549]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::bbound - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 54.4365764}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FindMinimum::bbound FindMaximum::bbound FindFit::bbound \
FindRoot::bbound", "synonyms" -> {}, "title" -> "FindMinimum::bbound", "type" -> 
    "Message", "uri" -> "ref/message/bbound"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2442, 97, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->258228942]},
 "FindMinimum::bbound"->{
  Cell[3150, 126, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->29798],
  Cell[3484, 138, 336, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11635184],
  Cell[3823, 148, 335, 10, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->43341539],
  Cell[4454, 173, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->28028],
  Cell[4788, 185, 315, 11, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->46212157],
  Cell[5327, 207, 389, 13, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11877],
  Cell[5719, 222, 337, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->623509153],
  Cell[6059, 232, 400, 13, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->212640307],
  Cell[6632, 256, 563, 19, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->30438],
  Cell[7198, 277, 243, 7, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->96525549]},
 "FindMaximum::bbound"->{
  Cell[3150, 126, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->29798],
  Cell[3484, 138, 336, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11635184],
  Cell[3823, 148, 335, 10, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->43341539],
  Cell[4454, 173, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->28028],
  Cell[4788, 185, 315, 11, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->46212157],
  Cell[5327, 207, 389, 13, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11877],
  Cell[5719, 222, 337, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->623509153],
  Cell[6059, 232, 400, 13, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->212640307],
  Cell[6632, 256, 563, 19, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->30438],
  Cell[7198, 277, 243, 7, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->96525549]},
 "FindFit::bbound"->{
  Cell[3150, 126, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->29798],
  Cell[3484, 138, 336, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11635184],
  Cell[3823, 148, 335, 10, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->43341539],
  Cell[4454, 173, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->28028],
  Cell[4788, 185, 315, 11, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->46212157],
  Cell[5327, 207, 389, 13, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11877],
  Cell[5719, 222, 337, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->623509153],
  Cell[6059, 232, 400, 13, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->212640307],
  Cell[6632, 256, 563, 19, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->30438],
  Cell[7198, 277, 243, 7, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->96525549]},
 "FindRoot::bbound"->{
  Cell[3150, 126, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->29798],
  Cell[3484, 138, 336, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11635184],
  Cell[3823, 148, 335, 10, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->43341539],
  Cell[4454, 173, 331, 10, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->28028],
  Cell[4788, 185, 315, 11, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->46212157],
  Cell[5327, 207, 389, 13, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->11877],
  Cell[5719, 222, 337, 8, 70, "Message",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->623509153],
  Cell[6059, 232, 400, 13, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->212640307],
  Cell[6632, 256, 563, 19, 70, "Input",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->30438],
  Cell[7198, 277, 243, 7, 70, "Output",
   CellTags->{
    "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
     "FindRoot::bbound"},
   CellID->96525549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8489, 315},
 {"FindMinimum::bbound", 8634, 319},
 {"FindMaximum::bbound", 10386, 370},
 {"FindFit::bbound", 12134, 421},
 {"FindRoot::bbound", 13883, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 118, 6, 70, "ObjectName",
 CellID->11034],
Cell[CellGroupData[{
Cell[846, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1324, 54, 234, 6, 70, "Message",
 CellID->11314144],
Cell[1561, 62, 198, 5, 70, "Notes",
 CellID->12677],
Cell[1762, 69, 643, 23, 70, "Notes",
 CellID->32482]
}, Closed]],
Cell[CellGroupData[{
Cell[2442, 97, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258228942],
Cell[CellGroupData[{
Cell[2827, 111, 147, 5, 70, "ExampleSection",
 CellID->39558505],
Cell[2977, 118, 148, 4, 70, "ExampleText",
 CellID->235411771],
Cell[CellGroupData[{
Cell[3150, 126, 331, 10, 70, "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->29798],
Cell[3484, 138, 336, 8, 70, "Message",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->11635184],
Cell[3823, 148, 335, 10, 70, "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->43341539]
}, Open  ]],
Cell[4173, 161, 256, 8, 70, "ExampleText",
 CellID->24444972],
Cell[CellGroupData[{
Cell[4454, 173, 331, 10, 70, "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->28028],
Cell[4788, 185, 315, 11, 70, "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->46212157]
}, Open  ]],
Cell[5118, 199, 184, 4, 70, "ExampleText",
 CellID->348320846],
Cell[CellGroupData[{
Cell[5327, 207, 389, 13, 70, "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->11877],
Cell[5719, 222, 337, 8, 70, "Message",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->623509153],
Cell[6059, 232, 400, 13, 70, "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->212640307]
}, Open  ]],
Cell[6474, 248, 133, 4, 70, "ExampleText",
 CellID->292127602],
Cell[CellGroupData[{
Cell[6632, 256, 563, 19, 70, "Input",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->30438],
Cell[7198, 277, 243, 7, 70, "Output",
 CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
   "FindRoot::bbound"},
 CellID->96525549]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7480, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

