(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35590,       1055]
NotebookOptionsPosition[     18619,        534]
NotebookOutlinePosition[     31562,        918]
CellTagsIndexPosition[     31336,        909]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::cvmit
FindMaximum::cvmit
FindFit::cvmit
FindRoot::cvmit\
\>", "ObjectName",
 CellID->29982],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
`1` iterations.\"\>"}]], "Message", "MSG",
 CellID->361716111],

Cell["\<\
Generated when the indicated limit on the number of iterations is reached \
before finding a region that contain the requested result.\
\>", "Notes",
 CellID->20855],

Cell["\<\
This error can occur if the objective function does not have the required \
minimum, maximum, or root.\
\>", "Notes",
 CellID->26065],

Cell["\<\
This error can often be corrected by choosing better starting values.\
\>", "Notes",
 CellID->12627],

Cell["\<\
Good starting values can often be chosen by evaluating the function at \
selected points, or by looking at a plot of the function.\
\>", "Notes",
 CellID->21964]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313664362],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59259204],

Cell["\<\
An error occurs in this example because the starting value is not near the \
local minimum of this function.\
\>", "ExampleText",
 CellID->222384009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "-", 
    RowBox[{"2", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "x"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[1]:=",
 CellID->11087],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->699683276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.028039469000427`*^-14", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.6589141546643201`*^13"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[1]=",
 CellID->232315012]
}, Open  ]],

Cell["\<\
A minimum is computed without difficulty if the starting value is closer to \
the solution.\
\>", "ExampleText",
 CellID->91495690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "-", 
    RowBox[{"2", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "x"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[2]:=",
 CellID->17650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.22039530684791164`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.48796206549405`"}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[2]=",
 CellID->222526931]
}, Open  ]],

Cell["A plot of the function shows the location of the minimum.", \
"ExampleText",
 CellID->205277057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "-", 
    RowBox[{"2", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "x"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[3]:=",
 CellID->31304],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13k4VV0XAHDuaA5lbkCSZMpQQtYmIUmKMoQMUSGETHlF0SBKkrySVKZX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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0.19},
  PlotRange->{{1, 5}, {0.1865241081670622, 0.2642410960864161}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[3]=",
 CellID->158577836]
}, Open  ]],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " does not have a real root."
}], "ExampleText",
 CellID->4838431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[4]:=",
 CellID->7517],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->153190562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "14.499160234688846`"}], "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[4]=",
 CellID->53246488]
}, Open  ]],

Cell["\<\
A complex root of this equation can be computed by giving complex starting \
values.\
\>", "ExampleText",
 CellID->379295248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "I"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[5]:=",
 CellID->7389],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.49999999999999994`"}], "+", 
    RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[5]=",
 CellID->203763598]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[6]:=",
 CellID->27739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.49999999999999994`"}], "-", 
    RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[6]=",
 CellID->3374957]
}, Open  ]],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " does not have a minimum."
}], "ExampleText",
 CellID->186250096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"In[7]:=",
 CellID->560],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->416744481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8.354496338831304`*^16"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "8.354496338831304`*^16"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellLabel->"Out[7]=",
 CellID->227848174]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::cvmit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 54.6240812}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FindMinimum::cvmit FindMaximum::cvmit FindFit::cvmit FindRoot::cvmit", 
    "synonyms" -> {}, "title" -> "FindMinimum::cvmit", "type" -> "Message", 
    "uri" -> "ref/message/cvmit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2206, 88, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->313664362]},
 "FindMinimum::cvmit"->{
  Cell[2925, 117, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->11087],
  Cell[3328, 133, 331, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->699683276],
  Cell[3662, 143, 319, 10, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->232315012],
  Cell[4162, 164, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->17650],
  Cell[4565, 180, 307, 9, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->222526931],
  Cell[5014, 198, 403, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->31304],
  Cell[5420, 214, 8834, 153, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->158577836],
  Cell[14563, 382, 342, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7517],
  Cell[14908, 395, 328, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->153190562],
  Cell[15239, 405, 240, 7, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->53246488],
  Cell[15654, 423, 341, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7389],
  Cell[15998, 436, 344, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->203763598],
  Cell[16379, 452, 363, 12, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->27739],
  Cell[16745, 466, 342, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->3374957],
  Cell[17402, 492, 274, 9, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->560],
  Cell[17679, 503, 517, 11, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->416744481],
  Cell[18199, 516, 354, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->227848174]},
 "FindMaximum::cvmit"->{
  Cell[2925, 117, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->11087],
  Cell[3328, 133, 331, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->699683276],
  Cell[3662, 143, 319, 10, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->232315012],
  Cell[4162, 164, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->17650],
  Cell[4565, 180, 307, 9, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->222526931],
  Cell[5014, 198, 403, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->31304],
  Cell[5420, 214, 8834, 153, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->158577836],
  Cell[14563, 382, 342, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7517],
  Cell[14908, 395, 328, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->153190562],
  Cell[15239, 405, 240, 7, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->53246488],
  Cell[15654, 423, 341, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7389],
  Cell[15998, 436, 344, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->203763598],
  Cell[16379, 452, 363, 12, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->27739],
  Cell[16745, 466, 342, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->3374957],
  Cell[17402, 492, 274, 9, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->560],
  Cell[17679, 503, 517, 11, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->416744481],
  Cell[18199, 516, 354, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->227848174]},
 "FindFit::cvmit"->{
  Cell[2925, 117, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->11087],
  Cell[3328, 133, 331, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->699683276],
  Cell[3662, 143, 319, 10, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->232315012],
  Cell[4162, 164, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->17650],
  Cell[4565, 180, 307, 9, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->222526931],
  Cell[5014, 198, 403, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->31304],
  Cell[5420, 214, 8834, 153, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->158577836],
  Cell[14563, 382, 342, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7517],
  Cell[14908, 395, 328, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->153190562],
  Cell[15239, 405, 240, 7, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->53246488],
  Cell[15654, 423, 341, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7389],
  Cell[15998, 436, 344, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->203763598],
  Cell[16379, 452, 363, 12, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->27739],
  Cell[16745, 466, 342, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->3374957],
  Cell[17402, 492, 274, 9, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->560],
  Cell[17679, 503, 517, 11, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->416744481],
  Cell[18199, 516, 354, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->227848174]},
 "FindRoot::cvmit"->{
  Cell[2925, 117, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->11087],
  Cell[3328, 133, 331, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->699683276],
  Cell[3662, 143, 319, 10, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->232315012],
  Cell[4162, 164, 400, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->17650],
  Cell[4565, 180, 307, 9, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->222526931],
  Cell[5014, 198, 403, 14, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->31304],
  Cell[5420, 214, 8834, 153, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->158577836],
  Cell[14563, 382, 342, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7517],
  Cell[14908, 395, 328, 8, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->153190562],
  Cell[15239, 405, 240, 7, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->53246488],
  Cell[15654, 423, 341, 11, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->7389],
  Cell[15998, 436, 344, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->203763598],
  Cell[16379, 452, 363, 12, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->27739],
  Cell[16745, 466, 342, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->3374957],
  Cell[17402, 492, 274, 9, 70, "Input",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->560],
  Cell[17679, 503, 517, 11, 70, "Message",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->416744481],
  Cell[18199, 516, 354, 11, 70, "Output",
   CellTags->{
    "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
     "FindRoot::cvmit"},
   CellID->227848174]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19597, 558},
 {"FindMinimum::cvmit", 19741, 562},
 {"FindMaximum::cvmit", 22642, 648},
 {"FindFit::cvmit", 25539, 734},
 {"FindRoot::cvmit", 28437, 820}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 114, 6, 70, "ObjectName",
 CellID->29982],
Cell[CellGroupData[{
Cell[842, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1320, 54, 238, 6, 70, "Message",
 CellID->361716111],
Cell[1561, 62, 175, 4, 70, "Notes",
 CellID->20855],
Cell[1739, 68, 143, 4, 70, "Notes",
 CellID->26065],
Cell[1885, 74, 110, 3, 70, "Notes",
 CellID->12627],
Cell[1998, 79, 171, 4, 70, "Notes",
 CellID->21964]
}, Closed]],
Cell[CellGroupData[{
Cell[2206, 88, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313664362],
Cell[CellGroupData[{
Cell[2591, 102, 147, 5, 70, "ExampleSection",
 CellID->59259204],
Cell[2741, 109, 159, 4, 70, "ExampleText",
 CellID->222384009],
Cell[CellGroupData[{
Cell[2925, 117, 400, 14, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->11087],
Cell[3328, 133, 331, 8, 70, "Message",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->699683276],
Cell[3662, 143, 319, 10, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->232315012]
}, Open  ]],
Cell[3996, 156, 141, 4, 70, "ExampleText",
 CellID->91495690],
Cell[CellGroupData[{
Cell[4162, 164, 400, 14, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->17650],
Cell[4565, 180, 307, 9, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->222526931]
}, Open  ]],
Cell[4887, 192, 102, 2, 70, "ExampleText",
 CellID->205277057],
Cell[CellGroupData[{
Cell[5014, 198, 403, 14, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->31304],
Cell[5420, 214, 8834, 153, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->158577836]
}, Open  ]],
Cell[14269, 370, 269, 8, 70, "ExampleText",
 CellID->4838431],
Cell[CellGroupData[{
Cell[14563, 382, 342, 11, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->7517],
Cell[14908, 395, 328, 8, 70, "Message",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->153190562],
Cell[15239, 405, 240, 7, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->53246488]
}, Open  ]],
Cell[15494, 415, 135, 4, 70, "ExampleText",
 CellID->379295248],
Cell[CellGroupData[{
Cell[15654, 423, 341, 11, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->7389],
Cell[15998, 436, 344, 11, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->203763598]
}, Open  ]],
Cell[CellGroupData[{
Cell[16379, 452, 363, 12, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->27739],
Cell[16745, 466, 342, 11, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->3374957]
}, Open  ]],
Cell[17102, 480, 275, 8, 70, "ExampleText",
 CellID->186250096],
Cell[CellGroupData[{
Cell[17402, 492, 274, 9, 70, "Input",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->560],
Cell[17679, 503, 517, 11, 70, "Message",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->416744481],
Cell[18199, 516, 354, 11, 70, "Output",
 CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
   "FindRoot::cvmit"},
 CellID->227848174]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18592, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

