(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11928,        414]
NotebookOptionsPosition[      5646,        215]
NotebookOutlinePosition[     10361,        359]
CellTagsIndexPosition[     10144,        350]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::fdin
FindMaximum::fdin
FindFit::fdin
FindRoot::fdin\
\>", "ObjectName",
 CellID->4654],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"fdin\"\>"}], ":", 
  " ", "\<\"Form of start specification `1` in `2` is inconsistent with other \
start specifications.\"\>"}]], "Message", "MSG",
 CellID->850306928],

Cell[TextData[{
 "Generated in multidimensional ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " when one starting value is specified for some of the variables and two  \
starting values are specified for other variables."
}], "Notes",
 CellID->7340],

Cell["\<\
 Different algorithms are used depending on whether the variables are  \
specified with one starting value or with two starting values.\
\>", "Notes",
 CellID->32117]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404604696],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->329543526],

Cell["\<\
An error occurs in this example because the first variable is specified with \
one starting value and the second variable is specified with two starting \
values.\
\>", "ExampleText",
 CellID->204248970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "8", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellLabel->"In[1]:=",
 CellID->5125],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"fdin\"\>"}], ":", 
  " ", "\<\"Form of start specification \\!\\({y, 8, 9}\\) in \
\\!\\(FindMinimum[\\(\\(\\(\\(\\(\\(Sin[x]\\)\\) + \\(\\(Sin[y]\\)\\)\\)\\), \
\\(\\({x, 4}\\)\\), \\(\\({y, 8, 9}\\)\\)\\)\\)]\\) is inconsistent with \
other start specifications.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->978570420],

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "8", ",", "9"}], "}"}]}], "]"}]], "Output",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellLabel->"Out[1]=",
 CellID->370757220]
}, Open  ]],

Cell[TextData[{
 "This shows valid start specifications in ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->90288130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", " ", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "8", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellLabel->"In[2]:=",
 CellID->8077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4.712388982594708`"}], ",", 
     RowBox[{"y", "\[Rule]", "10.995574286903649`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellLabel->"Out[2]=",
 CellID->39900610]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::fdin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 55.0147162}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FindMinimum::fdin FindMaximum::fdin FindFit::fdin FindRoot::fdin", 
    "synonyms" -> {}, "title" -> "FindMinimum::fdin", "type" -> "Message", 
    "uri" -> "ref/message/fdin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2371, 92, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->404604696]},
 "FindMinimum::fdin"->{
  Cell[3145, 122, 428, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->5125],
  Cell[3576, 138, 468, 10, 70, "Message",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->978570420],
  Cell[4047, 150, 434, 14, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->370757220],
  Cell[4750, 179, 443, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->8077],
  Cell[5196, 195, 384, 13, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->39900610]},
 "FindMaximum::fdin"->{
  Cell[3145, 122, 428, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->5125],
  Cell[3576, 138, 468, 10, 70, "Message",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->978570420],
  Cell[4047, 150, 434, 14, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->370757220],
  Cell[4750, 179, 443, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->8077],
  Cell[5196, 195, 384, 13, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->39900610]},
 "FindFit::fdin"->{
  Cell[3145, 122, 428, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->5125],
  Cell[3576, 138, 468, 10, 70, "Message",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->978570420],
  Cell[4047, 150, 434, 14, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->370757220],
  Cell[4750, 179, 443, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->8077],
  Cell[5196, 195, 384, 13, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->39900610]},
 "FindRoot::fdin"->{
  Cell[3145, 122, 428, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->5125],
  Cell[3576, 138, 468, 10, 70, "Message",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->978570420],
  Cell[4047, 150, 434, 14, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->370757220],
  Cell[4750, 179, 443, 14, 70, "Input",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->8077],
  Cell[5196, 195, 384, 13, 70, "Output",
   CellTags->{
    "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
     "FindRoot::fdin"},
   CellID->39900610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6617, 239},
 {"FindMinimum::fdin", 6760, 243},
 {"FindMaximum::fdin", 7608, 269},
 {"FindFit::fdin", 8452, 295},
 {"FindRoot::fdin", 9297, 321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 109, 6, 70, "ObjectName",
 CellID->4654],
Cell[CellGroupData[{
Cell[837, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1315, 54, 244, 6, 70, "Message",
 CellID->850306928],
Cell[1562, 62, 593, 19, 70, "Notes",
 CellID->7340],
Cell[2158, 83, 176, 4, 70, "Notes",
 CellID->32117]
}, Closed]],
Cell[CellGroupData[{
Cell[2371, 92, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404604696],
Cell[CellGroupData[{
Cell[2756, 106, 148, 5, 70, "ExampleSection",
 CellID->329543526],
Cell[2907, 113, 213, 5, 70, "ExampleText",
 CellID->204248970],
Cell[CellGroupData[{
Cell[3145, 122, 428, 14, 70, "Input",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->5125],
Cell[3576, 138, 468, 10, 70, "Message",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->978570420],
Cell[4047, 150, 434, 14, 70, "Output",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->370757220]
}, Open  ]],
Cell[4496, 167, 229, 8, 70, "ExampleText",
 CellID->90288130],
Cell[CellGroupData[{
Cell[4750, 179, 443, 14, 70, "Input",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->8077],
Cell[5196, 195, 384, 13, 70, "Output",
 CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
   "FindRoot::fdin"},
 CellID->39900610]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5619, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

