(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6696,        235]
NotebookOptionsPosition[      4227,        154]
NotebookOutlinePosition[      5728,        200]
CellTagsIndexPosition[      5608,        194]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FindMinimum::lstol", "ObjectName",
 CellID->2691],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than `1` digits of \
working precision to meet these tolerances.\"\>"}]], "Message", "MSG",
 CellID->11977910],

Cell[TextData[{
 "Generated when the tolerances specified through the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " options cannot be reached using the indicated working precision. "
}], "Notes",
 CellID->22020],

Cell["\<\
This message can be generated if the objective function  is singular or has \
other sharp features.\
\>", "Notes",
 CellID->26335]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->815661942],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->121833288],

Cell["\<\
A warning message is generated in this example because the objective function \
does not have a smooth minimum.\
\>", "ExampleText",
 CellID->229343462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6"}], "}"}], ",", 
   RowBox[{"Gradient", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sign", "[", 
       RowBox[{"Sin", "[", "x", "]"}], "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"FindMinimum::lstol",
 CellLabel->"In[1]:=",
 CellID->12321],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG",
 CellTags->"FindMinimum::lstol",
 CellID->137691267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.084141158371281`*^-15", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "6.283185307179592`"}], "}"}]}], "}"}]], "Output",\

 CellTags->"FindMinimum::lstol",
 CellLabel->"Out[1]=",
 CellID->47597348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::lstol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 10.2807320}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindMinimum::lstol", "synonyms" -> {}, "title" -> 
    "FindMinimum::lstol", "type" -> "Message", "uri" -> 
    "ref/message/lstol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2271, 82, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->815661942]},
 "FindMinimum::lstol"->{
  Cell[2994, 111, 468, 15, 70, "Input",
   CellTags->"FindMinimum::lstol",
   CellID->12321],
  Cell[3465, 128, 449, 9, 70, "Message",
   CellTags->"FindMinimum::lstol",
   CellID->137691267],
  Cell[3917, 139, 244, 8, 70, "Output",
   CellTags->"FindMinimum::lstol",
   CellID->47597348]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5150, 177},
 {"FindMinimum::lstol", 5294, 181}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->2691],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 391, 7, 70, "Message",
 CellID->11977910],
Cell[1655, 58, 436, 13, 70, "Notes",
 CellID->22020],
Cell[2094, 73, 140, 4, 70, "Notes",
 CellID->26335]
}, Closed]],
Cell[CellGroupData[{
Cell[2271, 82, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->815661942],
Cell[CellGroupData[{
Cell[2656, 96, 148, 5, 70, "ExampleSection",
 CellID->121833288],
Cell[2807, 103, 162, 4, 70, "ExampleText",
 CellID->229343462],
Cell[CellGroupData[{
Cell[2994, 111, 468, 15, 70, "Input",
 CellTags->"FindMinimum::lstol",
 CellID->12321],
Cell[3465, 128, 449, 9, 70, "Message",
 CellTags->"FindMinimum::lstol",
 CellID->137691267],
Cell[3917, 139, 244, 8, 70, "Output",
 CellTags->"FindMinimum::lstol",
 CellID->47597348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4200, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

