(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11326,        395]
NotebookOptionsPosition[      4931,        196]
NotebookOutlinePosition[      9741,        340]
CellTagsIndexPosition[      9520,        331]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::regex
FindMaximum::regex
FindFit::regex
FindRoot::regex\
\>", "ObjectName",
 CellID->28811],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"regex\"\>"}], ":", 
  " ", "\<\"Reached the point `1`, which is outside the region `2`.\"\>"}]], \
"Message", "MSG",
 CellID->77185069],

Cell["\<\
Generated when the algorithm used by the indicated  function reaches a point \
that is outside of the region specified in the  input.\
\>", "Notes",
 CellID->1516],

Cell[TextData[{
 "Limits can be specified for a search region by  using a limit specification \
of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[", ", "MR"],
 StyleBox["xstart", "MR",
  FontSlant->"Italic"],
 StyleBox[", ", "MR"],
 StyleBox["xmin", "MR",
  FontSlant->"Italic"],
 StyleBox[", ", "MR"],
 StyleBox["xmax", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 "."
}], "Notes",
 CellID->23990]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100126597],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4920198],

Cell["\<\
An error occurs in this example because the function does not have a minimum \
in the search region.\
\>", "ExampleText",
 CellID->563532551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "7", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Gradient"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellLabel->"In[1]:=",
 CellID->5193],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"regex\"\>"}], ":", 
  " ", "\<\"Reached the point \\!\\({\\(-3.183992740466497`\\)}\\), which is \
outside the region \\!\\({\\(\\({6.`}\\)\\), \\(\\({8.`}\\)\\)}\\).\"\>"}]], \
"Message", "MSG",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->111291361],

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "7", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Gradient"}]}], "]"}]], "Output",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellLabel->"Out[1]=",
 CellID->29848631]
}, Open  ]],

Cell["\<\
A solution is computed without difficulty if the search region includes a \
minimum.\
\>", "ExampleText",
 CellID->40646376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "7", ",", "4", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellLabel->"In[2]:=",
 CellID->13609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4.712388980365375`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellLabel->"Out[2]=",
 CellID->223735859]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::regex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 10.7182432}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FindMinimum::regex FindMaximum::regex FindFit::regex FindRoot::regex", 
    "synonyms" -> {}, "title" -> "FindMinimum::regex", "type" -> "Message", 
    "uri" -> "ref/message/regex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2196, 91, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->100126597]},
 "FindMinimum::regex"->{
  Cell[2906, 120, 378, 11, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->5193],
  Cell[3287, 133, 376, 9, 70, "Message",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->111291361],
  Cell[3666, 144, 383, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->29848631],
  Cell[4223, 166, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->13609],
  Cell[4553, 178, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->223735859]},
 "FindMaximum::regex"->{
  Cell[2906, 120, 378, 11, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->5193],
  Cell[3287, 133, 376, 9, 70, "Message",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->111291361],
  Cell[3666, 144, 383, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->29848631],
  Cell[4223, 166, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->13609],
  Cell[4553, 178, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->223735859]},
 "FindFit::regex"->{
  Cell[2906, 120, 378, 11, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->5193],
  Cell[3287, 133, 376, 9, 70, "Message",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->111291361],
  Cell[3666, 144, 383, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->29848631],
  Cell[4223, 166, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->13609],
  Cell[4553, 178, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->223735859]},
 "FindRoot::regex"->{
  Cell[2906, 120, 378, 11, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->5193],
  Cell[3287, 133, 376, 9, 70, "Message",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->111291361],
  Cell[3666, 144, 383, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->29848631],
  Cell[4223, 166, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->13609],
  Cell[4553, 178, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
     "FindRoot::regex"},
   CellID->223735859]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5909, 220},
 {"FindMinimum::regex", 6053, 224},
 {"FindMaximum::regex", 6922, 250},
 {"FindFit::regex", 7787, 276},
 {"FindRoot::regex", 8653, 302}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 114, 6, 70, "ObjectName",
 CellID->28811],
Cell[CellGroupData[{
Cell[842, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1320, 54, 212, 6, 70, "Message",
 CellID->77185069],
Cell[1535, 62, 173, 4, 70, "Notes",
 CellID->1516],
Cell[1711, 68, 448, 18, 70, "Notes",
 CellID->23990]
}, Closed]],
Cell[CellGroupData[{
Cell[2196, 91, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100126597],
Cell[CellGroupData[{
Cell[2581, 105, 146, 5, 70, "ExampleSection",
 CellID->4920198],
Cell[2730, 112, 151, 4, 70, "ExampleText",
 CellID->563532551],
Cell[CellGroupData[{
Cell[2906, 120, 378, 11, 70, "Input",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->5193],
Cell[3287, 133, 376, 9, 70, "Message",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->111291361],
Cell[3666, 144, 383, 11, 70, "Output",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->29848631]
}, Open  ]],
Cell[4064, 158, 134, 4, 70, "ExampleText",
 CellID->40646376],
Cell[CellGroupData[{
Cell[4223, 166, 327, 10, 70, "Input",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->13609],
Cell[4553, 178, 312, 11, 70, "Output",
 CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
   "FindRoot::regex"},
 CellID->223735859]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4904, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

