(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8454,        316]
NotebookOptionsPosition[      4935,        198]
NotebookOutlinePosition[      6873,        258]
CellTagsIndexPosition[      6756,        252]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FindRoot::jsing", "ObjectName",
 CellID->342],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"jsing\"\>"}], ":", 
  " ", "\<\"Encountered a singular Jacobian at the point `1` = `2`. Try \
perturbing the initial point(s).\"\>"}]], "Message", "MSG",
 CellID->240365805],

Cell[TextData[{
 "Generated when the derivatives of the first argument  in ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " are singular at the indicated point."
}], "Notes",
 CellID->31740],

Cell["\<\
This error can  occur if the starting point is a minimum or a maximum of one \
of the functions  for which roots are to be computed.\
\>", "Notes",
 CellID->54]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->549803180],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->214294193],

Cell["\<\
An error occurs in this example because the starting point is a minimum of \
the function in the first argument.\
\>", "ExampleText",
 CellID->117541636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "3"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::jsing",
 CellLabel->"In[1]:=",
 CellID->28290],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"jsing\"\>"}], ":", 
  " ", "\<\"Encountered a singular Jacobian at the point \\!\\({x}\\) = \
\\!\\({0.`}\\). Try perturbing the initial point(s).\"\>"}]], "Message", \
"MSG",
 CellTags->"FindRoot::jsing",
 CellID->94152581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.`"}], "}"}]], "Output",
 CellTags->"FindRoot::jsing",
 CellLabel->"Out[1]=",
 CellID->443412868]
}, Open  ]],

Cell["\<\
A root is found without difficulty if a different starting value is used.\
\>", "ExampleText",
 CellID->4347968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "3"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::jsing",
 CellLabel->"In[2]:=",
 CellID->21049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.7320508075688772`"}], "}"}]], "Output",
 CellTags->"FindRoot::jsing",
 CellLabel->"Out[2]=",
 CellID->336833148]
}, Open  ]],

Cell["\<\
This error can also occur if the first argument is constant.  The function in \
this example does not have a root.\
\>", "ExampleText",
 CellID->36198413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::jsing",
 CellLabel->"In[3]:=",
 CellID->18320],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"jsing\"\>"}], ":", 
  " ", "\<\"Encountered a singular Jacobian at the point \\!\\({x}\\) = \
\\!\\({1.`}\\). Try perturbing the initial point(s).\"\>"}]], "Message", \
"MSG",
 CellTags->"FindRoot::jsing",
 CellID->601819998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.`"}], "}"}]], "Output",
 CellTags->"FindRoot::jsing",
 CellLabel->"Out[3]=",
 CellID->64572221]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindRoot::jsing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 26.7655290}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindRoot::jsing", "synonyms" -> {}, "title" -> 
    "FindRoot::jsing", "type" -> "Message", "uri" -> "ref/message/jsing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1966, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->549803180]},
 "FindRoot::jsing"->{
  Cell[2690, 104, 278, 10, 70, "Input",
   CellTags->"FindRoot::jsing",
   CellID->28290],
  Cell[2971, 116, 281, 7, 70, "Message",
   CellTags->"FindRoot::jsing",
   CellID->94152581],
  Cell[3255, 125, 154, 5, 70, "Output",
   CellTags->"FindRoot::jsing",
   CellID->443412868],
  Cell[3571, 140, 278, 10, 70, "Input",
   CellTags->"FindRoot::jsing",
   CellID->21049],
  Cell[3852, 152, 170, 5, 70, "Output",
   CellTags->"FindRoot::jsing",
   CellID->336833148],
  Cell[4226, 168, 202, 7, 70, "Input",
   CellTags->"FindRoot::jsing",
   CellID->18320],
  Cell[4431, 177, 282, 7, 70, "Message",
   CellTags->"FindRoot::jsing",
   CellID->601819998],
  Cell[4716, 186, 153, 5, 70, "Output",
   CellTags->"FindRoot::jsing",
   CellID->64572221]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5844, 220},
 {"FindRoot::jsing", 5985, 224}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->342],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 230, 5, 70, "Message",
 CellID->240365805],
Cell[1490, 56, 266, 8, 70, "Notes",
 CellID->31740],
Cell[1759, 66, 170, 4, 70, "Notes",
 CellID->54]
}, Closed]],
Cell[CellGroupData[{
Cell[1966, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->549803180],
Cell[CellGroupData[{
Cell[2351, 89, 148, 5, 70, "ExampleSection",
 CellID->214294193],
Cell[2502, 96, 163, 4, 70, "ExampleText",
 CellID->117541636],
Cell[CellGroupData[{
Cell[2690, 104, 278, 10, 70, "Input",
 CellTags->"FindRoot::jsing",
 CellID->28290],
Cell[2971, 116, 281, 7, 70, "Message",
 CellTags->"FindRoot::jsing",
 CellID->94152581],
Cell[3255, 125, 154, 5, 70, "Output",
 CellTags->"FindRoot::jsing",
 CellID->443412868]
}, Open  ]],
Cell[3424, 133, 122, 3, 70, "ExampleText",
 CellID->4347968],
Cell[CellGroupData[{
Cell[3571, 140, 278, 10, 70, "Input",
 CellTags->"FindRoot::jsing",
 CellID->21049],
Cell[3852, 152, 170, 5, 70, "Output",
 CellTags->"FindRoot::jsing",
 CellID->336833148]
}, Open  ]],
Cell[4037, 160, 164, 4, 70, "ExampleText",
 CellID->36198413],
Cell[CellGroupData[{
Cell[4226, 168, 202, 7, 70, "Input",
 CellTags->"FindRoot::jsing",
 CellID->18320],
Cell[4431, 177, 282, 7, 70, "Message",
 CellTags->"FindRoot::jsing",
 CellID->601819998],
Cell[4716, 186, 153, 5, 70, "Output",
 CellTags->"FindRoot::jsing",
 CellID->64572221]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4908, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

