(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7404,        281]
NotebookOptionsPosition[      4601,        187]
NotebookOutlinePosition[      6238,        238]
CellTagsIndexPosition[      6123,        232]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::bmod", "ObjectName",
 CellID->20620],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"bmod\"\>"}], ":", 
  " ", "\<\"Modulus `1` must be an integer or an irreducible univariate \
polynomial.\"\>"}]], "Message", "MSG",
 CellID->21770328],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and related functions does not have the expected form."
}], "Notes",
 CellID->31082]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->801268930],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->134477619],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option is not irreducible."
}], "ExampleText",
 CellID->739714745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"3", "x"}], "+", "5"}], ",", 
   RowBox[{"Modulus", "->", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "1"}]}]}], "]"}]], "Input",
 CellTags->"General::bmod",
 CellLabel->"In[1]:=",
 CellID->6436],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"bmod\"\>"}], ":", 
  " ", "\<\"Modulus \\!\\(\\(\\(-1\\)\\) + x\\^2\\) must be an integer or an \
irreducible univariate polynomial.\"\>"}]], "Message", "MSG",
 CellTags->"General::bmod",
 CellID->43771040],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"5", "+", 
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}]}]}], "]"}]], "Output",
 CellTags->"General::bmod",
 CellLabel->"Out[1]=",
 CellID->115740916]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->7308918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"3", "x"}], "+", "5"}], ",", 
   RowBox[{"Modulus", "->", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}]}]}], "]"}]], "Input",
 CellTags->"General::bmod",
 CellLabel->"In[2]:=",
 CellID->15946],

Cell[BoxData[
 RowBox[{"5", "+", "x"}]], "Output",
 CellTags->"General::bmod",
 CellLabel->"Out[2]=",
 CellID->726226285]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::bmod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 3, 54.2677690}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::bmod", "synonyms" -> {}, "title" -> 
    "General::bmod", "type" -> "Message", "uri" -> "ref/message/bmod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1891, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->801268930]},
 "General::bmod"->{
  Cell[2716, 107, 335, 12, 70, "Input",
   CellTags->"General::bmod",
   CellID->6436],
  Cell[3054, 121, 261, 6, 70, "Message",
   CellTags->"General::bmod",
   CellID->43771040],
  Cell[3318, 129, 374, 13, 70, "Output",
   CellTags->"General::bmod",
   CellID->115740916],
  Cell[4075, 162, 336, 12, 70, "Input",
   CellTags->"General::bmod",
   CellID->15946],
  Cell[4414, 176, 121, 4, 70, "Output",
   CellTags->"General::bmod",
   CellID->726226285]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5503, 209},
 {"General::bmod", 5642, 213}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->20620],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 206, 5, 70, "Message",
 CellID->21770328],
Cell[1466, 56, 388, 13, 70, "Notes",
 CellID->31082]
}, Closed]],
Cell[CellGroupData[{
Cell[1891, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->801268930],
Cell[CellGroupData[{
Cell[2276, 88, 148, 5, 70, "ExampleSection",
 CellID->134477619],
Cell[2427, 95, 264, 8, 70, "ExampleText",
 CellID->739714745],
Cell[CellGroupData[{
Cell[2716, 107, 335, 12, 70, "Input",
 CellTags->"General::bmod",
 CellID->6436],
Cell[3054, 121, 261, 6, 70, "Message",
 CellTags->"General::bmod",
 CellID->43771040],
Cell[3318, 129, 374, 13, 70, "Output",
 CellTags->"General::bmod",
 CellID->115740916]
}, Open  ]],
Cell[3707, 145, 343, 13, 70, "ExampleText",
 CellID->7308918],
Cell[CellGroupData[{
Cell[4075, 162, 336, 12, 70, "Input",
 CellTags->"General::bmod",
 CellID->15946],
Cell[4414, 176, 121, 4, 70, "Output",
 CellTags->"General::bmod",
 CellID->726226285]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4574, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

