(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8784,        333]
NotebookOptionsPosition[      5000,        205]
NotebookOutlinePosition[      7095,        271]
CellTagsIndexPosition[      6980,        265]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::infy", "ObjectName",
 CellID->459],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression `1` encountered.\"\>"}]], "Message", "MSG",
 CellID->300433684],

Cell[TextData[{
 "This message is generated if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encounters division by zero."
}], "Notes",
 CellID->23690]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93370370],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->930169557],

Cell["Explicit division by zero will generate a warning message.", \
"ExampleText",
 CellID->83299700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellTags->"General::infy",
 CellLabel->"In[1]:=",
 CellID->10229],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered.\"\>"}]], "Message",\
 "MSG",
 CellTags->"General::infy",
 CellID->33584102],

Cell[BoxData["ComplexInfinity"], "Output",
 CellTags->"General::infy",
 CellLabel->"Out[1]=",
 CellID->36951568]
}, Open  ]],

Cell["\<\
Division by zero often occurs indirectly within another calculation.\
\>", "ExampleText",
 CellID->111998315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::infy",
 CellLabel->"In[2]:=",
 CellID->15874],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0.`\\) encountered.\"\>"}]], \
"Message", "MSG",
 CellTags->"General::infy",
 CellID->56969601],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0.`\\\\ ComplexInfinity\\) \
encountered.\"\>"}]], "Message", "MSG",
 CellTags->"General::infy",
 CellID->555755890],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"The function value \\!\\({Indeterminate}\\) is not a list of \
numbers with dimensions \\!\\({1}\\) at \\!\\({x}\\) = \
\\!\\({0.`}\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::infy",
 CellID->43863013],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], "x"], "\[Equal]", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::infy",
 CellLabel->"Out[2]=",
 CellID->475882755]
}, Open  ]],

Cell["\<\
The root in this example can be computed by choosing a different starting \
point.\
\>", "ExampleText",
 CellID->563729485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::infy",
 CellLabel->"In[3]:=",
 CellID->27078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.8954942670339807`"}], "}"}]], "Output",
 CellTags->"General::infy",
 CellLabel->"Out[3]=",
 CellID->216934850]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::infy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 4, 34.7844312}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::infy", "synonyms" -> {}, "title" -> 
    "General::infy", "type" -> "Message", "uri" -> "ref/message/infy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1625, 66, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->93370370]},
 "General::infy"->{
  Cell[2287, 93, 116, 4, 70, "Input",
   CellTags->"General::infy",
   CellID->10229],
  Cell[2406, 99, 208, 6, 70, "Message",
   CellTags->"General::infy",
   CellID->33584102],
  Cell[2617, 107, 112, 3, 70, "Output",
   CellTags->"General::infy",
   CellID->36951568],
  Cell[2888, 120, 314, 11, 70, "Input",
   CellTags->"General::infy",
   CellID->15874],
  Cell[3205, 133, 210, 6, 70, "Message",
   CellTags->"General::infy",
   CellID->56969601],
  Cell[3418, 141, 239, 6, 70, "Message",
   CellTags->"General::infy",
   CellID->555755890],
  Cell[3660, 149, 298, 7, 70, "Message",
   CellTags->"General::infy",
   CellID->43863013],
  Cell[3961, 158, 315, 11, 70, "Output",
   CellTags->"General::infy",
   CellID->475882755],
  Cell[4449, 180, 314, 11, 70, "Input",
   CellTags->"General::infy",
   CellID->27078],
  Cell[4766, 193, 168, 5, 70, "Output",
   CellTags->"General::infy",
   CellID->216934850]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5902, 227},
 {"General::infy", 6040, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->459],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 170, 4, 70, "Message",
 CellID->300433684],
Cell[1428, 55, 160, 6, 70, "Notes",
 CellID->23690]
}, Closed]],
Cell[CellGroupData[{
Cell[1625, 66, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93370370],
Cell[CellGroupData[{
Cell[2009, 80, 148, 5, 70, "ExampleSection",
 CellID->930169557],
Cell[2160, 87, 102, 2, 70, "ExampleText",
 CellID->83299700],
Cell[CellGroupData[{
Cell[2287, 93, 116, 4, 70, "Input",
 CellTags->"General::infy",
 CellID->10229],
Cell[2406, 99, 208, 6, 70, "Message",
 CellTags->"General::infy",
 CellID->33584102],
Cell[2617, 107, 112, 3, 70, "Output",
 CellTags->"General::infy",
 CellID->36951568]
}, Open  ]],
Cell[2744, 113, 119, 3, 70, "ExampleText",
 CellID->111998315],
Cell[CellGroupData[{
Cell[2888, 120, 314, 11, 70, "Input",
 CellTags->"General::infy",
 CellID->15874],
Cell[3205, 133, 210, 6, 70, "Message",
 CellTags->"General::infy",
 CellID->56969601],
Cell[3418, 141, 239, 6, 70, "Message",
 CellTags->"General::infy",
 CellID->555755890],
Cell[3660, 149, 298, 7, 70, "Message",
 CellTags->"General::infy",
 CellID->43863013],
Cell[3961, 158, 315, 11, 70, "Output",
 CellTags->"General::infy",
 CellID->475882755]
}, Open  ]],
Cell[4291, 172, 133, 4, 70, "ExampleText",
 CellID->563729485],
Cell[CellGroupData[{
Cell[4449, 180, 314, 11, 70, "Input",
 CellTags->"General::infy",
 CellID->27078],
Cell[4766, 193, 168, 5, 70, "Output",
 CellTags->"General::infy",
 CellID->216934850]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4973, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

