(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11685,        445]
NotebookOptionsPosition[      7155,        291]
NotebookOutlinePosition[      9542,        366]
CellTagsIndexPosition[      9426,        360]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::iterb", "ObjectName",
 CellID->14348],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"iterb\"\>"}], ":", 
  " ", "\<\"Iterator `1` does not have appropriate bounds.\"\>"}]], "Message",\
 "MSG",
 CellID->107656670],

Cell["\<\
Generated when an iterator specification includes an  invalid lower limit, \
upper limit, or step size.\
\>", "Notes",
 CellID->26835],

Cell[TextData[{
 " Iterators are used in ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 ", and other functions that perform explicit iteration."
}], "Notes",
 CellID->16680]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126863165],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->68532589],

Cell["\<\
An error occurs in this example because the limit does not evaluate to a real \
number.\
\>", "ExampleText",
 CellID->399780382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "kmax"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::iterb",
 CellLabel->"In[1]:=",
 CellID->18190],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "::", "\<\"iterb\"\>"}], ":", 
  " ", "\<\"Iterator \\!\\({k, kmax}\\) does not have appropriate \
bounds.\"\>"}]], "Message", "MSG",
 CellTags->"General::iterb",
 CellID->6596384],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "kmax"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::iterb",
 CellLabel->"Out[1]=",
 CellID->312330170]
}, Open  ]],

Cell[TextData[{
 "This shows a valid iteration specification in ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->11386337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kmax", "=", "10"}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "kmax"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"General::iterb",
 CellLabel->"In[2]:=",
 CellID->9193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 CellTags->"General::iterb",
 CellLabel->"Out[2]=",
 CellID->304820803]
}, Open  ]],

Cell["\<\
An error occurs in this example because the iteration bound is not a real \
number and so cannot be reached using the default step size (the default step \
size is 1).\
\>", "ExampleText",
 CellID->363810368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<z = \>\"", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", 
     RowBox[{"3", "I"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"General::iterb",
 CellLabel->"In[3]:=",
 CellID->26347],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "::", "\<\"iterb\"\>"}], ":", 
  " ", "\<\"Iterator \\!\\({z, 0, \\(\\(3\\\\ \[ImaginaryI]\\)\\)}\\) does \
not have appropriate bounds.\"\>"}]], "Message", "MSG",
 CellTags->"General::iterb",
 CellID->275331479],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\<\"z = \"\>", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", 
     RowBox[{"3", " ", "\[ImaginaryI]"}]}], "}"}]}], "]"}]], "Output",
 CellTags->"General::iterb",
 CellLabel->"Out[3]=",
 CellID->256673864]
}, Open  ]],

Cell["\<\
This shows a valid iteration specification using a complex step size.\
\>", "ExampleText",
 CellID->52937491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<z = \>\"", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", 
     RowBox[{"3", "I"}], ",", "I"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::iterb",
 CellLabel->"In[4]:=",
 CellID->15823],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["z = ", 0],
  Editable->False]], "Print",
 CellTags->"General::iterb",
 CellLabel->"During evaluation of In[4]:=",
 CellID->472663276],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = \"\>", "\[InvisibleSpace]", "\[ImaginaryI]"}],
  SequenceForm["z = ", 
   Complex[0, 1]],
  Editable->False]], "Print",
 CellTags->"General::iterb",
 CellLabel->"During evaluation of In[4]:=",
 CellID->339642338],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = \"\>", "\[InvisibleSpace]", 
   RowBox[{"2", " ", "\[ImaginaryI]"}]}],
  SequenceForm["z = ", 
   Complex[0, 2]],
  Editable->False]], "Print",
 CellTags->"General::iterb",
 CellLabel->"During evaluation of In[4]:=",
 CellID->169617372],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = \"\>", "\[InvisibleSpace]", 
   RowBox[{"3", " ", "\[ImaginaryI]"}]}],
  SequenceForm["z = ", 
   Complex[0, 3]],
  Editable->False]], "Print",
 CellTags->"General::iterb",
 CellLabel->"During evaluation of In[4]:=",
 CellID->758696477]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::iterb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 4, 51.0817234}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::iterb", "synonyms" -> {}, "title" -> 
    "General::iterb", "type" -> "Message", "uri" -> "ref/message/iterb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2225, 90, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126863165]},
 "General::iterb"->{
  Cell[2923, 119, 201, 7, 70, "Input",
   CellTags->"General::iterb",
   CellID->18190],
  Cell[3127, 128, 223, 6, 70, "Message",
   CellTags->"General::iterb",
   CellID->6596384],
  Cell[3353, 136, 206, 7, 70, "Output",
   CellTags->"General::iterb",
   CellID->312330170],
  Cell[3821, 158, 314, 11, 70, "Input",
   CellTags->"General::iterb",
   CellID->9193],
  Cell[4138, 171, 233, 7, 70, "Output",
   CellTags->"General::iterb",
   CellID->304820803],
  Cell[4629, 190, 295, 10, 70, "Input",
   CellTags->"General::iterb",
   CellID->26347],
  Cell[4927, 202, 252, 6, 70, "Message",
   CellTags->"General::iterb",
   CellID->275331479],
  Cell[5182, 210, 317, 10, 70, "Output",
   CellTags->"General::iterb",
   CellID->256673864],
  Cell[5658, 230, 305, 10, 70, "Input",
   CellTags->"General::iterb",
   CellID->15823],
  Cell[5988, 244, 237, 7, 70, "Print",
   CellTags->"General::iterb",
   CellID->472663276],
  Cell[6228, 253, 265, 8, 70, "Print",
   CellTags->"General::iterb",
   CellID->339642338],
  Cell[6496, 263, 289, 9, 70, "Print",
   CellTags->"General::iterb",
   CellID->169617372],
  Cell[6788, 274, 289, 9, 70, "Print",
   CellTags->"General::iterb",
   CellID->758696477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8061, 313},
 {"General::iterb", 8201, 317}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->14348],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 183, 5, 70, "Message",
 CellID->107656670],
Cell[1444, 56, 144, 4, 70, "Notes",
 CellID->26835],
Cell[1591, 62, 597, 23, 70, "Notes",
 CellID->16680]
}, Closed]],
Cell[CellGroupData[{
Cell[2225, 90, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126863165],
Cell[CellGroupData[{
Cell[2610, 104, 147, 5, 70, "ExampleSection",
 CellID->68532589],
Cell[2760, 111, 138, 4, 70, "ExampleText",
 CellID->399780382],
Cell[CellGroupData[{
Cell[2923, 119, 201, 7, 70, "Input",
 CellTags->"General::iterb",
 CellID->18190],
Cell[3127, 128, 223, 6, 70, "Message",
 CellTags->"General::iterb",
 CellID->6596384],
Cell[3353, 136, 206, 7, 70, "Output",
 CellTags->"General::iterb",
 CellID->312330170]
}, Open  ]],
Cell[3574, 146, 222, 8, 70, "ExampleText",
 CellID->11386337],
Cell[CellGroupData[{
Cell[3821, 158, 314, 11, 70, "Input",
 CellTags->"General::iterb",
 CellID->9193],
Cell[4138, 171, 233, 7, 70, "Output",
 CellTags->"General::iterb",
 CellID->304820803]
}, Open  ]],
Cell[4386, 181, 218, 5, 70, "ExampleText",
 CellID->363810368],
Cell[CellGroupData[{
Cell[4629, 190, 295, 10, 70, "Input",
 CellTags->"General::iterb",
 CellID->26347],
Cell[4927, 202, 252, 6, 70, "Message",
 CellTags->"General::iterb",
 CellID->275331479],
Cell[5182, 210, 317, 10, 70, "Output",
 CellTags->"General::iterb",
 CellID->256673864]
}, Open  ]],
Cell[5514, 223, 119, 3, 70, "ExampleText",
 CellID->52937491],
Cell[CellGroupData[{
Cell[5658, 230, 305, 10, 70, "Input",
 CellTags->"General::iterb",
 CellID->15823],
Cell[CellGroupData[{
Cell[5988, 244, 237, 7, 70, "Print",
 CellTags->"General::iterb",
 CellID->472663276],
Cell[6228, 253, 265, 8, 70, "Print",
 CellTags->"General::iterb",
 CellID->339642338],
Cell[6496, 263, 289, 9, 70, "Print",
 CellTags->"General::iterb",
 CellID->169617372],
Cell[6788, 274, 289, 9, 70, "Print",
 CellTags->"General::iterb",
 CellID->758696477]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7128, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

