(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8919,        344]
NotebookOptionsPosition[      5676,        234]
NotebookOutlinePosition[      7494,        291]
CellTagsIndexPosition[      7379,        285]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::mext", "ObjectName",
 CellID->6981],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"mext\"\>"}], ":", 
  " ", "\<\"Conflicting option setting. If Modulus is not 0, then Extension \
should be None.\"\>"}]], "Message", "MSG",
 CellID->453097170],

Cell[TextData[{
 "Generated when both the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " options are set to non-default values."
}], "Notes",
 CellID->12417],

Cell[TextData[{
 "This message  can be generated by ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FactorSquareFreeList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFreeList"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22471]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39117336],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->183242468],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " options cannot in general be used at the same time."
}], "ExampleText",
 CellID->315159267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"Modulus", "->", "2"}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellTags->"General::mext",
 CellLabel->"In[1]:=",
 CellID->11169],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"mext\"\>"}], ":", 
  " ", "\<\"Conflicting option setting. If Modulus is not 0, then Extension \
should be None.\"\>"}]], "Message", "MSG",
 CellTags->"General::mext",
 CellID->324534998],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    SqrtBox["2"]}]}], "]"}]], "Output",
 CellTags->"General::mext",
 CellLabel->"Out[1]=",
 CellID->33644545]
}, Open  ]],

Cell["Both options can be used separately.", "ExampleText",
 CellID->888852584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellTags->"General::mext",
 CellLabel->"In[2]:=",
 CellID->30474],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 CellTags->"General::mext",
 CellLabel->"Out[2]=",
 CellID->91835854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellTags->"General::mext",
 CellLabel->"In[3]:=",
 CellID->27912],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "-", "x"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}]}]], "Output",
 CellTags->"General::mext",
 CellLabel->"Out[3]=",
 CellID->179493408]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::mext - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 14.2698170}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::mext", "synonyms" -> {}, "title" -> 
    "General::mext", "type" -> "Message", "uri" -> "ref/message/mext"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2769, 109, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->39117336]},
 "General::mext"->{
  Cell[3696, 147, 305, 10, 70, "Input",
   CellTags->"General::mext",
   CellID->11169],
  Cell[4004, 159, 242, 6, 70, "Message",
   CellTags->"General::mext",
   CellID->324534998],
  Cell[4249, 167, 321, 11, 70, "Output",
   CellTags->"General::mext",
   CellID->33644545],
  Cell[4689, 186, 229, 8, 70, "Input",
   CellTags->"General::mext",
   CellID->30474],
  Cell[4921, 196, 121, 4, 70, "Output",
   CellTags->"General::mext",
   CellID->91835854],
  Cell[5079, 205, 264, 9, 70, "Input",
   CellTags->"General::mext",
   CellID->27912],
  Cell[5346, 216, 264, 11, 70, "Output",
   CellTags->"General::mext",
   CellID->179493408]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6578, 256},
 {"General::mext", 6717, 260}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->6981],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 215, 5, 70, "Message",
 CellID->453097170],
Cell[1474, 56, 364, 13, 70, "Notes",
 CellID->12417],
Cell[1841, 71, 891, 33, 70, "Notes",
 CellID->22471]
}, Closed]],
Cell[CellGroupData[{
Cell[2769, 109, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39117336],
Cell[CellGroupData[{
Cell[3153, 123, 148, 5, 70, "ExampleSection",
 CellID->183242468],
Cell[3304, 130, 367, 13, 70, "ExampleText",
 CellID->315159267],
Cell[CellGroupData[{
Cell[3696, 147, 305, 10, 70, "Input",
 CellTags->"General::mext",
 CellID->11169],
Cell[4004, 159, 242, 6, 70, "Message",
 CellTags->"General::mext",
 CellID->324534998],
Cell[4249, 167, 321, 11, 70, "Output",
 CellTags->"General::mext",
 CellID->33644545]
}, Open  ]],
Cell[4585, 181, 79, 1, 70, "ExampleText",
 CellID->888852584],
Cell[CellGroupData[{
Cell[4689, 186, 229, 8, 70, "Input",
 CellTags->"General::mext",
 CellID->30474],
Cell[4921, 196, 121, 4, 70, "Output",
 CellTags->"General::mext",
 CellID->91835854]
}, Open  ]],
Cell[CellGroupData[{
Cell[5079, 205, 264, 9, 70, "Input",
 CellTags->"General::mext",
 CellID->27912],
Cell[5346, 216, 264, 11, 70, "Output",
 CellTags->"General::mext",
 CellID->179493408]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5649, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

