(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9724,        369]
NotebookOptionsPosition[      5970,        241]
NotebookOutlinePosition[      7981,        304]
CellTagsIndexPosition[      7865,        298]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::modgp", "ObjectName",
 CellID->5439],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"modgp\"\>"}], ":", 
  " ", "\<\"Value of option `1` -> `2` should be a Gaussian prime \
number.\"\>"}]], "Message", "MSG",
 CellID->18694313],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option in the indicated function is expected to be a Gaussian prime  \
number."
}], "Notes",
 CellID->12369],

Cell["\<\
A Gaussian prime number is an integer that  cannot be factored using complex \
numbers with integer real and imaginary  parts.\
\>", "Notes",
 CellID->28512],

Cell[TextData[{
 "You can find out if a number is a Gaussian prime  number using ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " with the ",
 StyleBox["GaussianIntegers->True", "MR"],
 " option."
}], "Notes",
 CellID->7403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299755859],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->198660306],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option is not a Gaussian prime number."
}], "ExampleText",
 CellID->636324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"22", " ", "I"}], " ", "+", " ", 
    RowBox[{"31", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x", ",", 
   RowBox[{"Modulus", "->", "17"}]}], "]"}]], "Input",
 CellTags->"General::modgp",
 CellLabel->"In[1]:=",
 CellID->22971],

Cell[BoxData[
 RowBox[{
  RowBox[{"FactorTerms", "::", "\<\"modgp\"\>"}], ":", 
  " ", "\<\"Value of option \\!\\(Modulus\\) -> \\!\\(17\\) should be a \
Gaussian prime number.\"\>"}]], "Message", "MSG",
 CellTags->"General::modgp",
 CellID->236206719],

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"22", " ", "\[ImaginaryI]"}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["x", "2"]}]}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "17"}]}], "]"}]], "Output",
 CellTags->"General::modgp",
 CellLabel->"Out[1]=",
 CellID->61284630]
}, Open  ]],

Cell["The integer 17 can be factored using Gaussian integers.", "ExampleText",
 CellID->219800636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"17", ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellTags->"General::modgp",
 CellLabel->"In[2]:=",
 CellID->302],

Cell[BoxData["False"], "Output",
 CellTags->"General::modgp",
 CellLabel->"Out[2]=",
 CellID->304141030]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"17", ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellTags->"General::modgp",
 CellLabel->"In[3]:=",
 CellID->4729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "\[ImaginaryI]"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"General::modgp",
 CellLabel->"Out[3]=",
 CellID->27288005]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option in this example."
}], "ExampleText",
 CellID->814795112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"22", " ", "I"}], " ", "+", " ", 
    RowBox[{"31", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x", ",", 
   RowBox[{"Modulus", "->", "19"}]}], "]"}]], "Input",
 CellTags->"General::modgp",
 CellLabel->"In[4]:=",
 CellID->8583],

Cell[BoxData[
 RowBox[{"12", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 CellTags->"General::modgp",
 CellLabel->"Out[4]=",
 CellID->828206306]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::modgp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 14.5354488}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::modgp", "synonyms" -> {}, "title" -> 
    "General::modgp", "type" -> "Message", "uri" -> "ref/message/modgp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2244, 88, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299755859]},
 "General::modgp"->{
  Cell[3078, 121, 309, 10, 70, "Input",
   CellTags->"General::modgp",
   CellID->22971],
  Cell[3390, 133, 252, 6, 70, "Message",
   CellTags->"General::modgp",
   CellID->236206719],
  Cell[3645, 141, 321, 10, 70, "Output",
   CellTags->"General::modgp",
   CellID->61284630],
  Cell[4104, 159, 192, 6, 70, "Input",
   CellTags->"General::modgp",
   CellID->302],
  Cell[4299, 167, 104, 3, 70, "Output",
   CellTags->"General::modgp",
   CellID->304141030],
  Cell[4440, 175, 200, 6, 70, "Input",
   CellTags->"General::modgp",
   CellID->4729],
  Cell[4643, 183, 440, 16, 70, "Output",
   CellTags->"General::modgp",
   CellID->27288005],
  Cell[5360, 214, 308, 10, 70, "Input",
   CellTags->"General::modgp",
   CellID->8583],
  Cell[5671, 226, 233, 8, 70, "Output",
   CellTags->"General::modgp",
   CellID->828206306]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6876, 263},
 {"General::modgp", 7016, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->5439],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 197, 5, 70, "Message",
 CellID->18694313],
Cell[1457, 56, 281, 9, 70, "Notes",
 CellID->12369],
Cell[1741, 67, 167, 4, 70, "Notes",
 CellID->28512],
Cell[1911, 73, 296, 10, 70, "Notes",
 CellID->7403]
}, Closed]],
Cell[CellGroupData[{
Cell[2244, 88, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299755859],
Cell[CellGroupData[{
Cell[2629, 102, 148, 5, 70, "ExampleSection",
 CellID->198660306],
Cell[2780, 109, 273, 8, 70, "ExampleText",
 CellID->636324],
Cell[CellGroupData[{
Cell[3078, 121, 309, 10, 70, "Input",
 CellTags->"General::modgp",
 CellID->22971],
Cell[3390, 133, 252, 6, 70, "Message",
 CellTags->"General::modgp",
 CellID->236206719],
Cell[3645, 141, 321, 10, 70, "Output",
 CellTags->"General::modgp",
 CellID->61284630]
}, Open  ]],
Cell[3981, 154, 98, 1, 70, "ExampleText",
 CellID->219800636],
Cell[CellGroupData[{
Cell[4104, 159, 192, 6, 70, "Input",
 CellTags->"General::modgp",
 CellID->302],
Cell[4299, 167, 104, 3, 70, "Output",
 CellTags->"General::modgp",
 CellID->304141030]
}, Open  ]],
Cell[CellGroupData[{
Cell[4440, 175, 200, 6, 70, "Input",
 CellTags->"General::modgp",
 CellID->4729],
Cell[4643, 183, 440, 16, 70, "Output",
 CellTags->"General::modgp",
 CellID->27288005]
}, Open  ]],
Cell[5098, 202, 237, 8, 70, "ExampleText",
 CellID->814795112],
Cell[CellGroupData[{
Cell[5360, 214, 308, 10, 70, "Input",
 CellTags->"General::modgp",
 CellID->8583],
Cell[5671, 226, 233, 8, 70, "Output",
 CellTags->"General::modgp",
 CellID->828206306]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5943, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

