(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7607,        291]
NotebookOptionsPosition[      4756,        195]
NotebookOutlinePosition[      6390,        246]
CellTagsIndexPosition[      6275,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::mult", "ObjectName",
 CellID->17841],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"mult\"\>"}], ":", 
  " ", "\<\"Value of option Multiplicity -> `1` is not a positive \
integer.\"\>"}]], "Message", "MSG",
 CellID->63551772],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["Multiplicity"], "InlineFormula"],
 " option does not have the expected form."
}], "Notes",
 CellID->4270],

Cell[TextData[{
 "This message  can be generated by ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " and by functions such as ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " that use ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " internally."
}], "Notes",
 CellID->22935]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23723715],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13825814],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 Cell[BoxData["Multiplicity"], "InlineFormula"],
 " option cannot be zero."
}], "ExampleText",
 CellID->101872459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "5"}], ",", "x", ",", 
   RowBox[{"Multiplicity", "->", "0"}]}], "]"}]], "Input",
 CellTags->"General::mult",
 CellLabel->"In[1]:=",
 CellID->24379],

Cell[BoxData[
 RowBox[{
  RowBox[{"Roots", "::", "\<\"mult\"\>"}], ":", 
  " ", "\<\"Value of option Multiplicity -> \\!\\(0\\) is not a positive \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"General::mult",
 CellID->308055956],

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "5"}], ",", "x", ",", 
   RowBox[{"Multiplicity", "\[Rule]", "0"}]}], "]"}]], "Output",
 CellTags->"General::mult",
 CellLabel->"Out[1]=",
 CellID->156640496]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData["Multiplicity"], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->64359253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "5"}], ",", "x", ",", 
   RowBox[{"Multiplicity", "->", "3"}]}], "]"}]], "Input",
 CellTags->"General::mult",
 CellLabel->"In[2]:=",
 CellID->701],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   SqrtBox["5"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["5"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["5"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["5"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["5"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["5"]}]}]}]], "Output",
 CellTags->"General::mult",
 CellLabel->"Out[2]=",
 CellID->251531967]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::mult - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 22.2543964}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::mult", "synonyms" -> {}, "title" -> 
    "General::mult", "type" -> "Message", "uri" -> "ref/message/mult"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2154, 86, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23723715]},
 "General::mult"->{
  Cell[2905, 116, 244, 8, 70, "Input",
   CellTags->"General::mult",
   CellID->24379],
  Cell[3152, 126, 231, 6, 70, "Message",
   CellTags->"General::mult",
   CellID->308055956],
  Cell[3386, 134, 261, 8, 70, "Output",
   CellTags->"General::mult",
   CellID->156640496],
  Cell[3961, 159, 242, 8, 70, "Input",
   CellTags->"General::mult",
   CellID->701],
  Cell[4206, 169, 484, 19, 70, "Output",
   CellTags->"General::mult",
   CellID->251531967]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5658, 217},
 {"General::mult", 5796, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->17841],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 197, 5, 70, "Message",
 CellID->63551772],
Cell[1457, 56, 173, 5, 70, "Notes",
 CellID->4270],
Cell[1633, 63, 484, 18, 70, "Notes",
 CellID->22935]
}, Closed]],
Cell[CellGroupData[{
Cell[2154, 86, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23723715],
Cell[CellGroupData[{
Cell[2538, 100, 147, 5, 70, "ExampleSection",
 CellID->13825814],
Cell[2688, 107, 192, 5, 70, "ExampleText",
 CellID->101872459],
Cell[CellGroupData[{
Cell[2905, 116, 244, 8, 70, "Input",
 CellTags->"General::mult",
 CellID->24379],
Cell[3152, 126, 231, 6, 70, "Message",
 CellTags->"General::mult",
 CellID->308055956],
Cell[3386, 134, 261, 8, 70, "Output",
 CellTags->"General::mult",
 CellID->156640496]
}, Open  ]],
Cell[3662, 145, 274, 10, 70, "ExampleText",
 CellID->64359253],
Cell[CellGroupData[{
Cell[3961, 159, 242, 8, 70, "Input",
 CellTags->"General::mult",
 CellID->701],
Cell[4206, 169, 484, 19, 70, "Output",
 CellTags->"General::mult",
 CellID->251531967]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4729, 193, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

