(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7164,        271]
NotebookOptionsPosition[      4301,        175]
NotebookOutlinePosition[      5945,        226]
CellTagsIndexPosition[      5829,        220]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::optrs", "ObjectName",
 CellID->14524],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"optrs\"\>"}], ":", 
  " ", "\<\"Option specification `1` in `2` is not a rule for a symbol or \
string.\"\>"}]], "Message", "MSG",
 CellID->100633820],

Cell["\<\
Generated when the indicated expression does not have the form of an option.\
\>", "Notes",
 CellID->9339],

Cell["\<\
A valid option is a rule in which the left-hand side is a symbol or string.\
\>", "Notes",
 CellID->1313]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3346128],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->25950486],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " does not have the correct form to be an option."
}], "ExampleText",
 CellID->397046433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "->", "Extension"}]}], "]"}]], "Input",
 CellTags->"General::optrs",
 CellLabel->"In[1]:=",
 CellID->29885],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"optrs\"\>"}], ":", 
  " ", "\<\"Option specification \\!\\(\\@2 \[Rule] Extension\\) in \
\\!\\(Factor[\\(\\(\\(\\(2 - x\\^2\\)\\), \\(\\(\\@2 \[Rule] \
Extension\\)\\)\\)\\)]\\) is not a rule for a symbol or string.\"\>"}]], \
"Message", "MSG",
 CellTags->"General::optrs",
 CellID->709423402],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    SqrtBox["2"], "\[Rule]", "Extension"}]}], "]"}]], "Output",
 CellTags->"General::optrs",
 CellLabel->"Out[1]=",
 CellID->368488837]
}, Open  ]],

Cell[TextData[{
 "This shows a valid option specification in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->624948863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellTags->"General::optrs",
 CellLabel->"In[2]:=",
 CellID->2103],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}]}]], "Output",
 CellTags->"General::optrs",
 CellLabel->"Out[2]=",
 CellID->343965654]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::optrs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 3.1148174}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::optrs", "synonyms" -> {}, "title" -> 
    "General::optrs", "type" -> "Message", "uri" -> "ref/message/optrs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1738, 69, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3346128]},
 "General::optrs"->{
  Cell[2585, 102, 265, 9, 70, "Input",
   CellTags->"General::optrs",
   CellID->29885],
  Cell[2853, 113, 349, 8, 70, "Message",
   CellTags->"General::optrs",
   CellID->709423402],
  Cell[3205, 123, 257, 9, 70, "Output",
   CellTags->"General::optrs",
   CellID->368488837],
  Cell[3724, 147, 264, 9, 70, "Input",
   CellTags->"General::optrs",
   CellID->2103],
  Cell[3991, 158, 244, 10, 70, "Output",
   CellTags->"General::optrs",
   CellID->343965654]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5206, 197},
 {"General::optrs", 5344, 201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->14524],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 206, 5, 70, "Message",
 CellID->100633820],
Cell[1467, 56, 116, 3, 70, "Notes",
 CellID->9339],
Cell[1586, 61, 115, 3, 70, "Notes",
 CellID->1313]
}, Closed]],
Cell[CellGroupData[{
Cell[1738, 69, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3346128],
Cell[CellGroupData[{
Cell[2121, 83, 147, 5, 70, "ExampleSection",
 CellID->25950486],
Cell[2271, 90, 289, 8, 70, "ExampleText",
 CellID->397046433],
Cell[CellGroupData[{
Cell[2585, 102, 265, 9, 70, "Input",
 CellTags->"General::optrs",
 CellID->29885],
Cell[2853, 113, 349, 8, 70, "Message",
 CellTags->"General::optrs",
 CellID->709423402],
Cell[3205, 123, 257, 9, 70, "Output",
 CellTags->"General::optrs",
 CellID->368488837]
}, Open  ]],
Cell[3477, 135, 222, 8, 70, "ExampleText",
 CellID->624948863],
Cell[CellGroupData[{
Cell[3724, 147, 264, 9, 70, "Input",
 CellTags->"General::optrs",
 CellID->2103],
Cell[3991, 158, 244, 10, 70, "Output",
 CellTags->"General::optrs",
 CellID->343965654]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4274, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

