(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9992,        381]
NotebookOptionsPosition[      5891,        241]
NotebookOutlinePosition[      8077,        310]
CellTagsIndexPosition[      7962,        304]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::ovfl", "ObjectName",
 CellID->19241],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation.\"\>"}]], "Message", "MSG",
 CellID->53865958],

Cell[TextData[{
 "Generated when the scale of a result exceeds the scale  of numbers that can \
be represented in the version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that is in use."
}], "Notes",
 CellID->16068],

Cell["\<\
This message is generated by  arithmetic overflow within numerical functions.\
\
\>", "Notes",
 CellID->1576],

Cell[TextData[{
 "The  largest number that can be represented in a particular version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be found by evaluating ",
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4673]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366901400],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->376918698],

Cell[TextData[{
 "This operation will generate a warning message because the result is larger \
 than the value of ",
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 " on this computer."
}], "ExampleText",
 CellID->168417556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"10.", "^", "10"}], "]"}]], "Input",
 CellTags->"General::ovfl",
 CellLabel->"In[1]:=",
 CellID->12190],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation.\"\>"}]], "Message", "MSG",
 CellTags->"General::ovfl",
 CellID->598197535],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 CellTags->"General::ovfl",
 CellLabel->"Out[1]=",
 CellID->659041284]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$MaxNumber"], "Input",
 CellTags->"General::ovfl",
 CellLabel->"In[2]:=",
 CellID->10189],

Cell[BoxData["1.9202246726923565854204690606`15.954589770191005*^646456887"], \
"Output",
 CellTags->"General::ovfl",
 CellLabel->"Out[2]=",
 CellID->10608553]
}, Open  ]],

Cell[TextData[{
 "Overflow often occurs as a result of arithmetic within functions such as ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->77820942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"10", "^", "x"}], "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::ovfl",
 CellLabel->"In[3]:=",
 CellID->13445],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation.\"\>"}]], "Message", "MSG",
 CellTags->"General::ovfl",
 CellID->53963214],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"The function value \\!\\({\\(Overflow[]\\)}\\) is not a list of \
numbers with dimensions \\!\\({1}\\) at \\!\\({x}\\) = \
\\!\\({10.`}\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::ovfl",
 CellID->38070937],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["10", "x"]], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::ovfl",
 CellLabel->"Out[3]=",
 CellID->166613186]
}, Open  ]],

Cell["\<\
In this example the problem can be resolved by choosing a better starting \
value.\
\>", "ExampleText",
 CellID->847094815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"10", "^", "x"}], "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::ovfl",
 CellLabel->"In[4]:=",
 CellID->18483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.1591745389548616`"}]}], "}"}]], "Output",
 CellTags->"General::ovfl",
 CellLabel->"Out[4]=",
 CellID->714039980]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::ovfl - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 10.6150094}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::ovfl", "synonyms" -> {}, "title" -> 
    "General::ovfl", "type" -> "Message", "uri" -> "ref/message/ovfl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2146, 86, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->366901400]},
 "General::ovfl"->{
  Cell[3008, 120, 149, 5, 70, "Input",
   CellTags->"General::ovfl",
   CellID->12190],
  Cell[3160, 127, 195, 5, 70, "Message",
   CellTags->"General::ovfl",
   CellID->598197535],
  Cell[3358, 134, 128, 4, 70, "Output",
   CellTags->"General::ovfl",
   CellID->659041284],
  Cell[3523, 143, 103, 3, 70, "Input",
   CellTags->"General::ovfl",
   CellID->10189],
  Cell[3629, 148, 159, 4, 70, "Output",
   CellTags->"General::ovfl",
   CellID->10608553],
  Cell[4083, 167, 285, 10, 70, "Input",
   CellTags->"General::ovfl",
   CellID->13445],
  Cell[4371, 179, 194, 5, 70, "Message",
   CellTags->"General::ovfl",
   CellID->53963214],
  Cell[4568, 186, 302, 7, 70, "Message",
   CellTags->"General::ovfl",
   CellID->38070937],
  Cell[4873, 195, 305, 10, 70, "Output",
   CellTags->"General::ovfl",
   CellID->166613186],
  Cell[5351, 216, 284, 10, 70, "Input",
   CellTags->"General::ovfl",
   CellID->18483],
  Cell[5638, 228, 187, 6, 70, "Output",
   CellTags->"General::ovfl",
   CellID->714039980]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6793, 263},
 {"General::ovfl", 6932, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->19241],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 166, 4, 70, "Message",
 CellID->53865958],
Cell[1426, 55, 229, 7, 70, "Notes",
 CellID->16068],
Cell[1658, 64, 119, 4, 70, "Notes",
 CellID->1576],
Cell[1780, 70, 329, 11, 70, "Notes",
 CellID->4673]
}, Closed]],
Cell[CellGroupData[{
Cell[2146, 86, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366901400],
Cell[CellGroupData[{
Cell[2531, 100, 148, 5, 70, "ExampleSection",
 CellID->376918698],
Cell[2682, 107, 301, 9, 70, "ExampleText",
 CellID->168417556],
Cell[CellGroupData[{
Cell[3008, 120, 149, 5, 70, "Input",
 CellTags->"General::ovfl",
 CellID->12190],
Cell[3160, 127, 195, 5, 70, "Message",
 CellTags->"General::ovfl",
 CellID->598197535],
Cell[3358, 134, 128, 4, 70, "Output",
 CellTags->"General::ovfl",
 CellID->659041284]
}, Open  ]],
Cell[CellGroupData[{
Cell[3523, 143, 103, 3, 70, "Input",
 CellTags->"General::ovfl",
 CellID->10189],
Cell[3629, 148, 159, 4, 70, "Output",
 CellTags->"General::ovfl",
 CellID->10608553]
}, Open  ]],
Cell[3803, 155, 255, 8, 70, "ExampleText",
 CellID->77820942],
Cell[CellGroupData[{
Cell[4083, 167, 285, 10, 70, "Input",
 CellTags->"General::ovfl",
 CellID->13445],
Cell[4371, 179, 194, 5, 70, "Message",
 CellTags->"General::ovfl",
 CellID->53963214],
Cell[4568, 186, 302, 7, 70, "Message",
 CellTags->"General::ovfl",
 CellID->38070937],
Cell[4873, 195, 305, 10, 70, "Output",
 CellTags->"General::ovfl",
 CellID->166613186]
}, Open  ]],
Cell[5193, 208, 133, 4, 70, "ExampleText",
 CellID->847094815],
Cell[CellGroupData[{
Cell[5351, 216, 284, 10, 70, "Input",
 CellTags->"General::ovfl",
 CellID->18483],
Cell[5638, 228, 187, 6, 70, "Output",
 CellTags->"General::ovfl",
 CellID->714039980]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5864, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

