(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24731,        572]
NotebookOptionsPosition[     21815,        474]
NotebookOutlinePosition[     23456,        525]
CellTagsIndexPosition[     23339,        519]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::plln", "ObjectName",
 CellID->27981],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"plln\"\>"}], ":", 
  " ", "\<\"Limiting value `1` in `2` is not a machine-size real \
number.\"\>"}]], "Message", "MSG",
 CellID->223903564],

Cell["\<\
Generated when the indicated limit on the variable  does not evaluate to a \
real number or is outside of the range of machine  numbers on your computer.\
\>", "Notes",
 CellID->15678],

Cell["This message is used  primarily by plotting functions.", "Notes",
 CellID->7059],

Cell[TextData[{
 "Limits on variables in  plotting functions are expected to be given in the \
form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["xmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmax", "TI"],
 StyleBox["}", "MR"],
 " where ",
 StyleBox["xmin", "TI"],
 " and ",
 StyleBox["xmax", "TI"],
 " are real numbers."
}], "Notes",
 CellID->7211]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->790926138],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->267494960],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is not a valid limit for the plotting variable."
}], "ExampleText",
 CellID->37628312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Automatic"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::plln",
 CellLabel->"In[1]:=",
 CellID->17761],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"plln\"\>"}], ":", 
  " ", "\<\"Limiting value \\!\\(Automatic\\) in \\!\\({x, 0, Automatic}\\) \
is not a machine-size real number.\"\>"}]], "Message", "MSG",
 CellTags->"General::plln",
 CellID->824011522],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"\[Pi]", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Automatic"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::plln",
 CellLabel->"Out[1]=",
 CellID->227701809]
}, Open  ]],

Cell[TextData[{
 "This shows valid limit specification in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->181763179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::plln",
 CellLabel->"In[2]:=",
 CellID->7513],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlm3k8VO8XxwdhCDNMq4SyJOu3jTadJyWFNmkTJbJWSotsUQkRLVK2shRC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 5}, {-0.9999999999999486, 0.9999999999999486}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"General::plln",
 CellLabel->"Out[2]=",
 CellID->709227288]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::plln - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 18.3027062}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::plln", "synonyms" -> {}, "title" -> 
    "General::plln", "type" -> "Message", "uri" -> "ref/message/plln"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2186, 87, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->790926138]},
 "General::plln"->{
  Cell[3018, 120, 271, 9, 70, "Input",
   CellTags->"General::plln",
   CellID->17761],
  Cell[3292, 131, 259, 6, 70, "Message",
   CellTags->"General::plln",
   CellID->824011522],
  Cell[3554, 139, 279, 9, 70, "Output",
   CellTags->"General::plln",
   CellID->227701809],
  Cell[4088, 163, 262, 9, 70, "Input",
   CellTags->"General::plln",
   CellID->7513],
  Cell[4353, 174, 17396, 293, 70, "Output",
   CellTags->"General::plln",
   CellID->709227288]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22717, 496},
 {"General::plln", 22856, 500}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->27981],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 196, 5, 70, "Message",
 CellID->223903564],
Cell[1456, 56, 194, 4, 70, "Notes",
 CellID->15678],
Cell[1653, 62, 86, 1, 70, "Notes",
 CellID->7059],
Cell[1742, 65, 407, 17, 70, "Notes",
 CellID->7211]
}, Closed]],
Cell[CellGroupData[{
Cell[2186, 87, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->790926138],
Cell[CellGroupData[{
Cell[2571, 101, 148, 5, 70, "ExampleSection",
 CellID->267494960],
Cell[2722, 108, 271, 8, 70, "ExampleText",
 CellID->37628312],
Cell[CellGroupData[{
Cell[3018, 120, 271, 9, 70, "Input",
 CellTags->"General::plln",
 CellID->17761],
Cell[3292, 131, 259, 6, 70, "Message",
 CellTags->"General::plln",
 CellID->824011522],
Cell[3554, 139, 279, 9, 70, "Output",
 CellTags->"General::plln",
 CellID->227701809]
}, Open  ]],
Cell[3848, 151, 215, 8, 70, "ExampleText",
 CellID->181763179],
Cell[CellGroupData[{
Cell[4088, 163, 262, 9, 70, "Input",
 CellTags->"General::plln",
 CellID->7513],
Cell[4353, 174, 17396, 293, 70, "Output",
 CellTags->"General::plln",
 CellID->709227288]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[21788, 472, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

