(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8256,        295]
NotebookOptionsPosition[      5271,        195]
NotebookOutlinePosition[      6927,        246]
CellTagsIndexPosition[      6810,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::preclg", "ObjectName",
 CellID->11635],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"preclg\"\>"}], ":", 
  " ", "\<\"Requested precision `1` is larger than $MaxPrecision. Using \
current $MaxPrecision of `2` instead. $MaxPrecision = Infinity specifies that \
any precision should be allowed.\"\>"}]], "Message", "MSG",
 CellID->2353338],

Cell[TextData[{
 "Generated when a requested value of precision exceeds  the value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17987],

Cell[TextData[{
 "You can set ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " to a larger value if you need greater precision."
}], "Notes",
 CellID->4910],

Cell[TextData[{
 "In  ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the accuracy of a number is the number of known digits to the right of  \
the decimal point, the precision is the total number of significant digits,  \
the scale is the number of digits to the left of the decimal point, and the  \
precision is the sum of the scale and the accuracy."
}], "Notes",
 CellID->244],

Cell[TextData[{
 " This is a warning message to indicate that the value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " has been exceeded.  This warning message does not necessarily indicate an  \
error."
}], "Notes",
 CellID->28355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743093812],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->667879635],

Cell[TextData[{
 "An error occurs in this example because the precision specified in ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " exceeds the value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " when this expression is evaluated."
}], "ExampleText",
 CellID->346384348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "20"}], "}"}], ",", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"Pi", ",", "50"}], "]"}]}], "]"}]], "Input",
 CellTags->"General::preclg",
 CellLabel->"In[1]:=",
 CellID->4016],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetPrecision", "::", "\<\"preclg\"\>"}], ":", 
  " ", "\<\"Requested precision \\!\\(50\\) is larger than $MaxPrecision. \
Using current $MaxPrecision of \\!\\(20.`\\) instead. $MaxPrecision = \
Infinity specifies that any precision should be allowed.\"\>"}]], "Message", \
"MSG",
 CellTags->"General::preclg",
 CellID->90594155],

Cell[BoxData["3.14159265358979323846264338358607339165`20."], "Output",
 CellTags->"General::preclg",
 CellLabel->"Out[1]=",
 CellID->359174434]
}, Open  ]],

Cell["This shows valid precision specifications.", "ExampleText",
 CellID->42484318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"Pi", ",", "50"}], "]"}]}], "]"}]], "Input",
 CellTags->"General::preclg",
 CellLabel->"In[2]:=",
 CellID->14080],

Cell[BoxData["3.\
1415926535897932384626433832795028841971693993751058209849474090732`50."], \
"Output",
 CellTags->"General::preclg",
 CellLabel->"Out[2]=",
 CellID->23426627]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::preclg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 19.0527254}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::preclg", "synonyms" -> {}, "title" -> 
    "General::preclg", "type" -> "Message", "uri" -> "ref/message/preclg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2821, 102, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->743093812]},
 "General::preclg"->{
  Cell[3830, 140, 278, 9, 70, "Input",
   CellTags->"General::preclg",
   CellID->4016],
  Cell[4111, 151, 364, 8, 70, "Message",
   CellTags->"General::preclg",
   CellID->90594155],
  Cell[4478, 161, 144, 3, 70, "Output",
   CellTags->"General::preclg",
   CellID->359174434],
  Cell[4746, 172, 280, 9, 70, "Input",
   CellTags->"General::preclg",
   CellID->14080],
  Cell[5029, 183, 176, 5, 70, "Output",
   CellTags->"General::preclg",
   CellID->23426627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6181, 217},
 {"General::preclg", 6323, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->11635],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 308, 6, 70, "Message",
 CellID->2353338],
Cell[1570, 57, 251, 8, 70, "Notes",
 CellID->17987],
Cell[1824, 67, 242, 8, 70, "Notes",
 CellID->4910],
Cell[2069, 77, 389, 9, 70, "Notes",
 CellID->244],
Cell[2461, 88, 323, 9, 70, "Notes",
 CellID->28355]
}, Closed]],
Cell[CellGroupData[{
Cell[2821, 102, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743093812],
Cell[CellGroupData[{
Cell[3206, 116, 148, 5, 70, "ExampleSection",
 CellID->667879635],
Cell[3357, 123, 448, 13, 70, "ExampleText",
 CellID->346384348],
Cell[CellGroupData[{
Cell[3830, 140, 278, 9, 70, "Input",
 CellTags->"General::preclg",
 CellID->4016],
Cell[4111, 151, 364, 8, 70, "Message",
 CellTags->"General::preclg",
 CellID->90594155],
Cell[4478, 161, 144, 3, 70, "Output",
 CellTags->"General::preclg",
 CellID->359174434]
}, Open  ]],
Cell[4637, 167, 84, 1, 70, "ExampleText",
 CellID->42484318],
Cell[CellGroupData[{
Cell[4746, 172, 280, 9, 70, "Input",
 CellTags->"General::preclg",
 CellID->14080],
Cell[5029, 183, 176, 5, 70, "Output",
 CellTags->"General::preclg",
 CellID->23426627]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5244, 193, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

