(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8014,        290]
NotebookOptionsPosition[      5039,        190]
NotebookOutlinePosition[      6685,        241]
CellTagsIndexPosition[      6569,        235]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::precw", "ObjectName",
 CellID->2774],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the argument function (`1`) is less than \
WorkingPrecision (`2`).\"\>"}]], "Message", "MSG",
 CellID->128722],

Cell[TextData[{
 "Generated by numerical functions when the value of the  ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option is greater than the precision of the argument function. "
}], "Notes",
 CellID->11659],

Cell["\<\
This message can be avoided by using exact or  high-precision numbers in the \
input.\
\>", "Notes",
 CellID->11560],

Cell[TextData[{
 "This message is  often encountered when the argument function includes an \
inexact zero (",
 StyleBox["0.0", "MR"],
 ").  The precision of ",
 StyleBox["0.0", "MR"],
 " is zero (",
 StyleBox["0.0", "MR"],
 " has no non-zero significant digits), which is less than the default value  \
of the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->18323],

Cell["\<\
This message is a warning only and can often  be ignored if you are not \
concerned about the precision used in your  calculations.\
\>", "Notes",
 CellID->20797]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420458905],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->237314946],

Cell[TextData[{
 "This evaluation generates a warning message because the precision of the  \
machine number ",
 StyleBox["3.4", "MR"],
 " is less than the specified value of the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option.  It is not possible to do a proper high-precision calculation  \
starting with low-precision inputs."
}], "ExampleText",
 CellID->211351113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"3.4", " ", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellTags->"General::precw",
 CellLabel->"In[1]:=",
 CellID->4784],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"precw\"\>"}], ":", 
  " ", "\<\"The precision of the argument function (\\!\\(3.4`\\\\ x\\)) is \
less than WorkingPrecision (\\!\\(25.`\\)).\"\>"}]], "Message", "MSG",
 CellTags->"General::precw",
 CellID->458366851],

Cell[BoxData["1.69999999999999995559107901499839881946`25."], "Output",
 CellTags->"General::precw",
 CellLabel->"Out[1]=",
 CellID->589368998]
}, Open  ]],

Cell["\<\
The message can be avoided by using exact numbers in the input.\
\>", "ExampleText",
 CellID->208446268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"34", "/", "10"}], " ", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellTags->"General::precw",
 CellLabel->"In[2]:=",
 CellID->22745],

Cell[BoxData["1.70000000000000000000000000000466043641`25."], "Output",
 CellTags->"General::precw",
 CellLabel->"Out[2]=",
 CellID->37260617]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::precw - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 26.2560348}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::precw", "synonyms" -> {}, "title" -> 
    "General::precw", "type" -> "Message", "uri" -> "ref/message/precw"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2616, 99, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->420458905]},
 "General::precw"->{
  Cell[3645, 136, 289, 9, 70, "Input",
   CellTags->"General::precw",
   CellID->4784],
  Cell[3937, 147, 276, 6, 70, "Message",
   CellTags->"General::precw",
   CellID->458366851],
  Cell[4216, 155, 143, 3, 70, "Output",
   CellTags->"General::precw",
   CellID->589368998],
  Cell[4513, 168, 315, 10, 70, "Input",
   CellTags->"General::precw",
   CellID->22745],
  Cell[4831, 180, 142, 3, 70, "Output",
   CellTags->"General::precw",
   CellID->37260617]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5945, 212},
 {"General::precw", 6085, 216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->2774],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 215, 5, 70, "Message",
 CellID->128722],
Cell[1475, 56, 308, 8, 70, "Notes",
 CellID->11659],
Cell[1786, 66, 126, 4, 70, "Notes",
 CellID->11560],
Cell[1915, 72, 489, 16, 70, "Notes",
 CellID->18323],
Cell[2407, 90, 172, 4, 70, "Notes",
 CellID->20797]
}, Closed]],
Cell[CellGroupData[{
Cell[2616, 99, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420458905],
Cell[CellGroupData[{
Cell[3001, 113, 148, 5, 70, "ExampleSection",
 CellID->237314946],
Cell[3152, 120, 468, 12, 70, "ExampleText",
 CellID->211351113],
Cell[CellGroupData[{
Cell[3645, 136, 289, 9, 70, "Input",
 CellTags->"General::precw",
 CellID->4784],
Cell[3937, 147, 276, 6, 70, "Message",
 CellTags->"General::precw",
 CellID->458366851],
Cell[4216, 155, 143, 3, 70, "Output",
 CellTags->"General::precw",
 CellID->589368998]
}, Open  ]],
Cell[4374, 161, 114, 3, 70, "ExampleText",
 CellID->208446268],
Cell[CellGroupData[{
Cell[4513, 168, 315, 10, 70, "Input",
 CellTags->"General::precw",
 CellID->22745],
Cell[4831, 180, 142, 3, 70, "Output",
 CellTags->"General::precw",
 CellID->37260617]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5012, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

