(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12160,        460]
NotebookOptionsPosition[      7199,        288]
NotebookOutlinePosition[      9642,        366]
CellTagsIndexPosition[      9527,        360]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::shdw", "ObjectName",
 CellID->19566],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol `1` appears in multiple contexts `2`; definitions in \
context `3` may shadow or be shadowed by other definitions.\"\>"}]], "Message",\
 "MSG",
 CellID->783510091],

Cell["\<\
Generated when symbols with the same name occur in  more than one context and \
both contexts are in the context search path. \
\>", "Notes",
 CellID->13161],

Cell["\<\
This message occurs most often when loading packages  that introduce symbols \
with the same names as symbols that have already been  entered or that have \
been introduced by other packages.\
\>", "Notes",
 CellID->12640],

Cell["\<\
 If symbols with the same name exist in more than one context, the name will  \
refer to the symbol that occurs first in the context search path.  Any symbol \
 can be accessed by entering the full context name of the symbol. \
\>", "Notes",
 CellID->10056],

Cell[TextData[{
 "Unwanted symbols can be removed using ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9115],

Cell[TextData[{
 "The contexts in the context search path are  determined by ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19507]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69941426],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61203940],

Cell[TextData[{
 "An error occurs in this example because the symbol ",
 StyleBox["NewFunction", "MR"],
 " is created in more than one context."
}], "ExampleText",
 CellID->44190793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewFunction", "[", "2", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[1]:=",
 CellID->4935],

Cell[BoxData[
 RowBox[{"NewFunction", "[", "2", "]"}]], "Output",
 CellTags->"General::shdw",
 CellLabel->"Out[1]=",
 CellID->18788279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Write", "[", 
  RowBox[{"\"\<TEST.m\>\"", ",", 
   RowBox[{"OutputForm", "[", "\"\<BeginPackage[\\\"TEST`\\\"]\>\"", "]"}]}], 
  "]"}], "\n", 
 RowBox[{"Write", "[", 
  RowBox[{"\"\<TEST.m\>\"", ",", 
   RowBox[{"OutputForm", "[", "\"\<NewFunction[p_]:=p Cos[p]\>\"", "]"}]}], 
  "]"}], "\n", 
 RowBox[{"Write", "[", 
  RowBox[{"\"\<TEST.m\>\"", ",", 
   RowBox[{"OutputForm", "[", "\"\<EndPackage[]\>\"", "]"}]}], "]"}], "\n", 
 RowBox[{"Close", "[", "\"\<TEST.m\>\"", "]"}]}], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[2]:=",
 CellID->1822],

Cell[BoxData["\<\"TEST.m\"\>"], "Output",
 CellTags->"General::shdw",
 CellLabel->"Out[2]=",
 CellID->461463052]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", "\"\<TEST`\>\"", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[3]:=",
 CellID->22338],

Cell[BoxData[
 RowBox[{
  RowBox[{"NewFunction", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"NewFunction\\\"\\) appears in multiple contexts \
\\!\\({\\\"TEST`\\\", \\\"Cell$$142325`\\\"}\\); definitions in context \
\\!\\(\\\"TEST`\\\"\\) may shadow or be shadowed by other \
definitions.\"\>"}]], "Message", "MSG",
 CellTags->"General::shdw",
 CellID->164613606]
}, Open  ]],

Cell["\<\
The symbol from the package context can be accessed by including the context \
with the name of the symbol.\
\>", "ExampleText",
 CellID->615289917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TEST`NewFunction", "[", "2", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[4]:=",
 CellID->11847],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", "2", "]"}]}]], "Output",
 CellTags->"General::shdw",
 CellLabel->"Out[4]=",
 CellID->11020868]
}, Open  ]],

Cell["\<\
Without the context name, the symbol from the package and the definition from \
the package will not be used.\
\>", "ExampleText",
 CellID->517575299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewFunction", "[", "2", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[5]:=",
 CellID->24251],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", "2", "]"}]}]], "Output",
 CellTags->"General::shdw",
 CellLabel->"Out[5]=",
 CellID->69494817]
}, Open  ]],

Cell[TextData[{
 "The symbol from ",
 StyleBox["Global`", "MR"],
 " context can be removed using ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->37750924],

Cell[BoxData[
 RowBox[{"Remove", "[", "NewFunction", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[6]:=",
 CellID->148070873],

Cell["\<\
Now the symbol from the package can be accessed without including the context \
name.\
\>", "ExampleText",
 CellID->112925901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewFunction", "[", "2", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[7]:=",
 CellID->16942],

Cell[BoxData[
 RowBox[{"NewFunction", "[", "2", "]"}]], "Output",
 CellTags->"General::shdw",
 CellLabel->"Out[7]=",
 CellID->427210845]
}, Open  ]],

Cell["Remove the test file.", "ExampleText",
 CellID->382407251],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", "\"\<TEST.m\>\"", "]"}]], "Input",
 CellTags->"General::shdw",
 CellLabel->"In[8]:=",
 CellID->30055]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::shdw - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 50.2566492}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::shdw", "synonyms" -> {}, "title" -> 
    "General::shdw", "type" -> "Message", "uri" -> "ref/message/shdw"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2807, 105, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69941426]},
 "General::shdw"->{
  Cell[3548, 135, 130, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->4935],
  Cell[3681, 141, 135, 4, 70, "Output",
   CellTags->"General::shdw",
   CellID->18788279],
  Cell[3853, 150, 578, 15, 70, "Input",
   CellTags->"General::shdw",
   CellID->1822],
  Cell[4434, 167, 112, 3, 70, "Output",
   CellTags->"General::shdw",
   CellID->461463052],
  Cell[4583, 175, 135, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->22338],
  Cell[4721, 181, 379, 8, 70, "Message",
   CellTags->"General::shdw",
   CellID->164613606],
  Cell[5298, 200, 136, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->11847],
  Cell[5437, 206, 150, 5, 70, "Output",
   CellTags->"General::shdw",
   CellID->11020868],
  Cell[5787, 222, 131, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->24251],
  Cell[5921, 228, 150, 5, 70, "Output",
   CellTags->"General::shdw",
   CellID->69494817],
  Cell[6346, 248, 140, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->148070873],
  Cell[6650, 262, 131, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->16942],
  Cell[6784, 268, 136, 4, 70, "Output",
   CellTags->"General::shdw",
   CellID->427210845],
  Cell[7002, 278, 143, 4, 70, "Input",
   CellTags->"General::shdw",
   CellID->30055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8101, 310},
 {"General::shdw", 8240, 314}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->19566],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 257, 6, 70, "Message",
 CellID->783510091],
Cell[1517, 57, 167, 4, 70, "Notes",
 CellID->13161],
Cell[1687, 63, 232, 5, 70, "Notes",
 CellID->12640],
Cell[1922, 70, 267, 5, 70, "Notes",
 CellID->10056],
Cell[2192, 77, 206, 8, 70, "Notes",
 CellID->9115],
Cell[2401, 87, 369, 13, 70, "Notes",
 CellID->19507]
}, Closed]],
Cell[CellGroupData[{
Cell[2807, 105, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69941426],
Cell[CellGroupData[{
Cell[3191, 119, 147, 5, 70, "ExampleSection",
 CellID->61203940],
Cell[3341, 126, 182, 5, 70, "ExampleText",
 CellID->44190793],
Cell[CellGroupData[{
Cell[3548, 135, 130, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->4935],
Cell[3681, 141, 135, 4, 70, "Output",
 CellTags->"General::shdw",
 CellID->18788279]
}, Open  ]],
Cell[CellGroupData[{
Cell[3853, 150, 578, 15, 70, "Input",
 CellTags->"General::shdw",
 CellID->1822],
Cell[4434, 167, 112, 3, 70, "Output",
 CellTags->"General::shdw",
 CellID->461463052]
}, Open  ]],
Cell[CellGroupData[{
Cell[4583, 175, 135, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->22338],
Cell[4721, 181, 379, 8, 70, "Message",
 CellTags->"General::shdw",
 CellID->164613606]
}, Open  ]],
Cell[5115, 192, 158, 4, 70, "ExampleText",
 CellID->615289917],
Cell[CellGroupData[{
Cell[5298, 200, 136, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->11847],
Cell[5437, 206, 150, 5, 70, "Output",
 CellTags->"General::shdw",
 CellID->11020868]
}, Open  ]],
Cell[5602, 214, 160, 4, 70, "ExampleText",
 CellID->517575299],
Cell[CellGroupData[{
Cell[5787, 222, 131, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->24251],
Cell[5921, 228, 150, 5, 70, "Output",
 CellTags->"General::shdw",
 CellID->69494817]
}, Open  ]],
Cell[6086, 236, 257, 10, 70, "ExampleText",
 CellID->37750924],
Cell[6346, 248, 140, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->148070873],
Cell[6489, 254, 136, 4, 70, "ExampleText",
 CellID->112925901],
Cell[CellGroupData[{
Cell[6650, 262, 131, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->16942],
Cell[6784, 268, 136, 4, 70, "Output",
 CellTags->"General::shdw",
 CellID->427210845]
}, Open  ]],
Cell[6935, 275, 64, 1, 70, "ExampleText",
 CellID->382407251],
Cell[7002, 278, 143, 4, 70, "Input",
 CellTags->"General::shdw",
 CellID->30055]
}, Open  ]]
}, Open  ]],
Cell[7172, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

