(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7791,        290]
NotebookOptionsPosition[      4774,        190]
NotebookOutlinePosition[      6527,        244]
CellTagsIndexPosition[      6410,        238]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::stream", "ObjectName",
 CellID->12701],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stream\"\>"}], ":", 
  " ", "\<\"`1` is not a string, InputStream[ ], or OutputStream[ ].\"\>"}]], \
"Message", "MSG",
 CellID->56237002],

Cell[TextData[{
 "Generated when the indicated expression is expected to  be a string or to \
have a head of ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5201009],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->380952649],

Cell[TextData[{
 "An error occurs in this example because the argument in ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " is a symbol rather than a stream."
}], "ExampleText",
 CellID->84155379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "s", "}"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<result = \>\"", ",", " ", 
     RowBox[{"Read", "[", "s", "]"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"General::stream",
 CellLabel->"In[1]:=",
 CellID->24646],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stream\"\>"}], ":", 
  " ", "\<\"\\!\\(s\\) is not a string, InputStream[ ], or OutputStream[ ].\"\
\>"}]], "Message", "MSG",
 CellTags->"General::stream",
 CellID->213874310],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"result = \"\>", "\[InvisibleSpace]", 
   RowBox[{"Read", "[", "s", "]"}]}],
  SequenceForm["result = ", 
   Read[$CellContext`s]],
  Editable->False]], "Print",
 CellTags->"General::stream",
 CellLabel->"During evaluation of In[1]:=",
 CellID->270458060]
}, Open  ]],

Cell[TextData[{
 "This shows valid stream arguments in ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->51541831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"StringToStream", "[", "\"\<2 + 2\>\"", "]"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<result = \>\"", ",", 
      RowBox[{"Read", "[", "s", "]"}]}], "]"}], ";", 
    RowBox[{"Close", "[", "s", "]"}]}]}], "]"}]], "Input",
 CellTags->"General::stream",
 CellLabel->"In[2]:=",
 CellID->352166997],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"result = \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["result = ", 4],
  Editable->False]], "Print",
 CellTags->"General::stream",
 CellLabel->"During evaluation of In[2]:=",
 CellID->19611906],

Cell[BoxData["String"], "Output",
 CellTags->"General::stream",
 CellLabel->"Out[2]=",
 CellID->200881152]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::stream - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 58.9599970}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::stream", "synonyms" -> {}, "title" -> 
    "General::stream", "type" -> "Message", "uri" -> "ref/message/stream"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1898, 75, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5201009]},
 "General::stream"->{
  Cell[2720, 108, 287, 9, 70, "Input",
   CellTags->"General::stream",
   CellID->24646],
  Cell[3010, 119, 231, 6, 70, "Message",
   CellTags->"General::stream",
   CellID->213874310],
  Cell[3244, 127, 303, 9, 70, "Print",
   CellTags->"General::stream",
   CellID->270458060],
  Cell[3921, 156, 428, 13, 70, "Input",
   CellTags->"General::stream",
   CellID->352166997],
  Cell[4352, 171, 247, 7, 70, "Print",
   CellTags->"General::stream",
   CellID->19611906],
  Cell[4602, 180, 106, 3, 70, "Output",
   CellTags->"General::stream",
   CellID->200881152]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5684, 212},
 {"General::stream", 5823, 216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->12701],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 193, 5, 70, "Message",
 CellID->56237002],
Cell[1455, 56, 406, 14, 70, "Notes",
 CellID->15296]
}, Closed]],
Cell[CellGroupData[{
Cell[1898, 75, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5201009],
Cell[CellGroupData[{
Cell[2281, 89, 148, 5, 70, "ExampleSection",
 CellID->380952649],
Cell[2432, 96, 263, 8, 70, "ExampleText",
 CellID->84155379],
Cell[CellGroupData[{
Cell[2720, 108, 287, 9, 70, "Input",
 CellTags->"General::stream",
 CellID->24646],
Cell[3010, 119, 231, 6, 70, "Message",
 CellTags->"General::stream",
 CellID->213874310],
Cell[3244, 127, 303, 9, 70, "Print",
 CellTags->"General::stream",
 CellID->270458060]
}, Open  ]],
Cell[3562, 139, 334, 13, 70, "ExampleText",
 CellID->51541831],
Cell[CellGroupData[{
Cell[3921, 156, 428, 13, 70, "Input",
 CellTags->"General::stream",
 CellID->352166997],
Cell[4352, 171, 247, 7, 70, "Print",
 CellTags->"General::stream",
 CellID->19611906],
Cell[4602, 180, 106, 3, 70, "Output",
 CellTags->"General::stream",
 CellID->200881152]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4747, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

