(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13038,        450]
NotebookOptionsPosition[      8558,        299]
NotebookOutlinePosition[     10979,        375]
CellTagsIndexPosition[     10861,        369]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::sysname", "ObjectName",
 CellID->3000],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"sysname\"\>"}], ":", 
  " ", "\<\"`1` is not a known SystemOption.\"\>"}]], "Message", "MSG",
 CellID->71366904],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["SetSystemOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetSystemOptions"]], "InlineFormula"],
 " is used with an option name that is not a known system option. "
}], "Notes",
 CellID->26268],

Cell[TextData[{
 "Known system options can be listed by evaluating ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"], "[", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2182]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37952234],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->116166503],

Cell[TextData[{
 "An error occurs in this example because the name given in the argument of  \
",
 Cell[BoxData[
  ButtonBox["SetSystemOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetSystemOptions"]], "InlineFormula"],
 " is not a known system option."
}], "ExampleText",
 CellID->38164186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSystemOptions", "[", 
  RowBox[{"\"\<PackedArrayOptions\>\"", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"\"\<UnpackMessageFlat\>\"", "\[Rule]", "True"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"General::sysname",
 CellLabel->"In[1]:=",
 CellID->26154],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "::", "\<\"sysname\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"UnpackMessageFlat\\\"\\) is not a known SystemOption.\"\
\>"}]], "Message", "MSG",
 CellTags->"General::sysname",
 CellID->692461221],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "False"}]}], 
   "}"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[1]=",
 CellID->89035082],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "False"}]}], 
   "}"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[1]=",
 CellID->8650]
}, Open  ]],

Cell["\<\
This sets a system option that enables certain diagnostic messages.\
\>", "ExampleText",
 CellID->203076565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSystemOptions", "[", 
  RowBox[{"\"\<PackedArrayOptions\>\"", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"\"\<UnpackMessage\>\"", "\[Rule]", "True"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"General::sysname",
 CellLabel->"In[2]:=",
 CellID->20921],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "True"}]}], "}"}]}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[2]=",
 CellID->702351057],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "True"}]}], "}"}]}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[2]=",
 CellID->18753]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"expr", "=", 
     RowBox[{"Range", "[", "5", "]"}]}], "}"}], ",", 
   RowBox[{"expr", "+", "Null"}]}], "]"}]], "Input",
 CellTags->"General::sysname",
 CellLabel->"In[3]:=",
 CellID->18256],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`FromPackedArray", "::", "\<\"unpack1\"\>"}], ":", 
  " ", "\<\"Unpacking array.\"\>"}]], "Message", "MSG",
 CellTags->"General::sysname",
 CellID->571027446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "Null"}], ",", 
   RowBox[{"2", "+", "Null"}], ",", 
   RowBox[{"3", "+", "Null"}], ",", 
   RowBox[{"4", "+", "Null"}], ",", 
   RowBox[{"5", "+", "Null"}]}], "}"}]], "Output",
 CellTags->"General::sysname",
 CellLabel->"Out[3]=",
 CellID->9518209]
}, Open  ]],

Cell["Turn this system option off.", "ExampleText",
 CellID->304280614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSystemOptions", "[", 
  RowBox[{"\"\<PackedArrayOptions\>\"", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"\"\<UnpackMessage\>\"", "\[Rule]", "False"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"General::sysname",
 CellLabel->"In[4]:=",
 CellID->12482],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "False"}]}], 
   "}"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[4]=",
 CellID->56766431],

Cell[BoxData[
 RowBox[{"\<\"PackedArrayOptions\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"ListableAutoPackLength\"\>", "\[Rule]", "250"}], ",", 
    RowBox[{"\<\"PackedArrayMathLinkRead\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedArrayPatterns\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"PackedRange\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"UnpackMessage\"\>", "\[Rule]", "False"}]}], 
   "}"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"General::sysname",
 CellLabel->"Out[4]=",
 CellID->7385]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::sysname - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 7, 14.5697716}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::sysname", "synonyms" -> {}, "title" -> 
    "General::sysname", "type" -> "Message", "uri" -> 
    "ref/message/sysname"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1994, 79, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37952234]},
 "General::sysname"->{
  Cell[2858, 113, 278, 8, 70, "Input",
   CellTags->"General::sysname",
   CellID->26154],
  Cell[3139, 123, 242, 6, 70, "Message",
   CellTags->"General::sysname",
   CellID->692461221],
  Cell[3384, 131, 578, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->89035082],
  Cell[3965, 147, 574, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->8650],
  Cell[4697, 171, 274, 8, 70, "Input",
   CellTags->"General::sysname",
   CellID->20921],
  Cell[4974, 181, 576, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->702351057],
  Cell[5553, 197, 572, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->18753],
  Cell[6162, 216, 268, 9, 70, "Input",
   CellTags->"General::sysname",
   CellID->18256],
  Cell[6433, 227, 202, 5, 70, "Message",
   CellTags->"General::sysname",
   CellID->571027446],
  Cell[6638, 234, 310, 10, 70, "Output",
   CellTags->"General::sysname",
   CellID->9518209],
  Cell[7059, 252, 275, 8, 70, "Input",
   CellTags->"General::sysname",
   CellID->12482],
  Cell[7337, 262, 578, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->56766431],
  Cell[7918, 278, 574, 14, 70, "Output",
   CellTags->"General::sysname",
   CellID->7385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9477, 322},
 {"General::sysname", 9618, 326}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->3000],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 168, 4, 70, "Message",
 CellID->71366904],
Cell[1430, 55, 267, 8, 70, "Notes",
 CellID->26268],
Cell[1700, 65, 257, 9, 70, "Notes",
 CellID->2182]
}, Closed]],
Cell[CellGroupData[{
Cell[1994, 79, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37952234],
Cell[CellGroupData[{
Cell[2378, 93, 148, 5, 70, "ExampleSection",
 CellID->116166503],
Cell[2529, 100, 304, 9, 70, "ExampleText",
 CellID->38164186],
Cell[CellGroupData[{
Cell[2858, 113, 278, 8, 70, "Input",
 CellTags->"General::sysname",
 CellID->26154],
Cell[3139, 123, 242, 6, 70, "Message",
 CellTags->"General::sysname",
 CellID->692461221],
Cell[3384, 131, 578, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->89035082],
Cell[3965, 147, 574, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->8650]
}, Open  ]],
Cell[4554, 164, 118, 3, 70, "ExampleText",
 CellID->203076565],
Cell[CellGroupData[{
Cell[4697, 171, 274, 8, 70, "Input",
 CellTags->"General::sysname",
 CellID->20921],
Cell[4974, 181, 576, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->702351057],
Cell[5553, 197, 572, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->18753]
}, Open  ]],
Cell[CellGroupData[{
Cell[6162, 216, 268, 9, 70, "Input",
 CellTags->"General::sysname",
 CellID->18256],
Cell[6433, 227, 202, 5, 70, "Message",
 CellTags->"General::sysname",
 CellID->571027446],
Cell[6638, 234, 310, 10, 70, "Output",
 CellTags->"General::sysname",
 CellID->9518209]
}, Open  ]],
Cell[6963, 247, 71, 1, 70, "ExampleText",
 CellID->304280614],
Cell[CellGroupData[{
Cell[7059, 252, 275, 8, 70, "Input",
 CellTags->"General::sysname",
 CellID->12482],
Cell[7337, 262, 578, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->56766431],
Cell[7918, 278, 574, 14, 70, "Output",
 CellTags->"General::sysname",
 CellID->7385]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8531, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

