(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15002,        464]
NotebookOptionsPosition[      6342,        236]
NotebookOutlinePosition[     12971,        402]
CellTagsIndexPosition[     12675,        393]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::mnmord1
PolynomialReduce::mnmord1
GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1
GroebnerBasis`DistributedTermsList::mnmord1\
\>", "ObjectName",
 CellID->29572],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"mnmord1\"\>"}], ":", 
  " ", "\<\"Value of option MonomialOrder -> `1` is not valid.\"\>"}]], \
"Message", "MSG",
 CellID->464361836],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option does not match any of the expected forms."
}], "Notes",
 CellID->25041],

Cell[TextData[{
 "For  information about valid values of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option, see the documentation for ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10985],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option can be ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 ", ",
 Cell[BoxData["DegreeLexicographic"], "InlineFormula"],
 ", ",
 Cell[BoxData["DegreeReverseLexicographic"], "InlineFormula"],
 ", ",
 Cell[BoxData["EliminationOrder"], "InlineFormula"],
 ", or a weight matrix."
}], "Notes",
 CellID->14060]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75941389],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->18084600],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is not a valid value for the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->404596794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", "Automatic"}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellLabel->"In[1]:=",
 CellID->30641],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "::", "\<\"mnmord1\"\>"}], ":", 
  " ", "\<\"Value of option MonomialOrder -> \\!\\(Automatic\\) is not valid.\
\"\>"}]], "Message", "MSG",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->197119105],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{"x", "-", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "Automatic"}]}], "]"}]], "Output",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellLabel->"Out[1]=",
 CellID->10032691]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->167089773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", "DegreeLexicographic"}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellLabel->"In[2]:=",
 CellID->30801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", "y"}], ",", 
   SuperscriptBox["y", "2"]}], "}"}]], "Output",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellLabel->"Out[2]=",
 CellID->456910507]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::mnmord1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 18.5870354}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::mnmord1 PolynomialReduce::mnmord1 \
GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1 \
GroebnerBasis`DistributedTermsList::mnmord1", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::mnmord1", "type" -> "Message", "uri" -> 
    "ref/message/mnmord1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2613, 101, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->75941389]},
 "GroebnerBasis::mnmord1"->{
  Cell[3489, 136, 565, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30641],
  Cell[4057, 155, 388, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->197119105],
  Cell[4448, 166, 575, 17, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->10032691],
  Cell[5355, 200, 575, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30801],
  Cell[5933, 219, 343, 10, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->456910507]},
 "PolynomialReduce::mnmord1"->{
  Cell[3489, 136, 565, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30641],
  Cell[4057, 155, 388, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->197119105],
  Cell[4448, 166, 575, 17, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->10032691],
  Cell[5355, 200, 575, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30801],
  Cell[5933, 219, 343, 10, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->456910507]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1"->{
  Cell[3489, 136, 565, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30641],
  Cell[4057, 155, 388, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->197119105],
  Cell[4448, 166, 575, 17, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->10032691],
  Cell[5355, 200, 575, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30801],
  Cell[5933, 219, 343, 10, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->456910507]},
 "GroebnerBasis`DistributedTermsList::mnmord1"->{
  Cell[3489, 136, 565, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30641],
  Cell[4057, 155, 388, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->197119105],
  Cell[4448, 166, 575, 17, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->10032691],
  Cell[5355, 200, 575, 17, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->30801],
  Cell[5933, 219, 343, 10, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
     "GroebnerBasis`DistributedTermsList::mnmord1"},
   CellID->456910507]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7407, 262},
 {"GroebnerBasis::mnmord1", 7555, 266},
 {"PolynomialReduce::mnmord1", 8827, 297},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 10122, 328},
 {"GroebnerBasis`DistributedTermsList::mnmord1", 11412, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 187, 6, 70, "ObjectName",
 CellID->29572],
Cell[CellGroupData[{
Cell[915, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1393, 54, 210, 6, 70, "Message",
 CellID->464361836],
Cell[1606, 62, 184, 5, 70, "Notes",
 CellID->25041],
Cell[1793, 69, 376, 12, 70, "Notes",
 CellID->10985],
Cell[2172, 83, 404, 13, 70, "Notes",
 CellID->14060]
}, Closed]],
Cell[CellGroupData[{
Cell[2613, 101, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75941389],
Cell[CellGroupData[{
Cell[2997, 115, 147, 5, 70, "ExampleSection",
 CellID->18084600],
Cell[3147, 122, 317, 10, 70, "ExampleText",
 CellID->404596794],
Cell[CellGroupData[{
Cell[3489, 136, 565, 17, 70, "Input",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->30641],
Cell[4057, 155, 388, 9, 70, "Message",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->197119105],
Cell[4448, 166, 575, 17, 70, "Output",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->10032691]
}, Open  ]],
Cell[5038, 186, 292, 10, 70, "ExampleText",
 CellID->167089773],
Cell[CellGroupData[{
Cell[5355, 200, 575, 17, 70, "Input",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->30801],
Cell[5933, 219, 343, 10, 70, "Output",
 CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1", 
   "GroebnerBasis`DistributedTermsList::mnmord1"},
 CellID->456910507]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6315, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

