(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10358,        326]
NotebookOptionsPosition[      4443,        166]
NotebookOutlinePosition[      9019,        284]
CellTagsIndexPosition[      8729,        275]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::modflt
PolynomialReduce::modflt
GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt
GroebnerBasis`DistributedTermsList::modflt\
\>", "ObjectName",
 CellID->4895],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"modflt\"\>"}], ":", 
  " ", "\<\"Cannot specify nonzero modulus when working with inexact \
coefficients.\"\>"}]], "Message", "MSG",
 CellID->602756215],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option is nonzero and the value of the ",
 Cell[BoxData["CoefficientDomain"], "InlineFormula"],
 " option is ",
 Cell[BoxData["InexactNumbers"], "InlineFormula"],
 "."
}], "Notes",
 CellID->28780]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201445678],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->358353149],

Cell[TextData[{
 "An error occurs in this example because a nonzero value for the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option is not compatible with ",
 StyleBox["CoefficientDomain->InexactNumbers", "MR"],
 "."
}], "ExampleText",
 CellID->64261134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5.7", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"3.3", 
     RowBox[{"y", "^", "2"}]}]}], ",", 
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"CoefficientDomain", "->", "InexactNumbers"}], ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellLabel->"In[1]:=",
 CellID->8497],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialReduce", "::", "\<\"modflt\"\>"}], ":", 
  " ", "\<\"Cannot specify nonzero modulus when working with inexact \
coefficients.\"\>"}]], "Message", "MSG",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellID->355220101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5.7`", " ", "x"}], "-", 
       RowBox[{"5.7`", " ", "y"}]}], ")"}]}], "}"}], ",", 
   RowBox[{"9.`", " ", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellLabel->"Out[1]=",
 CellID->9856665]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::modflt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 18.9151688}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::modflt PolynomialReduce::modflt \
GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt \
GroebnerBasis`DistributedTermsList::modflt", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::modflt", "type" -> "Message", "uri" -> 
    "ref/message/modflt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2026, 79, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->201445678]},
 "GroebnerBasis::modflt"->{
  Cell[2921, 114, 553, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->8497],
  Cell[3477, 132, 391, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->355220101],
  Cell[3871, 143, 506, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->9856665]},
 "PolynomialReduce::modflt"->{
  Cell[2921, 114, 553, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->8497],
  Cell[3477, 132, 391, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->355220101],
  Cell[3871, 143, 506, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->9856665]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt"->{
  Cell[2921, 114, 553, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->8497],
  Cell[3477, 132, 391, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->355220101],
  Cell[3871, 143, 506, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->9856665]},
 "GroebnerBasis`DistributedTermsList::modflt"->{
  Cell[2921, 114, 553, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->8497],
  Cell[3477, 132, 391, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->355220101],
  Cell[3871, 143, 506, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
     "GroebnerBasis`DistributedTermsList::modflt"},
   CellID->9856665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5501, 192},
 {"GroebnerBasis::modflt", 5648, 196},
 {"PolynomialReduce::modflt", 6410, 215},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 7195, 234},
 {"GroebnerBasis`DistributedTermsList::modflt", 7975, 253}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 182, 6, 70, "ObjectName",
 CellID->4895],
Cell[CellGroupData[{
Cell[910, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1388, 54, 229, 6, 70, "Message",
 CellID->602756215],
Cell[1620, 62, 369, 12, 70, "Notes",
 CellID->28780]
}, Closed]],
Cell[CellGroupData[{
Cell[2026, 79, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201445678],
Cell[CellGroupData[{
Cell[2411, 93, 148, 5, 70, "ExampleSection",
 CellID->358353149],
Cell[2562, 100, 334, 10, 70, "ExampleText",
 CellID->64261134],
Cell[CellGroupData[{
Cell[2921, 114, 553, 16, 70, "Input",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellID->8497],
Cell[3477, 132, 391, 9, 70, "Message",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellID->355220101],
Cell[3871, 143, 506, 16, 70, "Output",
 CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt", 
   "GroebnerBasis`DistributedTermsList::modflt"},
 CellID->9856665]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4416, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

