(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8827,        296]
NotebookOptionsPosition[      4720,        184]
NotebookOutlinePosition[      7435,        253]
CellTagsIndexPosition[      7263,        246]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
HermiteDecomposition::latm
LatticeReduce::latm\
\>", "ObjectName",
 CellID->4249],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"latm\"\>"}], ":", 
  " ", "\<\"Matrix contains an entry that is not rational.\"\>"}]], "Message",\
 "MSG",
 CellID->137393791],

Cell[TextData[{
 "Generated when the argument in ",
 Cell[BoxData[
  ButtonBox["HermiteDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " is a matrix with at least one element that is neither an exact integer nor \
an exact rational number."
}], "Notes",
 CellID->14651]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97563525],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->317773297],

Cell["\<\
The element 4.5 is a real number rather than an exact integer or a rational \
number.\
\>", "ExampleText",
 CellID->302373823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", " ", "4.5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellLabel->"In[1]:=",
 CellID->14798],

Cell[BoxData[
 RowBox[{
  RowBox[{"LatticeReduce", "::", "\<\"latm\"\>"}], ":", 
  " ", "\<\"Matrix contains an entry that is not rational.\"\>"}]], "Message",\
 "MSG",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->340408465],

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4.5`"}], "}"}]}], "}"}], "]"}]], "Output",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellLabel->"Out[1]=",
 CellID->88025856]
}, Open  ]],

Cell[TextData[{
 "The inexact number can be converted to an exact rational number using ",
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->1356939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"Rationalize", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4.5"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellLabel->"In[2]:=",
 CellID->22721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellLabel->"Out[2]=",
 CellID->442673994]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HermiteDecomposition::latm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 26.3216084}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "HermiteDecomposition::latm LatticeReduce::latm", 
    "synonyms" -> {}, "title" -> "HermiteDecomposition::latm", "type" -> 
    "Message", "uri" -> "ref/message/latm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2008, 79, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->97563525]},
 "LatticeReduce::latm"->{
  Cell[2704, 108, 344, 10, 70, "Input",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->14798],
  Cell[3051, 120, 261, 6, 70, "Message",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->340408465],
  Cell[3315, 128, 334, 10, 70, "Output",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->88025856],
  Cell[3946, 153, 373, 11, 70, "Input",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->22721],
  Cell[4322, 166, 332, 11, 70, "Output",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->442673994]},
 "Developer`HermiteNormalForm::latm"->{
  Cell[2704, 108, 344, 10, 70, "Input",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->14798],
  Cell[3051, 120, 261, 6, 70, "Message",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->340408465],
  Cell[3315, 128, 334, 10, 70, "Output",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->88025856],
  Cell[3946, 153, 373, 11, 70, "Input",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->22721],
  Cell[4322, 166, 332, 11, 70, "Output",
   CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
   CellID->442673994]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5686, 207},
 {"LatticeReduce::latm", 5830, 211},
 {"Developer`HermiteNormalForm::latm", 6555, 227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 4, 70, "ObjectName",
 CellID->4249],
Cell[CellGroupData[{
Cell[819, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 52, 203, 6, 70, "Message",
 CellID->137393791],
Cell[1503, 60, 468, 14, 70, "Notes",
 CellID->14651]
}, Closed]],
Cell[CellGroupData[{
Cell[2008, 79, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97563525],
Cell[CellGroupData[{
Cell[2392, 93, 148, 5, 70, "ExampleSection",
 CellID->317773297],
Cell[2543, 100, 136, 4, 70, "ExampleText",
 CellID->302373823],
Cell[CellGroupData[{
Cell[2704, 108, 344, 10, 70, "Input",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->14798],
Cell[3051, 120, 261, 6, 70, "Message",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->340408465],
Cell[3315, 128, 334, 10, 70, "Output",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->88025856]
}, Open  ]],
Cell[3664, 141, 257, 8, 70, "ExampleText",
 CellID->1356939],
Cell[CellGroupData[{
Cell[3946, 153, 373, 11, 70, "Input",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->22721],
Cell[4322, 166, 332, 11, 70, "Output",
 CellTags->{"LatticeReduce::latm", "Developer`HermiteNormalForm::latm"},
 CellID->442673994]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4693, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

