(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9444,        363]
NotebookOptionsPosition[      5770,        237]
NotebookOutlinePosition[      7756,        300]
CellTagsIndexPosition[      7642,        294]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Inner::incom", "ObjectName",
 CellID->8126],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inner", "::", "\<\"incom\"\>"}], ":", 
  " ", "\<\"Length `1` of dimension `2` in `3` is incommensurate with length \
`4` of dimension 1 in `5`.\"\>"}]], "Message", "MSG",
 CellID->159916450],

Cell[TextData[{
 "Generated when the dimensions to be combined by ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " do not have the same length."
}], "Notes",
 CellID->15740]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38232450],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11486282],

Cell["\<\
An error occurs in this example because the length of the inner dimension in \
the second argument is not the same as the length of the outer dimension of \
the third argument.\
\>", "ExampleText",
 CellID->566370633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "40", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Inner::incom",
 CellLabel->"In[1]:=",
 CellID->16825],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inner", "::", "\<\"incom\"\>"}], ":", 
  " ", "\<\"Length \\!\\(1\\) of dimension \\!\\(2\\) in \\!\\({\\(\\({30}\\)\
\\), \\(\\({40}\\)\\)}\\) is incommensurate with length \\!\\(2\\) of \
dimension 1 in \\!\\({2, 3}\\).\"\>"}]], "Message", "MSG",
 CellTags->"Inner::incom",
 CellID->50243281],

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "40", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Output",
 CellTags->"Inner::incom",
 CellLabel->"Out[1]=",
 CellID->4081154]
}, Open  ]],

Cell[TextData[{
 "This shows valid input in ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->266777395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"30", ",", "40"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Inner::incom",
 CellLabel->"In[2]:=",
 CellID->1794],

Cell[BoxData[
 RowBox[{"{", "75", "}"}]], "Output",
 CellTags->"Inner::incom",
 CellLabel->"Out[2]=",
 CellID->346125462]
}, Open  ]],

Cell[TextData[{
 "Dimensions can be usefully rearranged using ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->66576962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "30", "}"}], ",", 
      RowBox[{"{", "40", "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Inner::incom",
 CellLabel->"In[3]:=",
 CellID->24238],

Cell[BoxData[
 RowBox[{"{", "75", "}"}]], "Output",
 CellTags->"Inner::incom",
 CellLabel->"Out[3]=",
 CellID->117734677]
}, Open  ]],

Cell[TextData[{
 "The optional fifth argument in ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " can be used to specify which dimension of the second argument should be  \
used."
}], "ExampleText",
 CellID->377094690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "40", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", "Times", ",", "1"}], "]"}]], "Input",\

 CellTags->"Inner::incom",
 CellLabel->"In[4]:=",
 CellID->104955663],

Cell[BoxData[
 RowBox[{"{", "1376", "}"}]], "Output",
 CellTags->"Inner::incom",
 CellLabel->"Out[4]=",
 CellID->49291867]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inner::incom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 6.2757562}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Inner::incom", "synonyms" -> {}, "title" -> "Inner::incom", 
    "type" -> "Message", "uri" -> "ref/message/incom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1764, 69, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38232450]},
 "Inner::incom"->{
  Cell[2550, 99, 312, 11, 70, "Input",
   CellTags->"Inner::incom",
   CellID->16825],
  Cell[2865, 112, 329, 7, 70, "Message",
   CellTags->"Inner::incom",
   CellID->50243281],
  Cell[3197, 121, 315, 11, 70, "Output",
   CellTags->"Inner::incom",
   CellID->4081154],
  Cell[3755, 147, 285, 10, 70, "Input",
   CellTags->"Inner::incom",
   CellID->1794],
  Cell[4043, 159, 121, 4, 70, "Output",
   CellTags->"Inner::incom",
   CellID->346125462],
  Cell[4432, 178, 353, 12, 70, "Input",
   CellTags->"Inner::incom",
   CellID->24238],
  Cell[4788, 192, 121, 4, 70, "Output",
   CellTags->"Inner::incom",
   CellID->117734677],
  Cell[5237, 212, 342, 12, 70, "Input",
   CellTags->"Inner::incom",
   CellID->104955663],
  Cell[5582, 226, 122, 4, 70, "Output",
   CellTags->"Inner::incom",
   CellID->49291867]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6669, 259},
 {"Inner::incom", 6806, 263}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->8126],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 226, 5, 70, "Message",
 CellID->159916450],
Cell[1484, 56, 243, 8, 70, "Notes",
 CellID->15740]
}, Closed]],
Cell[CellGroupData[{
Cell[1764, 69, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38232450],
Cell[CellGroupData[{
Cell[2148, 83, 147, 5, 70, "ExampleSection",
 CellID->11486282],
Cell[2298, 90, 227, 5, 70, "ExampleText",
 CellID->566370633],
Cell[CellGroupData[{
Cell[2550, 99, 312, 11, 70, "Input",
 CellTags->"Inner::incom",
 CellID->16825],
Cell[2865, 112, 329, 7, 70, "Message",
 CellTags->"Inner::incom",
 CellID->50243281],
Cell[3197, 121, 315, 11, 70, "Output",
 CellTags->"Inner::incom",
 CellID->4081154]
}, Open  ]],
Cell[3527, 135, 203, 8, 70, "ExampleText",
 CellID->266777395],
Cell[CellGroupData[{
Cell[3755, 147, 285, 10, 70, "Input",
 CellTags->"Inner::incom",
 CellID->1794],
Cell[4043, 159, 121, 4, 70, "Output",
 CellTags->"Inner::incom",
 CellID->346125462]
}, Open  ]],
Cell[4179, 166, 228, 8, 70, "ExampleText",
 CellID->66576962],
Cell[CellGroupData[{
Cell[4432, 178, 353, 12, 70, "Input",
 CellTags->"Inner::incom",
 CellID->24238],
Cell[4788, 192, 121, 4, 70, "Output",
 CellTags->"Inner::incom",
 CellID->117734677]
}, Open  ]],
Cell[4924, 199, 288, 9, 70, "ExampleText",
 CellID->377094690],
Cell[CellGroupData[{
Cell[5237, 212, 342, 12, 70, "Input",
 CellTags->"Inner::incom",
 CellID->104955663],
Cell[5582, 226, 122, 4, 70, "Output",
 CellTags->"Inner::incom",
 CellID->49291867]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5743, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

