(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14203,        457]
NotebookOptionsPosition[      7365,        269]
NotebookOutlinePosition[     11729,        381]
CellTagsIndexPosition[     11566,        374]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
IntegerDigits::ibase
IntegerExponent::ibase
IntegerLength::ibase\
\>", "ObjectName",
 CellID->15998],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ibase\"\>"}], ":", 
  " ", "\<\"Base `1` is not an integer greater than 1.\"\>"}]], "Message", \
"MSG",
 CellID->362456001],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["IntegerExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerExponent"]], "InlineFormula"],
 " is not an integer or is less than 2."
}], "Notes",
 CellID->12807]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163862062],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->225004391],

Cell["\<\
An error occurs in this example because the second argument is not an \
integer.\
\>", "ExampleText",
 CellID->134153626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"57", ",", "1.5"}], "]"}]], "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"In[1]:=",
 CellID->5361],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerDigits", "::", "\<\"ibase\"\>"}], ":", 
  " ", "\<\"Base \\!\\(1.5`\\) is not an integer greater than 1.\"\>"}]], \
"Message", "MSG",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->592469833],

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"57", ",", "1.5`"}], "]"}]], "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"Out[1]=",
 CellID->398710156]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->612952160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"57", ",", "2"}], "]"}]], "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"In[2]:=",
 CellID->15446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"Out[2]=",
 CellID->92982098]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " to get digits in a base that is not an integer."
}], "ExampleText",
 CellID->192585592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"57.0", ",", "1.5"}], "]"}]], "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"In[3]:=",
 CellID->25960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", 
     ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
     ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", "10"}], 
  "}"}]], "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"Out[3]=",
 CellID->497358708]
}, Open  ]],

Cell[TextData[{
 "An error occurs in this example because zero is not a valid value for the  \
second argument in ",
 Cell[BoxData[
  ButtonBox["IntegerExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerExponent"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->655325575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", "0"}], "]"}]], "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"In[4]:=",
 CellID->5777],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerExponent", "::", "\<\"ibase\"\>"}], ":", 
  " ", "\<\"Base \\!\\(0\\) is not an integer greater than 1.\"\>"}]], \
"Message", "MSG",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->350052164],

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{"265252859812191058636308480000000", ",", "0"}], "]"}]], "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"Out[4]=",
 CellID->101554526]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["IntegerExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerExponent"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->458943950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", "5"}], "]"}]], "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"In[5]:=",
 CellID->11364],

Cell[BoxData["7"], "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellLabel->"Out[5]=",
 CellID->191578436]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerDigits::ibase - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 6.8695214}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "IntegerDigits::ibase IntegerExponent::ibase IntegerLength::ibase", 
    "synonyms" -> {}, "title" -> "IntegerDigits::ibase", "type" -> "Message", 
    "uri" -> "ref/message/ibase"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1955, 79, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->163862062]},
 "IntegerDigits::ibase"->{
  Cell[2647, 108, 193, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->5361],
  Cell[2843, 115, 258, 6, 70, "Message",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->592469833],
  Cell[3104, 123, 200, 5, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->398710156],
  Cell[3567, 143, 192, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->15446],
  Cell[3762, 150, 221, 6, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->92982098],
  Cell[4269, 171, 193, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->25960],
  Cell[4465, 178, 1179, 21, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->497358708],
  Cell[5977, 215, 212, 6, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->5777],
  Cell[6192, 223, 257, 6, 70, "Message",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->350052164],
  Cell[6452, 231, 230, 5, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->101554526],
  Cell[6949, 251, 213, 6, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->11364],
  Cell[7165, 259, 134, 3, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->191578436]},
 "IntegerExponent::ibase"->{
  Cell[2647, 108, 193, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->5361],
  Cell[2843, 115, 258, 6, 70, "Message",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->592469833],
  Cell[3104, 123, 200, 5, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->398710156],
  Cell[3567, 143, 192, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->15446],
  Cell[3762, 150, 221, 6, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->92982098],
  Cell[4269, 171, 193, 5, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->25960],
  Cell[4465, 178, 1179, 21, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->497358708],
  Cell[5977, 215, 212, 6, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->5777],
  Cell[6192, 223, 257, 6, 70, "Message",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->350052164],
  Cell[6452, 231, 230, 5, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->101554526],
  Cell[6949, 251, 213, 6, 70, "Input",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->11364],
  Cell[7165, 259, 134, 3, 70, "Output",
   CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
   CellID->191578436]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8342, 293},
 {"IntegerDigits::ibase", 8488, 297},
 {"IntegerExponent::ibase", 10030, 334}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 110, 5, 70, "ObjectName",
 CellID->15998],
Cell[CellGroupData[{
Cell[838, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1316, 53, 200, 6, 70, "Message",
 CellID->362456001],
Cell[1519, 61, 399, 13, 70, "Notes",
 CellID->12807]
}, Closed]],
Cell[CellGroupData[{
Cell[1955, 79, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163862062],
Cell[CellGroupData[{
Cell[2340, 93, 148, 5, 70, "ExampleSection",
 CellID->225004391],
Cell[2491, 100, 131, 4, 70, "ExampleText",
 CellID->134153626],
Cell[CellGroupData[{
Cell[2647, 108, 193, 5, 70, "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->5361],
Cell[2843, 115, 258, 6, 70, "Message",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->592469833],
Cell[3104, 123, 200, 5, 70, "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->398710156]
}, Open  ]],
Cell[3319, 131, 223, 8, 70, "ExampleText",
 CellID->612952160],
Cell[CellGroupData[{
Cell[3567, 143, 192, 5, 70, "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->15446],
Cell[3762, 150, 221, 6, 70, "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->92982098]
}, Open  ]],
Cell[3998, 159, 246, 8, 70, "ExampleText",
 CellID->192585592],
Cell[CellGroupData[{
Cell[4269, 171, 193, 5, 70, "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->25960],
Cell[4465, 178, 1179, 21, 70, "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->497358708]
}, Open  ]],
Cell[5659, 202, 293, 9, 70, "ExampleText",
 CellID->655325575],
Cell[CellGroupData[{
Cell[5977, 215, 212, 6, 70, "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->5777],
Cell[6192, 223, 257, 6, 70, "Message",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->350052164],
Cell[6452, 231, 230, 5, 70, "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->101554526]
}, Open  ]],
Cell[6697, 239, 227, 8, 70, "ExampleText",
 CellID->458943950],
Cell[CellGroupData[{
Cell[6949, 251, 213, 6, 70, "Input",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->11364],
Cell[7165, 259, 134, 3, 70, "Output",
 CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"},
 CellID->191578436]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7338, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

