(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6657,        239]
NotebookOptionsPosition[      3971,        150]
NotebookOutlinePosition[      5565,        199]
CellTagsIndexPosition[      5445,        193]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Integrate::diffend", "ObjectName",
 CellID->8500],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"diffend\"\>"}], ":", 
  " ", "\<\"`1` cannot be interpreted since `2` is followed by `3`. It may be \
necessary to use parentheses to ensure that `2` appears at the end of the \
integral.\"\>"}]], "Message", "MSG",
 CellID->245974122],

Cell[TextData[{
 "Generated when the differential used to specify the   variable of \
integration is not the last element in a typeset ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->27666]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->384779741],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->99133583],

Cell["\<\
An error occurs in this example because the integrand occurs after the \
differential expression.\
\>", "ExampleText",
 CellID->40843910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"\[DifferentialD]", "x"}], " ", "x", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}]}]], "Input",
 EmphasizeSyntaxErrors->True,
 CellTags->"Integrate::diffend",
 CellLabel->"In[1]:=",
 CellID->4359],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"diffend\"\>"}], ":", 
  " ", "\<\"\\!\\(\[Integral] \\(\\(\\(\\(\[DifferentialD] x\\)\\) x \
\\(\\(Cos[x]\\)\\)\\)\\)\\) cannot be interpreted since \
\\!\\(\[DifferentialD] x\\) is followed by \\!\\(x \\(\\(Cos[x]\\)\\)\\). It \
may be necessary to use parentheses to ensure that \\!\\(\[DifferentialD] \
x\\) appears at the end of the integral.\"\>"}]], "Message", "MSG",
 CellTags->"Integrate::diffend",
 CellID->112337819]
}, Open  ]],

Cell["This shows a valid typeset input for an integral.", "ExampleText",
 CellID->97128361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"Cos", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellTags->"Integrate::diffend",
 CellLabel->"In[2]:=",
 CellID->8256],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 CellTags->"Integrate::diffend",
 CellLabel->"Out[2]=",
 CellID->371849319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate::diffend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 14.2915864}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Integrate::diffend", "synonyms" -> {}, "title" -> 
    "Integrate::diffend", "type" -> "Message", "uri" -> 
    "ref/message/diffend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1896, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->384779741]},
 "Integrate::diffend"->{
  Cell[2603, 100, 253, 8, 70, "Input",
   CellTags->"Integrate::diffend",
   CellID->4359],
  Cell[2859, 110, 484, 9, 70, "Message",
   CellTags->"Integrate::diffend",
   CellID->112337819],
  Cell[3474, 127, 218, 7, 70, "Input",
   CellTags->"Integrate::diffend",
   CellID->8256],
  Cell[3695, 136, 210, 7, 70, "Output",
   CellTags->"Integrate::diffend",
   CellID->371849319]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4896, 173},
 {"Integrate::diffend", 5040, 177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->8500],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 292, 6, 70, "Message",
 CellID->245974122],
Cell[1556, 57, 303, 9, 70, "Notes",
 CellID->27666]
}, Closed]],
Cell[CellGroupData[{
Cell[1896, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->384779741],
Cell[CellGroupData[{
Cell[2281, 85, 147, 5, 70, "ExampleSection",
 CellID->99133583],
Cell[2431, 92, 147, 4, 70, "ExampleText",
 CellID->40843910],
Cell[CellGroupData[{
Cell[2603, 100, 253, 8, 70, "Input",
 CellTags->"Integrate::diffend",
 CellID->4359],
Cell[2859, 110, 484, 9, 70, "Message",
 CellTags->"Integrate::diffend",
 CellID->112337819]
}, Open  ]],
Cell[3358, 122, 91, 1, 70, "ExampleText",
 CellID->97128361],
Cell[CellGroupData[{
Cell[3474, 127, 218, 7, 70, "Input",
 CellTags->"Integrate::diffend",
 CellID->8256],
Cell[3695, 136, 210, 7, 70, "Output",
 CellTags->"Integrate::diffend",
 CellID->371849319]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3944, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

