(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7204,        270]
NotebookOptionsPosition[      4311,        174]
NotebookOutlinePosition[      5970,        225]
CellTagsIndexPosition[      5853,        219]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Integrate::ilim", "ObjectName",
 CellID->18950],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"ilim\"\>"}], ":", 
  " ", "\<\"Invalid integration variable or limit(s) in `1`.\"\>"}]], \
"Message", "MSG",
 CellID->806644545],

Cell["\<\
Generated when the second argument in a definite  integral is a list with \
less than three elements.\
\>", "Notes",
 CellID->23093],

Cell[TextData[{
 "The  first argument in ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " gives the integrand, and remaining arguments are expected to be variables  \
(for indefinite integration) or lists of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[", ", "MR"],
 StyleBox["xmin", "MR",
  FontSlant->"Italic"],
 StyleBox[", ", "MR"],
 StyleBox["xmax", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " (for definite integration)."
}], "Notes",
 CellID->29267]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->532908879],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->237193048],

Cell["\<\
An error occurs in this example because only one of the limits of integration \
is specified.\
\>", "ExampleText",
 CellID->107413877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Integrate::ilim",
 CellLabel->"In[1]:=",
 CellID->19308],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"ilim\"\>"}], ":", 
  " ", "\<\"Invalid integration variable or limit(s) in \\!\\({x, \
\[Infinity]}\\).\"\>"}]], "Message", "MSG",
 CellTags->"Integrate::ilim",
 CellID->359696219],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "\[Infinity]"}], "}"}]}]}]}]], "Output",
 CellTags->"Integrate::ilim",
 CellLabel->"Out[1]=",
 CellID->433581942]
}, Open  ]],

Cell["This shows a valid specification of a definite integral.", "ExampleText",
 CellID->597968191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Integrate::ilim",
 CellLabel->"In[2]:=",
 CellID->15545124],

Cell[BoxData["1"], "Output",
 CellTags->"Integrate::ilim",
 CellLabel->"Out[2]=",
 CellID->15094134]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate::ilim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 14.6822214}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Integrate::ilim", "synonyms" -> {}, "title" -> 
    "Integrate::ilim", "type" -> "Message", "uri" -> "ref/message/ilim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2219, 87, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->532908879]},
 "Integrate::ilim"->{
  Cell[2924, 116, 261, 9, 70, "Input",
   CellTags->"Integrate::ilim",
   CellID->19308],
  Cell[3188, 127, 238, 6, 70, "Message",
   CellTags->"Integrate::ilim",
   CellID->359696219],
  Cell[3429, 135, 300, 10, 70, "Output",
   CellTags->"Integrate::ilim",
   CellID->433581942],
  Cell[3868, 153, 274, 9, 70, "Input",
   CellTags->"Integrate::ilim",
   CellID->15545124],
  Cell[4145, 164, 100, 3, 70, "Output",
   CellTags->"Integrate::ilim",
   CellID->15094134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5219, 196},
 {"Integrate::ilim", 5360, 200}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->18950],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 186, 5, 70, "Message",
 CellID->806644545],
Cell[1448, 56, 142, 4, 70, "Notes",
 CellID->23093],
Cell[1593, 62, 589, 20, 70, "Notes",
 CellID->29267]
}, Closed]],
Cell[CellGroupData[{
Cell[2219, 87, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->532908879],
Cell[CellGroupData[{
Cell[2604, 101, 148, 5, 70, "ExampleSection",
 CellID->237193048],
Cell[2755, 108, 144, 4, 70, "ExampleText",
 CellID->107413877],
Cell[CellGroupData[{
Cell[2924, 116, 261, 9, 70, "Input",
 CellTags->"Integrate::ilim",
 CellID->19308],
Cell[3188, 127, 238, 6, 70, "Message",
 CellTags->"Integrate::ilim",
 CellID->359696219],
Cell[3429, 135, 300, 10, 70, "Output",
 CellTags->"Integrate::ilim",
 CellID->433581942]
}, Open  ]],
Cell[3744, 148, 99, 1, 70, "ExampleText",
 CellID->597968191],
Cell[CellGroupData[{
Cell[3868, 153, 274, 9, 70, "Input",
 CellTags->"Integrate::ilim",
 CellID->15545124],
Cell[4145, 164, 100, 3, 70, "Output",
 CellTags->"Integrate::ilim",
 CellID->15094134]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4284, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

