(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10639,        382]
NotebookOptionsPosition[      6351,        247]
NotebookOutlinePosition[      8668,        314]
CellTagsIndexPosition[      8538,        308]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["InterpolatingFunction::dprec", "ObjectName",
 CellID->24506],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dprec\"\>"}], ":", 
  " ", "\<\"The precision of input value `1` and/or the interpolation grid is \
insufficient to compute the value.\"\>"}]], "Message", "MSG",
 CellID->284160536],

Cell["\<\
Generated when the grid spacing is zero to within the  precision of the \
inputs.\
\>", "Notes",
 CellID->5109],

Cell[TextData[{
 "This message is generated  while computing a value for an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->20807],

Cell[TextData[{
 "This error can occur if the grid spacing  is smaller than the uncertainty \
in the arguments that are passed to the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->26414]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21332220],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->83191758],

Cell[TextData[{
 "An error occurs in this example because the uncertainty in the  \
machine-number argument that is passed to the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is larger than the width of the interval in which that number  \
falls."
}], "ExampleText",
 CellID->123729975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "+", 
          RowBox[{"10", "^", 
           RowBox[{"-", "25"}]}]}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "30"}], "]"}], 
   "]"}]}]], "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"In[1]:=",
 CellID->25734],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`30.", ",", "3.`30."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"Out[1]=",
 CellID->608259453]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", "1.0", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"In[2]:=",
 CellID->938],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dprec\"\>"}], ":", 
  " ", "\<\"The precision of input value \\!\\({1.`}\\) and/or the \
interpolation grid is insufficient to compute the value.\"\>"}]], "Message", \
"MSG",
 CellTags->"InterpolatingFunction::dprec",
 CellID->201550802],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.`30.", ",", "3.`30."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
    "]"}],
   False,
   Editable->False], "[", "1.`", "]"}]], "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"Out[2]=",
 CellID->340297809]
}, Open  ]],

Cell["\<\
The interpolation can be computed without difficulty if the argument is a \
high-precision number or if the argument is exact.\
\>", "ExampleText",
 CellID->75494844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"10", "^", 
     RowBox[{"-", "25"}]}], "/", "2"}]}], "]"}]], "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"In[3]:=",
 CellID->29834],

Cell[BoxData["1.5000000000000000621`4.875061263391702"], "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"Out[3]=",
 CellID->689305860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", "1.000000000000000000000000050000", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"In[4]:=",
 CellID->10940],

Cell[BoxData["1.5000000000000000621`4.574031267727721"], "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"Out[4]=",
 CellID->302346280]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["interp", "MR"],
 "."
}], "ExampleText",
 CellID->41879474],

Cell[BoxData[
 RowBox[{"Clear", "[", "interp", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellLabel->"In[5]:=",
 CellID->32567]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolatingFunction::dprec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 23.0418104}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "InterpolatingFunction::dprec", "synonyms" -> {}, "title" -> 
    "InterpolatingFunction::dprec", "type" -> "Message", "uri" -> 
    "ref/message/dprec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2284, 86, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21332220]},
 "InterpolatingFunction::dprec"->{
  Cell[3246, 121, 626, 21, 70, "Input",
   CellTags->"InterpolatingFunction::dprec",
   CellID->25734],
  Cell[3875, 144, 325, 12, 70, "Output",
   CellTags->"InterpolatingFunction::dprec",
   CellID->608259453],
  Cell[4237, 161, 141, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dprec",
   CellID->938],
  Cell[4381, 167, 307, 7, 70, "Message",
   CellTags->"InterpolatingFunction::dprec",
   CellID->201550802],
  Cell[4691, 176, 363, 13, 70, "Output",
   CellTags->"InterpolatingFunction::dprec",
   CellID->340297809],
  Cell[5270, 200, 236, 8, 70, "Input",
   CellTags->"InterpolatingFunction::dprec",
   CellID->29834],
  Cell[5509, 210, 152, 3, 70, "Output",
   CellTags->"InterpolatingFunction::dprec",
   CellID->689305860],
  Cell[5698, 218, 172, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dprec",
   CellID->10940],
  Cell[5873, 224, 152, 3, 70, "Output",
   CellTags->"InterpolatingFunction::dprec",
   CellID->302346280],
  Cell[6152, 237, 145, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dprec",
   CellID->32567]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7304, 270},
 {"InterpolatingFunction::dprec", 7457, 274}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 66, 1, 70, "ObjectName",
 CellID->24506],
Cell[CellGroupData[{
Cell[794, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1272, 49, 251, 5, 70, "Message",
 CellID->284160536],
Cell[1526, 56, 121, 4, 70, "Notes",
 CellID->5109],
Cell[1650, 62, 268, 8, 70, "Notes",
 CellID->20807],
Cell[1921, 72, 326, 9, 70, "Notes",
 CellID->26414]
}, Closed]],
Cell[CellGroupData[{
Cell[2284, 86, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21332220],
Cell[CellGroupData[{
Cell[2668, 100, 147, 5, 70, "ExampleSection",
 CellID->83191758],
Cell[2818, 107, 403, 10, 70, "ExampleText",
 CellID->123729975],
Cell[CellGroupData[{
Cell[3246, 121, 626, 21, 70, "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellID->25734],
Cell[3875, 144, 325, 12, 70, "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellID->608259453]
}, Open  ]],
Cell[CellGroupData[{
Cell[4237, 161, 141, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellID->938],
Cell[4381, 167, 307, 7, 70, "Message",
 CellTags->"InterpolatingFunction::dprec",
 CellID->201550802],
Cell[4691, 176, 363, 13, 70, "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellID->340297809]
}, Open  ]],
Cell[5069, 192, 176, 4, 70, "ExampleText",
 CellID->75494844],
Cell[CellGroupData[{
Cell[5270, 200, 236, 8, 70, "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellID->29834],
Cell[5509, 210, 152, 3, 70, "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellID->689305860]
}, Open  ]],
Cell[CellGroupData[{
Cell[5698, 218, 172, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellID->10940],
Cell[5873, 224, 152, 3, 70, "Output",
 CellTags->"InterpolatingFunction::dprec",
 CellID->302346280]
}, Open  ]],
Cell[6040, 230, 109, 5, 70, "ExampleText",
 CellID->41879474],
Cell[6152, 237, 145, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dprec",
 CellID->32567]
}, Open  ]]
}, Open  ]],
Cell[6324, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

