(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12151,        410]
NotebookOptionsPosition[      7334,        276]
NotebookOutlinePosition[     10456,        357]
CellTagsIndexPosition[     10292,        350]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Interpolation::indat
ListInterpolation::indat\
\>", "ObjectName",
 CellID->16306],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"indat\"\>"}], ":", 
  " ", "\<\"Data point `1` contains abscissa `2`, which is not a real number.\
\"\>"}]], "Message", "MSG",
 CellID->211182164],

Cell["\<\
Generated when the first element or one of the first elements in the \
indicated data point is not a real number.\
\>", "Notes",
 CellID->15105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->932954678],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12867653],

Cell["\<\
An error occurs in this example because the first element in each pair is not \
a number.\
\>", "ExampleText",
 CellID->193122453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x4", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"In[1]:=",
 CellID->3980],

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpolation", "::", "\<\"indat\"\>"}], ":", 
  " ", "\<\"Data point \\!\\({x1, 1}\\) contains abscissa \\!\\(x1\\), which \
is not a real number.\"\>"}]], "Message", "MSG",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->135991661],

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x4", ",", "4"}], "}"}]}], "}"}], "]"}]], "Output",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"Out[1]=",
 CellID->833334018]
}, Open  ]],

Cell[TextData[{
 "This shows valid input in ",
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->185142190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "y1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "y2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "y3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "y4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"In[2]:=",
 CellID->30166],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"Out[2]=",
 CellID->629973858]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolatingPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFormula"],
 " can be used for symbolic interpolation."
}], "ExampleText",
 CellID->491495974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolatingPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x4", ",", "4"}], "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"In[3]:=",
 CellID->11104],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "x1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "x1"}], "+", "x2"}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "x2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", 
            RowBox[{
             RowBox[{"-", "x1"}], "+", "x2"}]]}], "+", 
          FractionBox["1", 
           RowBox[{
            RowBox[{"-", "x2"}], "+", "x3"}]]}], 
         RowBox[{
          RowBox[{"-", "x1"}], "+", "x3"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "x3"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{
               RowBox[{"-", 
                FractionBox["1", 
                 RowBox[{
                  RowBox[{"-", "x1"}], "+", "x2"}]]}], "+", 
               FractionBox["1", 
                RowBox[{
                 RowBox[{"-", "x2"}], "+", "x3"}]]}], 
              RowBox[{
               RowBox[{"-", "x1"}], "+", "x3"}]]}], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"-", 
               FractionBox["1", 
                RowBox[{
                 RowBox[{"-", "x2"}], "+", "x3"}]]}], "+", 
              FractionBox["1", 
               RowBox[{
                RowBox[{"-", "x3"}], "+", "x4"}]]}], 
             RowBox[{
              RowBox[{"-", "x2"}], "+", "x4"}]]}], ")"}]}], 
         RowBox[{
          RowBox[{"-", "x1"}], "+", "x4"}]]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellLabel->"Out[3]=",
 CellID->102056127]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interpolation::indat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 31.2763962}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Interpolation::indat ListInterpolation::indat", 
    "synonyms" -> {}, "title" -> "Interpolation::indat", "type" -> "Message", 
    "uri" -> "ref/message/indat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1714, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->932954678]},
 "Interpolation::indat"->{
  Cell[2414, 98, 444, 14, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->3980],
  Cell[2861, 114, 294, 6, 70, "Message",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->135991661],
  Cell[3158, 122, 450, 14, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->833334018],
  Cell[3867, 151, 445, 14, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->30166],
  Cell[4315, 167, 333, 11, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->629973858],
  Cell[4935, 192, 488, 15, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->11104],
  Cell[5426, 209, 1842, 60, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->102056127]},
 "ListInterpolation::indat"->{
  Cell[2414, 98, 444, 14, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->3980],
  Cell[2861, 114, 294, 6, 70, "Message",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->135991661],
  Cell[3158, 122, 450, 14, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->833334018],
  Cell[3867, 151, 445, 14, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->30166],
  Cell[4315, 167, 333, 11, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->629973858],
  Cell[4935, 192, 488, 15, 70, "Input",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->11104],
  Cell[5426, 209, 1842, 60, 70, "Output",
   CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
   CellID->102056127]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8288, 299},
 {"Interpolation::indat", 8434, 303},
 {"ListInterpolation::indat", 9367, 325}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 4, 70, "ObjectName",
 CellID->16306],
Cell[CellGroupData[{
Cell[819, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 52, 223, 6, 70, "Message",
 CellID->211182164],
Cell[1523, 60, 154, 4, 70, "Notes",
 CellID->15105]
}, Closed]],
Cell[CellGroupData[{
Cell[1714, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->932954678],
Cell[CellGroupData[{
Cell[2099, 83, 147, 5, 70, "ExampleSection",
 CellID->12867653],
Cell[2249, 90, 140, 4, 70, "ExampleText",
 CellID->193122453],
Cell[CellGroupData[{
Cell[2414, 98, 444, 14, 70, "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->3980],
Cell[2861, 114, 294, 6, 70, "Message",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->135991661],
Cell[3158, 122, 450, 14, 70, "Output",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->833334018]
}, Open  ]],
Cell[3623, 139, 219, 8, 70, "ExampleText",
 CellID->185142190],
Cell[CellGroupData[{
Cell[3867, 151, 445, 14, 70, "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->30166],
Cell[4315, 167, 333, 11, 70, "Output",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->629973858]
}, Open  ]],
Cell[4663, 181, 247, 7, 70, "ExampleText",
 CellID->491495974],
Cell[CellGroupData[{
Cell[4935, 192, 488, 15, 70, "Input",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->11104],
Cell[5426, 209, 1842, 60, 70, "Output",
 CellTags->{"Interpolation::indat", "ListInterpolation::indat"},
 CellID->102056127]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7307, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

