(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17706,        619]
NotebookOptionsPosition[      8530,        335]
NotebookOutlinePosition[     15024,        527]
CellTagsIndexPosition[     14815,        519]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Interpolation::inhr
ListInterpolation::inhr
InterpolatingFunction::inhr\
\>", "ObjectName",
 CellID->19000],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"inhr\"\>"}], ":", 
  " ", "\<\"Requested order is too high; order has been reduced to \
`1`.\"\>"}]], "Message", "MSG",
 CellID->52183049],

Cell["\<\
Generated when there are not enough points in the data  to construct an \
interpolation of the requested order.\
\>", "Notes",
 CellID->3122],

Cell[TextData[{
 " Interpolation of order ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " requires ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["+1", "MR"],
 " data points."
}], "Notes",
 CellID->1874],

Cell[TextData[{
 "The order of interpolation is specified  using the ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->32216],

Cell[TextData[{
 "The default value of the ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " option is 3.  This interpolation order requires at least 4 points in each  \
dimension."
}], "Notes",
 CellID->27335]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->372158175],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->87129295],

Cell[TextData[{
 "A warning message is generated in this example because the number of data  \
points is not sufficient for the default interpolation of order ",
 StyleBox["3", "MR"],
 "."
}], "ExampleText",
 CellID->110063467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"In[1]:=",
 CellID->3966],

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpolation", "::", "\<\"inhr\"\>"}], ":", 
  " ", "\<\"Requested order is too high; order has been reduced to \
\\!\\({2}\\).\"\>"}]], "Message", "MSG",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->226659240],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"Out[1]=",
 CellID->205093653]
}, Open  ]],

Cell[TextData[{
 "Linear interpolation can be done by setting the value of the ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " option to ",
 StyleBox["1", "MR"],
 "."
}], "ExampleText",
 CellID->464235161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]], "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"In[2]:=",
 CellID->10014],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"Out[2]=",
 CellID->244344805]
}, Open  ]],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["ListInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListInterpolation"]], "InlineFormula"],
 " is interpreted as an array and is expected to have a sufficient number of  \
data points in all dimensions."
}], "ExampleText",
 CellID->38609762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListInterpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"In[3]:=",
 CellID->21615],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListInterpolation", "::", "\<\"inhr\"\>"}], ":", 
  " ", "\<\"Requested order is too high; order has been reduced to \\!\\({3, \
1}\\).\"\>"}]], "Message", "MSG",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->25815956],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"Out[3]=",
 CellID->810698]
}, Open  ]],

Cell[TextData[{
 "If the data are not an array, but rather a list of points in one dimension, \
 the interpolation can be done using ",
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->68532550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"In[4]:=",
 CellID->658291964],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellLabel->"Out[4]=",
 CellID->747250309]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interpolation::inhr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 38.4172040}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Interpolation::inhr ListInterpolation::inhr InterpolatingFunction::inhr",
     "synonyms" -> {}, "title" -> "Interpolation::inhr", "type" -> "Message", 
    "uri" -> "ref/message/inhr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2511, 103, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->372158175]},
 "Interpolation::inhr"->{
  Cell[3298, 134, 415, 14, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->3966],
  Cell[3716, 150, 311, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->226659240],
  Cell[4030, 160, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->205093653],
  Cell[4741, 190, 489, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->10014],
  Cell[5233, 208, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->244344805],
  Cell[6011, 237, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->21615],
  Cell[6495, 255, 317, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->25815956],
  Cell[6815, 265, 449, 16, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->810698],
  Cell[7611, 297, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->658291964],
  Cell[8095, 315, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->747250309]},
 "ListInterpolation::inhr"->{
  Cell[3298, 134, 415, 14, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->3966],
  Cell[3716, 150, 311, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->226659240],
  Cell[4030, 160, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->205093653],
  Cell[4741, 190, 489, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->10014],
  Cell[5233, 208, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->244344805],
  Cell[6011, 237, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->21615],
  Cell[6495, 255, 317, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->25815956],
  Cell[6815, 265, 449, 16, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->810698],
  Cell[7611, 297, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->658291964],
  Cell[8095, 315, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->747250309]},
 "InterpolatingFunction::inhr"->{
  Cell[3298, 134, 415, 14, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->3966],
  Cell[3716, 150, 311, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->226659240],
  Cell[4030, 160, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->205093653],
  Cell[4741, 190, 489, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->10014],
  Cell[5233, 208, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->244344805],
  Cell[6011, 237, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->21615],
  Cell[6495, 255, 317, 8, 70, "Message",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->25815956],
  Cell[6815, 265, 449, 16, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->810698],
  Cell[7611, 297, 481, 16, 70, "Input",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->658291964],
  Cell[8095, 315, 369, 13, 70, "Output",
   CellTags->{
    "Interpolation::inhr", "ListInterpolation::inhr", 
     "InterpolatingFunction::inhr"},
   CellID->747250309]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9512, 359},
 {"Interpolation::inhr", 9658, 363},
 {"ListInterpolation::inhr", 11378, 414},
 {"InterpolatingFunction::inhr", 13102, 465}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 117, 5, 70, "ObjectName",
 CellID->19000],
Cell[CellGroupData[{
Cell[845, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1323, 53, 215, 6, 70, "Message",
 CellID->52183049],
Cell[1541, 61, 151, 4, 70, "Notes",
 CellID->3122],
Cell[1695, 67, 217, 10, 70, "Notes",
 CellID->1874],
Cell[1915, 79, 251, 8, 70, "Notes",
 CellID->32216],
Cell[2169, 89, 305, 9, 70, "Notes",
 CellID->27335]
}, Closed]],
Cell[CellGroupData[{
Cell[2511, 103, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->372158175],
Cell[CellGroupData[{
Cell[2896, 117, 147, 5, 70, "ExampleSection",
 CellID->87129295],
Cell[3046, 124, 227, 6, 70, "ExampleText",
 CellID->110063467],
Cell[CellGroupData[{
Cell[3298, 134, 415, 14, 70, "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->3966],
Cell[3716, 150, 311, 8, 70, "Message",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->226659240],
Cell[4030, 160, 369, 13, 70, "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->205093653]
}, Open  ]],
Cell[4414, 176, 302, 10, 70, "ExampleText",
 CellID->464235161],
Cell[CellGroupData[{
Cell[4741, 190, 489, 16, 70, "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->10014],
Cell[5233, 208, 369, 13, 70, "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->244344805]
}, Open  ]],
Cell[5617, 224, 369, 9, 70, "ExampleText",
 CellID->38609762],
Cell[CellGroupData[{
Cell[6011, 237, 481, 16, 70, "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->21615],
Cell[6495, 255, 317, 8, 70, "Message",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->25815956],
Cell[6815, 265, 449, 16, 70, "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->810698]
}, Open  ]],
Cell[7279, 284, 307, 9, 70, "ExampleText",
 CellID->68532550],
Cell[CellGroupData[{
Cell[7611, 297, 481, 16, 70, "Input",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->658291964],
Cell[8095, 315, 369, 13, 70, "Output",
 CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
   "InterpolatingFunction::inhr"},
 CellID->747250309]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8503, 333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

