(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7534,        292]
NotebookOptionsPosition[      4505,        188]
NotebookOutlinePosition[      6199,        242]
CellTagsIndexPosition[      6087,        236]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Limit::lim", "ObjectName",
 CellID->4214],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"lim\"\>"}], ":", 
  " ", "\<\"Limit specification `1` is not of the form x -> x0.\"\>"}]], \
"Message", "MSG",
 CellID->533904589],

Cell[TextData[{
 "Generated when the second argument in Limit is not a  rule ",
 StyleBox["x", "TI"],
 StyleBox[" -> ", "MR"],
 StyleBox["x0", "TI"],
 " or when ",
 StyleBox["x", "TI"],
 " is not a valid variable."
}], "Notes",
 CellID->9682],

Cell["In most examples the  variable is a symbol.", "Notes",
 CellID->14366],

Cell["\<\
The variable can be an expression  other than a symbol, but it cannot be an \
expression that would interfere with  the meaning of the limit, such as a \
number, a sum, a product, a power, a  series expansion, or an inequality.\
\>", "Notes",
 CellID->4799]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->760569494],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->347451262],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " is expected to be a rule."
}], "ExampleText",
 CellID->34678866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"Limit::lim",
 CellLabel->"In[1]:=",
 CellID->7794],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"lim\"\>"}], ":", 
  " ", "\<\"Limit specification \\!\\(x\\) is not of the form x -> \
x0.\"\>"}]], "Message", "MSG",
 CellTags->"Limit::lim",
 CellID->208279139],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"lim\"\>"}], ":", 
  " ", "\<\"Limit specification \\!\\(0\\) is not of the form x -> \
x0.\"\>"}]], "Message", "MSG",
 CellTags->"Limit::lim",
 CellID->724558033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Log", "[", "x", "]"}]}], ",", "0"}], "]"}]}], "}"}]], "Output",\

 CellTags->"Limit::lim",
 CellLabel->"Out[1]=",
 CellID->112340285]
}, Open  ]],

Cell[TextData[{
 "This calculates the limit as ",
 StyleBox["x", "MR"],
 " approaches ",
 StyleBox["0", "MR"],
 "."
}], "ExampleText",
 CellID->174344838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellTags->"Limit::lim",
 CellLabel->"In[2]:=",
 CellID->7046],

Cell[BoxData["0"], "Output",
 CellTags->"Limit::lim",
 CellLabel->"Out[2]=",
 CellID->43181549]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Limit::lim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 10, 18.2619740}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Limit::lim", "synonyms" -> {}, "title" -> "Limit::lim", 
    "type" -> "Message", "uri" -> "ref/message/lim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2068, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->760569494]},
 "Limit::lim"->{
  Cell[2853, 113, 249, 9, 70, "Input",
   CellTags->"Limit::lim",
   CellID->7794],
  Cell[3105, 124, 216, 6, 70, "Message",
   CellTags->"Limit::lim",
   CellID->208279139],
  Cell[3324, 132, 216, 6, 70, "Message",
   CellTags->"Limit::lim",
   CellID->724558033],
  Cell[3543, 140, 379, 14, 70, "Output",
   CellTags->"Limit::lim",
   CellID->112340285],
  Cell[4116, 168, 225, 8, 70, "Input",
   CellTags->"Limit::lim",
   CellID->7046],
  Cell[4344, 178, 95, 3, 70, "Output",
   CellTags->"Limit::lim",
   CellID->43181549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5398, 210},
 {"Limit::lim", 5534, 214}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 47, 1, 70, "ObjectName",
 CellID->4214],
Cell[CellGroupData[{
Cell[775, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1253, 49, 184, 5, 70, "Message",
 CellID->533904589],
Cell[1440, 56, 242, 9, 70, "Notes",
 CellID->9682],
Cell[1685, 67, 76, 1, 70, "Notes",
 CellID->14366],
Cell[1764, 70, 267, 5, 70, "Notes",
 CellID->4799]
}, Closed]],
Cell[CellGroupData[{
Cell[2068, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->760569494],
Cell[CellGroupData[{
Cell[2453, 94, 148, 5, 70, "ExampleSection",
 CellID->347451262],
Cell[2604, 101, 224, 8, 70, "ExampleText",
 CellID->34678866],
Cell[CellGroupData[{
Cell[2853, 113, 249, 9, 70, "Input",
 CellTags->"Limit::lim",
 CellID->7794],
Cell[3105, 124, 216, 6, 70, "Message",
 CellTags->"Limit::lim",
 CellID->208279139],
Cell[3324, 132, 216, 6, 70, "Message",
 CellTags->"Limit::lim",
 CellID->724558033],
Cell[3543, 140, 379, 14, 70, "Output",
 CellTags->"Limit::lim",
 CellID->112340285]
}, Open  ]],
Cell[3937, 157, 154, 7, 70, "ExampleText",
 CellID->174344838],
Cell[CellGroupData[{
Cell[4116, 168, 225, 8, 70, "Input",
 CellTags->"Limit::lim",
 CellID->7046],
Cell[4344, 178, 95, 3, 70, "Output",
 CellTags->"Limit::lim",
 CellID->43181549]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4478, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

