(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9764,        331]
NotebookOptionsPosition[      5835,        217]
NotebookOutlinePosition[      8379,        286]
CellTagsIndexPosition[      8220,        279]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
ListConvolve::depth
ListCorrelate::depth\
\>", "ObjectName",
 CellID->14841],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"depth\"\>"}], ":", 
  " ", "\<\"The dimension `1` of the overhang parameters exceeds the \
rectangular rank of the kernel, `2`.\"\>"}]], "Message", "MSG",
 CellID->473834784],

Cell[TextData[{
 "Generated when the dimension of the third argument in  ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " is not the same as the rank of the first argument."
}], "Notes",
 CellID->25735],

Cell[TextData[{
 " The first argument in ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " is the kernel of the convolution or correlation, and the third argument  \
gives the overhang parameters."
}], "Notes",
 CellID->23859]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->232433835],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->528473946],

Cell["\<\
An error occurs in this example because the third argument gives overhang \
parameters for two dimensions, while the first argument has only one \
dimension.\
\>", "ExampleText",
 CellID->63129506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d1", ",", "d2", ",", "d3", ",", "d4", ",", "d5", ",", "d6"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "]"}]], "Input",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellLabel->"In[1]:=",
 CellID->20694],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "::", "\<\"depth\"\>"}], ":", 
  " ", "\<\"The dimension \\!\\(2\\) of the overhang parameters exceeds the \
rectangular rank of the kernel, \\!\\(1\\).\"\>"}]], "Message", "MSG",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->812949113],

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d1", ",", "d2", ",", "d3", ",", "d4", ",", "d5", ",", "d6"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}], "]"}]], "Output",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellLabel->"Out[1]=",
 CellID->484213981]
}, Open  ]],

Cell[TextData[{
 "This shows a valid specification of overhang parameters in ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->81468873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d1", ",", "d2", ",", "d3", ",", "d4", ",", "d5", ",", "d6"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellLabel->"In[2]:=",
 CellID->12191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"d3", " ", "k1"}], "+", 
    RowBox[{"d2", " ", "k2"}], "+", 
    RowBox[{"d1", " ", "k3"}]}], ",", 
   RowBox[{
    RowBox[{"d4", " ", "k1"}], "+", 
    RowBox[{"d3", " ", "k2"}], "+", 
    RowBox[{"d2", " ", "k3"}]}], ",", 
   RowBox[{
    RowBox[{"d5", " ", "k1"}], "+", 
    RowBox[{"d4", " ", "k2"}], "+", 
    RowBox[{"d3", " ", "k3"}]}], ",", 
   RowBox[{
    RowBox[{"d6", " ", "k1"}], "+", 
    RowBox[{"d5", " ", "k2"}], "+", 
    RowBox[{"d4", " ", "k3"}]}]}], "}"}]], "Output",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellLabel->"Out[2]=",
 CellID->891012864]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListConvolve::depth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 10, 58.8098870}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ListConvolve::depth ListCorrelate::depth", "synonyms" -> {},
     "title" -> "ListConvolve::depth", "type" -> "Message", "uri" -> 
    "ref/message/depth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2457, 94, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->232433835]},
 "ListConvolve::depth"->{
  Cell[3225, 124, 434, 13, 70, "Input",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->20694],
  Cell[3662, 139, 309, 6, 70, "Message",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->812949113],
  Cell[3974, 147, 439, 13, 70, "Output",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->484213981],
  Cell[4702, 175, 408, 12, 70, "Input",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->12191],
  Cell[5113, 189, 656, 21, 70, "Output",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->891012864]},
 "ListCorrelate::depth"->{
  Cell[3225, 124, 434, 13, 70, "Input",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->20694],
  Cell[3662, 139, 309, 6, 70, "Message",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->812949113],
  Cell[3974, 147, 439, 13, 70, "Output",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->484213981],
  Cell[4702, 175, 408, 12, 70, "Input",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->12191],
  Cell[5113, 189, 656, 21, 70, "Output",
   CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
   CellID->891012864]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6783, 240},
 {"ListConvolve::depth", 6928, 244},
 {"ListCorrelate::depth", 7576, 260}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 86, 4, 70, "ObjectName",
 CellID->14841],
Cell[CellGroupData[{
Cell[814, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1292, 52, 251, 6, 70, "Message",
 CellID->473834784],
Cell[1546, 60, 424, 13, 70, "Notes",
 CellID->25735],
Cell[1973, 75, 447, 14, 70, "Notes",
 CellID->23859]
}, Closed]],
Cell[CellGroupData[{
Cell[2457, 94, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->232433835],
Cell[CellGroupData[{
Cell[2842, 108, 148, 5, 70, "ExampleSection",
 CellID->528473946],
Cell[2993, 115, 207, 5, 70, "ExampleText",
 CellID->63129506],
Cell[CellGroupData[{
Cell[3225, 124, 434, 13, 70, "Input",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->20694],
Cell[3662, 139, 309, 6, 70, "Message",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->812949113],
Cell[3974, 147, 439, 13, 70, "Output",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->484213981]
}, Open  ]],
Cell[4428, 163, 249, 8, 70, "ExampleText",
 CellID->81468873],
Cell[CellGroupData[{
Cell[4702, 175, 408, 12, 70, "Input",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->12191],
Cell[5113, 189, 656, 21, 70, "Output",
 CellTags->{"ListConvolve::depth", "ListCorrelate::depth"},
 CellID->891012864]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5808, 215, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

