(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40870,        898]
NotebookOptionsPosition[      6124,        215]
NotebookOutlinePosition[     37884,        826]
CellTagsIndexPosition[     37329,        808]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
LogicalExpand::eqf
MainSolve::eqf
Roots::eqf
ToRules::eqf
Solve::eqf
Reduce::eqf
Eliminate::eqf
SolveAlways::eqf
AlgebraicRules::eqf
GroebnerBasis::eqf
PolynomialReduce::eqf
GroebnerBasis`DistributedTermsList::eqf
System`Private`OldReduce::eqf\
\>", "ObjectName",
 CellID->23567],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"eqf\"\>"}], ":", 
  " ", "\<\"`1` is not a well-formed equation.\"\>"}]], "Message", "MSG",
 CellID->92282289],

Cell["\<\
Generated when the indicated expression is expected to  be an equation.\
\>", "Notes",
 CellID->24511],

Cell[TextData[{
 "An equation is an expression of the  form ",
 StyleBox["lhs", "TI"],
 StyleBox["==", "MR"],
 StyleBox["rhs", "TI"],
 " or ",
 StyleBox["Equal[", "MR"],
 StyleBox["lhs", "TI"],
 StyleBox[",", "MR"],
 StyleBox["rhs", "TI"],
 StyleBox["]", "MR"],
 "."
}], "Notes",
 CellID->1182]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->601933675],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->21310729],

Cell["A polynomial is not by itself an equation.", "ExampleText",
 CellID->172352742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"5", "x"}], "+", "6"}], ",", "x"}], "]"}]], "Input",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellLabel->"In[1]:=",
 CellID->567349737],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], ":", 
  " ", "\<\"\\!\\(6 - \\(\\(5\\\\ x\\)\\) + x\\^2\\) is not a well-formed \
equation.\"\>"}]], "Message", "MSG",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->715353392],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"eqf\"\>"}], ":", 
  " ", "\<\"\\!\\(6 - \\(\\(5\\\\ x\\)\\) + x\\^2\\) is not a well-formed \
equation.\"\>"}]], "Message", "MSG",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->525660233],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"6", "-", 
    RowBox[{"5", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", "x"}], "]"}]], "Output",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellLabel->"Out[1]=",
 CellID->409964017]
}, Open  ]],

Cell["\<\
An equation can be entered by setting this polynomial equal to zero.\
\>", "ExampleText",
 CellID->250548170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"5", "x"}], "+", "6"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellLabel->"In[2]:=",
 CellID->22980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellLabel->"Out[2]=",
 CellID->18800006]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogicalExpand::eqf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 14.2790330}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "LogicalExpand::eqf MainSolve::eqf Roots::eqf ToRules::eqf Solve::eqf \
Reduce::eqf Eliminate::eqf SolveAlways::eqf AlgebraicRules::eqf \
GroebnerBasis::eqf PolynomialReduce::eqf \
GroebnerBasis`DistributedTermsList::eqf System`Private`OldReduce::eqf", 
    "synonyms" -> {}, "title" -> "LogicalExpand::eqf", "type" -> "Message", 
    "uri" -> "ref/message/eqf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2131, 93, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->601933675]},
 "LogicalExpand::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "MainSolve::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "Roots::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "ToRules::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "Solve::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "Reduce::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "Eliminate::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "SolveAlways::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "AlgebraicRules::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "GroebnerBasis::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "PolynomialReduce::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "Internal`DistributedTermsList::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]},
 "System`Private`OldReduce::eqf"->{
  Cell[2776, 119, 509, 12, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->567349737],
  Cell[3288, 133, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->715353392],
  Cell[3801, 145, 510, 10, 70, "Message",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->525660233],
  Cell[4314, 157, 516, 12, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->409964017],
  Cell[4989, 179, 535, 14, 70, "Input",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->22980],
  Cell[5527, 195, 531, 13, 70, "Output",
   CellTags->{
    "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
     "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
     "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
     "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
   CellID->18800006]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7282, 242},
 {"LogicalExpand::eqf", 7426, 246},
 {"MainSolve::eqf", 9723, 289},
 {"Roots::eqf", 12016, 332},
 {"ToRules::eqf", 14311, 375},
 {"Solve::eqf", 16604, 418},
 {"Reduce::eqf", 18898, 461},
 {"Eliminate::eqf", 21195, 504},
 {"SolveAlways::eqf", 23494, 547},
 {"AlgebraicRules::eqf", 25796, 590},
 {"GroebnerBasis::eqf", 28097, 633},
 {"PolynomialReduce::eqf", 30401, 676},
 {"Internal`DistributedTermsList::eqf", 32718, 719},
 {"System`Private`OldReduce::eqf", 35030, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 289, 15, 70, "ObjectName",
 CellID->23567],
Cell[CellGroupData[{
Cell[1017, 46, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1495, 63, 187, 5, 70, "Message",
 CellID->92282289],
Cell[1685, 70, 112, 3, 70, "Notes",
 CellID->24511],
Cell[1800, 75, 294, 13, 70, "Notes",
 CellID->1182]
}, Closed]],
Cell[CellGroupData[{
Cell[2131, 93, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->601933675],
Cell[CellGroupData[{
Cell[2516, 107, 147, 5, 70, "ExampleSection",
 CellID->21310729],
Cell[2666, 114, 85, 1, 70, "ExampleText",
 CellID->172352742],
Cell[CellGroupData[{
Cell[2776, 119, 509, 12, 70, "Input",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->567349737],
Cell[3288, 133, 510, 10, 70, "Message",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->715353392],
Cell[3801, 145, 510, 10, 70, "Message",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->525660233],
Cell[4314, 157, 516, 12, 70, "Output",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->409964017]
}, Open  ]],
Cell[4845, 172, 119, 3, 70, "ExampleText",
 CellID->250548170],
Cell[CellGroupData[{
Cell[4989, 179, 535, 14, 70, "Input",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->22980],
Cell[5527, 195, 531, 13, 70, "Output",
 CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
   "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
   "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
   "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"},
 CellID->18800006]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6097, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

