(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6766,        253]
NotebookOptionsPosition[      3930,        159]
NotebookOutlinePosition[      5590,        210]
CellTagsIndexPosition[      5473,        204]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Maximize::wksol", "ObjectName",
 CellID->25020],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no maximum in the region described by the \
constraints; returning a result on the boundary.\"\>"}]], "Message", "MSG",
 CellID->97366841],

Cell[TextData[{
 "Generated when one or more inequality constraints in  ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " is satisfied as an equality."
}], "Notes",
 CellID->27116]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300847427],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->664140306],

Cell["\<\
A warning message is generated in this example because the maximum occurs \
when the constraint is satisfied as an equality.\
\>", "ExampleText",
 CellID->1038566020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "<", "1"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Maximize::wksol",
 CellLabel->"In[1]:=",
 CellID->13159],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no maximum in the region described by the \
constraints; returning a result on the boundary.\"\>"}]], "Message", "MSG",
 CellTags->"Maximize::wksol",
 CellID->122914201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"Maximize::wksol",
 CellLabel->"Out[1]=",
 CellID->160253583]
}, Open  ]],

Cell[TextData[{
 "This warning can be avoided by replacing ",
 Cell[BoxData[
  RowBox[{"x", "<", "1"}]]],
 " with ",
 Cell[BoxData[
  RowBox[{"x", "\[LessEqual]", "1"}]]],
 "."
}], "ExampleText",
 CellID->6262640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "\[LessEqual]", "1"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Maximize::wksol",
 CellLabel->"In[2]:=",
 CellID->581595861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"Maximize::wksol",
 CellLabel->"Out[2]=",
 CellID->17577492]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maximize::wksol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 30.8732078}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Maximize::wksol", "synonyms" -> {}, "title" -> 
    "Maximize::wksol", "type" -> "Message", "uri" -> "ref/message/wksol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1799, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->300847427]},
 "Maximize::wksol"->{
  Cell[2536, 98, 187, 6, 70, "Input",
   CellTags->"Maximize::wksol",
   CellID->13159],
  Cell[2726, 106, 276, 6, 70, "Message",
   CellTags->"Maximize::wksol",
   CellID->122914201],
  Cell[3005, 114, 201, 7, 70, "Output",
   CellTags->"Maximize::wksol",
   CellID->160253583],
  Cell[3459, 137, 202, 6, 70, "Input",
   CellTags->"Maximize::wksol",
   CellID->581595861],
  Cell[3664, 145, 200, 7, 70, "Output",
   CellTags->"Maximize::wksol",
   CellID->17577492]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4840, 181},
 {"Maximize::wksol", 4981, 185}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->25020],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 245, 5, 70, "Message",
 CellID->97366841],
Cell[1507, 56, 255, 8, 70, "Notes",
 CellID->27116]
}, Closed]],
Cell[CellGroupData[{
Cell[1799, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300847427],
Cell[CellGroupData[{
Cell[2184, 83, 148, 5, 70, "ExampleSection",
 CellID->664140306],
Cell[2335, 90, 176, 4, 70, "ExampleText",
 CellID->1038566020],
Cell[CellGroupData[{
Cell[2536, 98, 187, 6, 70, "Input",
 CellTags->"Maximize::wksol",
 CellID->13159],
Cell[2726, 106, 276, 6, 70, "Message",
 CellTags->"Maximize::wksol",
 CellID->122914201],
Cell[3005, 114, 201, 7, 70, "Output",
 CellTags->"Maximize::wksol",
 CellID->160253583]
}, Open  ]],
Cell[3221, 124, 213, 9, 70, "ExampleText",
 CellID->6262640],
Cell[CellGroupData[{
Cell[3459, 137, 202, 6, 70, "Input",
 CellTags->"Maximize::wksol",
 CellID->581595861],
Cell[3664, 145, 200, 7, 70, "Output",
 CellTags->"Maximize::wksol",
 CellID->17577492]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3903, 157, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

