(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6747,        253]
NotebookOptionsPosition[      3927,        159]
NotebookOutlinePosition[      5580,        210]
CellTagsIndexPosition[      5463,        204]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Minimize::wksol", "ObjectName",
 CellID->7727],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary.\"\>"}]], "Message", "MSG",
 CellID->242112934],

Cell[TextData[{
 "Generated when one or more inequality constraints in  ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " is satisfied as an equality."
}], "Notes",
 CellID->409]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151622614],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->71908814],

Cell["\<\
A warning message is generated in this example because the minimum occurs \
when the constraint is satisfied as an equality.\
\>", "ExampleText",
 CellID->270728136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", ">", "1"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Minimize::wksol",
 CellLabel->"In[1]:=",
 CellID->7132],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary.\"\>"}]], "Message", "MSG",
 CellTags->"Minimize::wksol",
 CellID->47733291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"Minimize::wksol",
 CellLabel->"Out[1]=",
 CellID->383351089]
}, Open  ]],

Cell[TextData[{
 "This warning can be avoided by replacing ",
 Cell[BoxData[
  RowBox[{"x", ">", "1"}]]],
 " with ",
 Cell[BoxData[
  RowBox[{"x", "\[GreaterEqual]", "1"}]]],
 "."
}], "ExampleText",
 CellID->950613692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "\[GreaterEqual]", "1"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Minimize::wksol",
 CellLabel->"In[2]:=",
 CellID->12334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"Minimize::wksol",
 CellLabel->"Out[2]=",
 CellID->7745067]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Minimize::wksol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 38.8265364}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Minimize::wksol", "synonyms" -> {}, "title" -> 
    "Minimize::wksol", "type" -> "Message", "uri" -> "ref/message/wksol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1797, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->151622614]},
 "Minimize::wksol"->{
  Cell[2532, 98, 186, 6, 70, "Input",
   CellTags->"Minimize::wksol",
   CellID->7132],
  Cell[2721, 106, 275, 6, 70, "Message",
   CellTags->"Minimize::wksol",
   CellID->47733291],
  Cell[2999, 114, 201, 7, 70, "Output",
   CellTags->"Minimize::wksol",
   CellID->383351089],
  Cell[3458, 137, 201, 6, 70, "Input",
   CellTags->"Minimize::wksol",
   CellID->12334],
  Cell[3662, 145, 199, 7, 70, "Output",
   CellTags->"Minimize::wksol",
   CellID->7745067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4837, 181},
 {"Minimize::wksol", 4978, 185}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->7727],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 246, 5, 70, "Message",
 CellID->242112934],
Cell[1507, 56, 253, 8, 70, "Notes",
 CellID->409]
}, Closed]],
Cell[CellGroupData[{
Cell[1797, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151622614],
Cell[CellGroupData[{
Cell[2182, 83, 147, 5, 70, "ExampleSection",
 CellID->71908814],
Cell[2332, 90, 175, 4, 70, "ExampleText",
 CellID->270728136],
Cell[CellGroupData[{
Cell[2532, 98, 186, 6, 70, "Input",
 CellTags->"Minimize::wksol",
 CellID->7132],
Cell[2721, 106, 275, 6, 70, "Message",
 CellTags->"Minimize::wksol",
 CellID->47733291],
Cell[2999, 114, 201, 7, 70, "Output",
 CellTags->"Minimize::wksol",
 CellID->383351089]
}, Open  ]],
Cell[3215, 124, 218, 9, 70, "ExampleText",
 CellID->950613692],
Cell[CellGroupData[{
Cell[3458, 137, 201, 6, 70, "Input",
 CellTags->"Minimize::wksol",
 CellID->12334],
Cell[3662, 145, 199, 7, 70, "Output",
 CellTags->"Minimize::wksol",
 CellID->7745067]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3900, 157, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

