(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8809,        316]
NotebookOptionsPosition[      5987,        222]
NotebookOutlinePosition[      7637,        273]
CellTagsIndexPosition[      7521,        267]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bcart", "ObjectName",
 CellID->10806],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcart\"\>"}], ":", 
  " ", "\<\"Warning: An insufficient number of boundary conditions have been \
specified for the direction of independent variable `1`. Artificial boundary \
effects may be present in the solution.\"\>"}]], "Message", "MSG",
 CellID->183609411],

Cell["\<\
Generated when the boundary conditions in a partial differential equation are \
not sufficient to uniquely specify the solution.\
\>", "Notes",
 CellID->29906]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378335238],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->24940113],

Cell["\<\
A warning message is generated in this example because no condition is given \
for one of the boundaries.\
\>", "ExampleText",
 CellID->158850567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}], "==", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcart",
 CellLabel->"In[1]:=",
 CellID->8722],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcart\"\>"}], ":", 
  " ", "\<\"Warning: An insufficient number of boundary conditions have been \
specified for the direction of independent variable \\!\\(x\\). Artificial \
boundary effects may be present in the solution.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bcart",
 CellID->122021773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bcart",
 CellLabel->"Out[1]=",
 CellID->195840394]
}, Open  ]],

Cell["\<\
This shows one way to specify a unique solution in this example.\
\>", "ExampleText",
 CellID->392266666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}], "==", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcart",
 CellLabel->"In[2]:=",
 CellID->26001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bcart",
 CellLabel->"Out[2]=",
 CellID->161696816]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bcart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 54.2800570}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bcart", "synonyms" -> {}, "title" -> 
    "NDSolve::bcart", "type" -> "Message", "uri" -> "ref/message/bcart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1787, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->378335238]},
 "NDSolve::bcart"->{
  Cell[2503, 95, 897, 29, 70, "Input",
   CellTags->"NDSolve::bcart",
   CellID->8722],
  Cell[3403, 126, 356, 7, 70, "Message",
   CellTags->"NDSolve::bcart",
   CellID->122021773],
  Cell[3762, 135, 503, 18, 70, "Output",
   CellTags->"NDSolve::bcart",
   CellID->195840394],
  Cell[4420, 163, 995, 32, 70, "Input",
   CellTags->"NDSolve::bcart",
   CellID->26001],
  Cell[5418, 197, 503, 18, 70, "Output",
   CellTags->"NDSolve::bcart",
   CellID->161696816]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6894, 244},
 {"NDSolve::bcart", 7034, 248}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->10806],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 320, 6, 70, "Message",
 CellID->183609411],
Cell[1581, 57, 169, 4, 70, "Notes",
 CellID->29906]
}, Closed]],
Cell[CellGroupData[{
Cell[1787, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->378335238],
Cell[CellGroupData[{
Cell[2172, 80, 147, 5, 70, "ExampleSection",
 CellID->24940113],
Cell[2322, 87, 156, 4, 70, "ExampleText",
 CellID->158850567],
Cell[CellGroupData[{
Cell[2503, 95, 897, 29, 70, "Input",
 CellTags->"NDSolve::bcart",
 CellID->8722],
Cell[3403, 126, 356, 7, 70, "Message",
 CellTags->"NDSolve::bcart",
 CellID->122021773],
Cell[3762, 135, 503, 18, 70, "Output",
 CellTags->"NDSolve::bcart",
 CellID->195840394]
}, Open  ]],
Cell[4280, 156, 115, 3, 70, "ExampleText",
 CellID->392266666],
Cell[CellGroupData[{
Cell[4420, 163, 995, 32, 70, "Input",
 CellTags->"NDSolve::bcart",
 CellID->26001],
Cell[5418, 197, 503, 18, 70, "Output",
 CellTags->"NDSolve::bcart",
 CellID->161696816]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5960, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

