(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10134,        363]
NotebookOptionsPosition[      7311,        269]
NotebookOutlinePosition[      8963,        320]
CellTagsIndexPosition[      8847,        314]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bcuns", "ObjectName",
 CellID->1770],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcuns\"\>"}], ":", 
  " ", "\<\"Boundary condition `1` cannot be satisfied in general.\"\>"}]], \
"Message", "MSG",
 CellID->419195735],

Cell["\<\
Generated when the equations for the boundary conditions cannot be solved.\
\>", "Notes",
 CellID->436]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7694480],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->303095200],

Cell["\<\
An error is generated in this example because one of the boundary conditions \
does not have a solution.\
\>", "ExampleText",
 CellID->688114733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", 
      RowBox[{"1", "+", 
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"2", ",", "t"}], "]"}], "==", "2"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "x"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcuns",
 CellLabel->"In[1]:=",
 CellID->20491],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcuns\"\>"}], ":", 
  " ", "\<\"Boundary condition \\!\\(\\(\\(f[\\(\\(1, t\\)\\)]\\)\\) \[Equal] \
\\(\\(1 + \\(\\(f[\\(\\(1, t\\)\\)]\\)\\)\\)\\)\\) cannot be satisfied in \
general.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bcuns",
 CellID->293210190],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"1", "+", 
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"2", ",", "t"}], "]"}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", "x"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::bcuns",
 CellLabel->"Out[1]=",
 CellID->354656937]
}, Open  ]],

Cell["\<\
This shows a valid specification of a solution of this partial differential \
equation.\
\>", "ExampleText",
 CellID->30785606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"2", ",", "t"}], "]"}], "==", "2"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "x"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcuns",
 CellLabel->"In[2]:=",
 CellID->25206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bcuns",
 CellLabel->"Out[2]=",
 CellID->113737525]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bcuns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 55.4363366}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bcuns", "synonyms" -> {}, "title" -> 
    "NDSolve::bcuns", "type" -> "Message", "uri" -> "ref/message/bcuns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1601, 64, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7694480]},
 "NDSolve::bcuns"->{
  Cell[2315, 93, 1270, 40, 70, "Input",
   CellTags->"NDSolve::bcuns",
   CellID->20491],
  Cell[3588, 135, 316, 7, 70, "Message",
   CellTags->"NDSolve::bcuns",
   CellID->293210190],
  Cell[3907, 144, 1474, 50, 70, "Output",
   CellTags->"NDSolve::bcuns",
   CellID->354656937],
  Cell[5558, 205, 1181, 37, 70, "Input",
   CellTags->"NDSolve::bcuns",
   CellID->25206],
  Cell[6742, 244, 503, 18, 70, "Output",
   CellTags->"NDSolve::bcuns",
   CellID->113737525]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8218, 291},
 {"NDSolve::bcuns", 8356, 295}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->1770],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 191, 5, 70, "Message",
 CellID->419195735],
Cell[1451, 56, 113, 3, 70, "Notes",
 CellID->436]
}, Closed]],
Cell[CellGroupData[{
Cell[1601, 64, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7694480],
Cell[CellGroupData[{
Cell[1984, 78, 148, 5, 70, "ExampleSection",
 CellID->303095200],
Cell[2135, 85, 155, 4, 70, "ExampleText",
 CellID->688114733],
Cell[CellGroupData[{
Cell[2315, 93, 1270, 40, 70, "Input",
 CellTags->"NDSolve::bcuns",
 CellID->20491],
Cell[3588, 135, 316, 7, 70, "Message",
 CellTags->"NDSolve::bcuns",
 CellID->293210190],
Cell[3907, 144, 1474, 50, 70, "Output",
 CellTags->"NDSolve::bcuns",
 CellID->354656937]
}, Open  ]],
Cell[5396, 197, 137, 4, 70, "ExampleText",
 CellID->30785606],
Cell[CellGroupData[{
Cell[5558, 205, 1181, 37, 70, "Input",
 CellTags->"NDSolve::bcuns",
 CellID->25206],
Cell[6742, 244, 503, 18, 70, "Output",
 CellTags->"NDSolve::bcuns",
 CellID->113737525]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7284, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

