(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8837,        312]
NotebookOptionsPosition[      6424,        232]
NotebookOutlinePosition[      7881,        277]
CellTagsIndexPosition[      7766,        271]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bddo", "ObjectName",
 CellID->32269],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bddo\"\>"}], ":", 
  " ", "\<\"Value of option DifferenceOrder -> `1` should be a positive \
integer or \\\"Pseudospectral\\\".\"\>"}]], "Message", "MSG",
 CellID->105786966],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["DifferenceOrder"], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " does not have the expected form."
}], "Notes",
 CellID->18552],

Cell[TextData[{
 Cell[BoxData["DifferenceOrder"], "InlineFormula"],
 " is an option used within methods available to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", rather than an option to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " itself."
}], "Notes",
 CellID->8462]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125379965],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->53434581],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is not a valid value for the ",
 Cell[BoxData["DifferenceOrder"], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->45057903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"DifferenceOrder", "\[Rule]", "None"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::bddo",
 CellLabel->"In[1]:=",
 CellID->13583],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bddo\"\>"}], ":", 
  " ", "\<\"Value of option DifferenceOrder -> \\!\\(None\\) should be a \
positive integer or \\\"Pseudospectral\\\".\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bddo",
 CellID->3928243],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\<\"TensorProductGrid\"\>", ",", 
         RowBox[{"DifferenceOrder", "\[Rule]", "None"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Output",
 CellTags->"NDSolve::bddo",
 CellLabel->"Out[1]=",
 CellID->48618089]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bddo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 55.5769652}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bddo", "synonyms" -> {}, "title" -> 
    "NDSolve::bddo", "type" -> "Message", "uri" -> "ref/message/bddo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2258, 87, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->125379965]},
 "NDSolve::bddo"->{
  Cell[3126, 122, 1410, 43, 70, "Input",
   CellTags->"NDSolve::bddo",
   CellID->13583],
  Cell[4539, 167, 266, 6, 70, "Message",
   CellTags->"NDSolve::bddo",
   CellID->3928243],
  Cell[4808, 175, 1550, 50, 70, "Output",
   CellTags->"NDSolve::bddo",
   CellID->48618089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7327, 254},
 {"NDSolve::bddo", 7466, 258}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->32269],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 230, 5, 70, "Message",
 CellID->105786966],
Cell[1490, 56, 303, 10, 70, "Notes",
 CellID->18552],
Cell[1796, 68, 425, 14, 70, "Notes",
 CellID->8462]
}, Closed]],
Cell[CellGroupData[{
Cell[2258, 87, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125379965],
Cell[CellGroupData[{
Cell[2643, 101, 147, 5, 70, "ExampleSection",
 CellID->53434581],
Cell[2793, 108, 308, 10, 70, "ExampleText",
 CellID->45057903],
Cell[CellGroupData[{
Cell[3126, 122, 1410, 43, 70, "Input",
 CellTags->"NDSolve::bddo",
 CellID->13583],
Cell[4539, 167, 266, 6, 70, "Message",
 CellTags->"NDSolve::bddo",
 CellID->3928243],
Cell[4808, 175, 1550, 50, 70, "Output",
 CellTags->"NDSolve::bddo",
 CellID->48618089]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6397, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

