(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    127994,       2312]
NotebookOptionsPosition[    124459,       2194]
NotebookOutlinePosition[    126396,       2254]
CellTagsIndexPosition[    126274,       2248]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bdord", "ObjectName",
 CellID->17576],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bdord\"\>"}], ":", 
  " ", "\<\"Boundary condition `1` should have derivatives of order lower \
than the differential order of the partial differential equation.\"\>"}]], \
"Message", "MSG",
 CellID->110252621],

Cell["\<\
Generated when the number of times that a function is differentiated with \
respect to a particular variable is greater in a boundary condition than in \
the differential equation.\
\>", "Notes",
 CellID->9395]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->338333373],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->37098099],

Cell["\<\
An error occurs in this example because the derivative boundary condition is \
specified with respect to the wrong variable.\
\>", "ExampleText",
 CellID->524474159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"5", ",", "t"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bdord",
 CellLabel->"In[1]:=",
 CellID->18066],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bdord\"\>"}], ":", 
  " ", "\<\"Boundary condition \\!\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
TagBox[\\((0, 1)\\), Derivative], Rule[MultilineFunction, \
None]]\\)\\)[\\(\\(5, t\\)\\)]\\) should have derivatives of order lower than \
the differential order of the partial differential equation.\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::bdord",
 CellID->60053472],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"5", ",", "t"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::bdord",
 CellLabel->"Out[1]=",
 CellID->56852080]
}, Open  ]],

Cell["\<\
This shows a valid specification of a solution of this partial differential \
equation.\
\>", "ExampleText",
 CellID->52908370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", 
       RowBox[{"Sin", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"5", ",", "t"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"4", " ", "Pi"}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::bdord",
 CellLabel->"In[2]:=",
 CellID->7972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "5.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "12.566370614359172`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bdord",
 CellLabel->"Out[2]=",
 CellID->186437358]
}, Open  ]],

Cell["This shows a plot of the solution.", "ExampleText",
 CellID->530030494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bdord",
 CellLabel->"In[3]:=",
 CellID->6905],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJytnXlcT9v3/1ORBpWSlEgTMmSeCmcLDYQkQ2QmU4SSIWOazFOGiJIKKZrn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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1m3ccV9Mbx+++RYSIshq0SxKljJamdlqiYUdD2SOZmckmszSMIiOyZfsh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         "]], Polygon3DBox[CompressedData["
1:eJwtmnf819MXx9/zfotSpERGKUWDBlraAyWlUmSlgawk2TJ+tmRlj6JsiaxI
iqyy90pCioQ0NPF7Pb3uH/fxua/3ve/35z3uPed1XufUGza6/+lZkiQVeZIU
+t1Rv6+p01MH+wu3VX9XtXrqb58myVPqX6T2s3ADzTlM85sIbxa+S+PtmavW
QriW8Bnq76b2ifo3qLVTv65ac43XFK5a6lpB/63rtNaxizV2Mv+hselqZ2r8
8Ar9avxVjV+uscZqG9XfW+NP5L6fx9TvqGNjNL+y5g/X8aeFl+vaVXSsh/pP
6Vgd9X/TsWrq99SxXPgn4fV6lkbCo4RLnf+4rvmo8EnChXAv4UeEdxC+XPMP
0vyuwv/oeEfhR/T/ewsfqf7Fal00vlbHftP8o3R+O/3fBRrvrrEhwm2F52t8
mM5vo1ZJ84/hfWl+JY0P0/hTmv+2jr+lNkBjHdSe1PEqap00tkLtfo1NUdtJ
Y3XUlun8VvqPCepvp/FU/V/VZuWeM12/W+d+V78kfn9bqXVI/E1rau51wl/p
mj01f6r6/6jfXu154W10/V80p9TxNonfLe84F94/8XN11/M0Sf18hcaXaXyD
zt9T4zsJrxTeJvc3+VW//dQ6a/wNzW+kc8ep3cGzqu2i+X9o/raac5Dm/yR8
pN7P15q/rTCL9iTuRXNbqx3N/asN0Ph64RrqD9X8fTQvFx6nueerP0X9t3T6
zrre75pTXccPFO6v36Ya36L+PZrTX+OdNT5D/dt17DyNnas2OfU1Rqo/Qu0a
je0j/Ivmt9b8G1Ov8Ubqj9D/L9L91BA+SuN9hIfof6YKDxE+RPhI4QeEr9L8
g4UX6Jp9dc4RPL/GBqtNYX0J99b4EcL3gzVvb9a/+ofpP49jbWr8IR0rdP4h
mt9NuLfm36Q59+n43WqPq79B83fTeBuN19P4kTr2isbuVXsx8Rr+Rq21cPXU
a+pozT9U84/S/Gma01e4p/ChwpOE+wkfKNxX+FbhPsLdhQ8Rvln4UPaicB/h
W4T/zWwPWIsTUzak7Qdrm3d4pvpj1G5S/2ber/q1df4SnVdTc67T9WoIn6/z
3hf+U/iA4G93p/Agzf9K7T7Nv1etW+7vNVzj49VWqL+jzv9BY7U0/1qdv53w
eZr3nvAq7Jfw7xrfWXilcB3hZcK1hU/V/AHCp2r+bOEJwtsLXyD8Ac8kXEv4
IuGPEq/n/YV345sK78p6Ea4rfITw4cK9hAcK3yt8vXBN4QuFP2S96P+/VntF
/z+HPaVnHanxNLfNbSZ8ovAA4bvY05q7g/Bizd2e96Pf4wvbmrFqnXT99hpv
r/kXa7yNfrtpvJHGDmL9q3+YWnf1e6g11Py2mr+H5h2v+XsIz1e/gdpQvpnm
dlHbQ3N/VvtW9zOqwuuI9YN9v6Tw3j5d89/Vec1YC9gutV6af3KF/Q7+ph/7
Wf2Jaj8JD8W3qP3AXkp9vL7aysTj3XQ/HXV+J13zfzrWVbiDcEfhy1jTrA/h
DsKXCncW/kr9A9QuEe6t/7u6sN/CX/0v+q/lGttWuKfmd9H5XTX/Sh27QmOj
1a7T2CK17hrvpPHOGr9c4z2wH8JdhK8QbiX8nvrN1c7AZui3oc5fq/6t+BDh
PYTXCE/CP2j+5tz+DH8wXLifrjci+rfe+C/1e6ndKFxfv2ML75VjhUdo/DDN
H6njM4VHCvcXPkH4GeFjhfsKHyf8BD5ez3+88Hjhj4Xf07XeVXspsU3FL7QU
rkjtH/BfrKe6Gt9O+GBdr6vOP0jnT2Q9CrcTbip8kvBZ0b/z7W9L/e27CjdM
vQb4vsepwUmC8FrWMTZJ/Yc5J/caZu0OxF7o+nvp+vM0p5Xgktx7nL09WG15
af9cQ/2fNH6+8GDNP0dzFgpfwL2ofaH+1NTfche1fTJ/01TzH8OGCu/B+brW
mTr/5NzvZFThZ+JZ9tecpho/W22/zPvh+2h/+mh8so6tLM0B8I3na/wU9c9S
a6Wx1cLPa+5zavtmvsbSuN/7a/5c4Wfi/S2Fi2Te3zfrmmPS/15FMpH/1/3d
zJ5IfZ/Yc3wh9wvXgfPgqx/U2DjhMZpfW/3DsDfC44Tn65wDdf339Xst+03n
Hy7cQeN3qL2s/my1FupfoNZW/QXRn9+u+as0/47Evh8OALd7iHeGb4HzZD7n
nMLfd43mb8IfwLM0f5xwfeE/4J+6n5WaW0d4cXy+D3R8vPD4wvvnNLhMXA+P
qv2rfoO439nfLdTOFK4hvELX+KQwB1qDb9Cx5tE+wh8H6vpjNH+e8FjhQcJj
4cX4A527p44NV/8NHZur89fFtcEaOV3j56m1Vr9IzZ1mFObKcKgbNXZOhfcV
+wm+caf6q1Pb65NL88eumX063Ohp+FRmjnRa4TXLWm2Xef7YCvtt/DW84cC4
9+APnbBjhW3rH9gr1luF7TX2+0mNjVJ/lvp1NX+VrncCfEv9DTqWxvGavJ/M
/J/n2Scx595d/cPVDmGvxPX5ROFYgj30s643TNerrP4yHWuifgMdO079C3XO
COHR2GdsiPAo4TPgC4X57nT8l/6/L9xR12iu8dPU6mXmKMQOxBBw+afxkZHf
/KVzj8y8vvFR7EX2VLPCnAmuFDLfz8lqddTvpzkLNfcU/f8kzfktNY/qqete
n5hPvZj7fqqqX0Xt3Pi966v/tuYMVv90nX8295Havt9U2BeyRmcW/p7sDWza
QM0/VfP35J517BH9Plr43u6G0zGutiv2KDF3hkMPVH927liGmOZw4Zex/dGe
7JL5Hb+pa72hdrBwr8xcF847SGNzNP9a4RuC3xX2/6t4P7fpnIuEp+n3wcLf
tqXw7/gPYgrd+4WJ7fPRavel3sOD+D46/0D8NP5TuHbpWJKYcnJhvvqP8EaN
XwqPFd6s/uc69gC+MPPeZQ9PEe6r1i31HGIBOBTc6RU4U+F4g9iqHza/MH/B
tvYVXkpsVzi2u4cYUteelzlWIGZgL16jOf0z78mGkc8QB3PPcE/WJmsPDrog
c0zG2uyYmp//G+x/4dc3qb9Cx/5Uv4HGBxT2l8QqvVLzd/h878iHiWd75P62
X2r8RI3nuqdPC/u7W3S9SfBZ1oPaKbn9MfcL3yT+6KlWPTOnxT7frvZQ4m/y
l+Yfmzt23RLXHzYXW4tN4TvthY1P/L0G6///IQaJfIJ1TLzNvbGeB6q/f+HY
srfwVpp7XIWfgXi8e+7rYTuapo5N8Xv4P+LPD/ApaqPUz9QeVf+RzHu/nlrj
4HfIu7tA7SONfZh5bie1L3XtJWofZ8ac+7DaoamvcZ7uf2uNn53bH10qfETk
M/Dv5pFfwB3L1LEsMS2x30x4aOG1/0fq/U/cXCt3bM3936z5q0vHkl3VKgl/
n/u5ed5LiB8K8334+izi5sy2t77GC80/FvtbeI2wNlmjS2M8sU7nHZP726Op
1NLYZ7l5OXyctQsPgA+whg8qrL8Q67QUPqV0/Dswc4xHPHWNxr9LHR/sxdrE
BuS2Gd+of7TuZ5Xm75LYt+Hj6uS2MfC3dcHxCfFhY+HV7MHcNmR1Zn0I215N
/7FR47fnPl4t7v8JwdyhG2tO42uwZzH+aSq8NjgeIv6pJXyRcAfN7yI8Q79P
Zl4Lq+I48cDLagfo+GbhY3T/azLzc77fHPZsZvv1XbA9x4ZPEG6v+VuC+ego
4bbCm4QbC58o3A6+Ldwk8lX4P9fePbGG1UbjGzW+l8ZP0LHWwhvgBMIj2f+l
450rC8cD6CdXqf9tap8Jz5og/GNqvnVwYb0B398K/qnzK3T+8Zo3Q8e219jF
6nfGvxIzaTxofKiOPanx6sH6FA6X9XBSsH6F38Zfj4GvqrWIzzAUkqjxw3X+
5MTxRVZhfeF+fGSMT4jvhgnvJ/yXzm+Ym/PsL7xeuJHwCOHjhVOdPyi3PkE8
8ndwPEV8tS97CTuDrUitRxCvdIjx2PAY36BnoH9clpuPX8Nex9/Ad3X9FbrG
TnE/s7/OjHzsV2xzhffPDon1r3VqlVNzZPSitaVjiR8T6zEtg7k9nBk9Bz0I
W45NR1tAY9CUZGJubQCNgFd8Q24tA02D2HJ57v/mHioJ35hb+0ADITZckVsb
QSMh9vsFLgeHyryWd08dm8Ph+SzX5+an/Dm2BpvJXmPPsbbe0nhLzX9G+GDh
7YSnFubM9aPvbKDxqcRE+NfMsREXx5/CVZsIP1Fau0PDay78NDGJcFXhfYSf
IkYWrizcGC1UeD/hLDc37BmsdcERm2p8OpoAt40PEJ6BpiBcSbiZ8JPEgIk1
5j2Epwk3Ft6UWa+pEux70HTRqlgjrI1lubUxNDK0oj9za1/4UHznqtxrgzWy
Nb5SuDLvLpgLNEuttaG5oU2tzh27E8Ofg20Q3ln4N52/lfDNubUwNLFewq/m
1mZ2je97Xm7tBv6BFjk3d2yLjcQ2vpNbu0HDgX+vzK2VoZmhha3JHYsTk08V
/js3vzuoNJdaofvdoP4OwVxhm9RaE5pTZWyL5r+l/pUa7wMPKRxrE3Oj3fyY
W/9pH+yrL0mtXaFhVdX4rbm1A/Yce21Lbi0OTe5y4Z9zx1rEXFWEJwlX6Fo7
BnMpNF20AjQDtKn1Gl+q/nLWf2pNhnfJO/1Z97cj/kT9hzWnGc+bOV6ATxLg
o9lgq9DciT+wWdWEPwz23fhwbBsa/AuJbdy2wh9r/B3Bc3NzJTgT/hBtDFv0
RrBtwyZhS98OtpXY1OrCHwXH/mgA2NK3hKcntqnYwjeDbRk2sa7w5Lh/4KXs
99tK+2psDs96R2nbxDOj/X0WrEWiAaLdfR6sBaLhoQV+EcwN4Ahol58Ga41o
mNifSaW1SDROtMhPNP5uYk0Se3RraVuHZsn6v7N0bIyNJPexMEStKH7Pu8qo
XWZeT7eX/jZomKyPu0v7fjTORsIPCTdlfWTWstHD4BDosVU1/r6OzdX4Gbm1
rTejvUPjQkt8tbSW1j7uj9mlfS0+F23sjWgP0cj2FX5OuDe+Lrd293pcj2h4
aHWvRXuAz2ghPDPuP3ICrYSfjfu1hvDuwvcLNxT+K7P2Nz/aazRAtMuXSvs2
fNx+ws8LDxDeKe7vF0pzETjJVsLvoHcInya8tfC7wnOETxeuQiwv/Irw6Ny5
mwXBvpscDrHB/GAuTYxAfgP9k9wW8V49zZ9SWj9AR0A/JV5EC4QfboPWEaxF
jIn2aFa0N3Cy+sIPlM6tkGPBfr0oPCSxps/zNozx1+vxe6FJni28OLfedwP2
LbXGSzyIpk1sQYyB/Q7RXj8a7XuFcBPhx+CI6n9SOjYmRsZ/VIrr5/Hc3AEO
gfbyfm7uBIcaJ/xRbi4GJztX+NPc3KtdtM+f5OZmbeP9fpyba8G5zhL+MO5f
OBHfIy/sz7YS3ld4Rtz/cCq+T1F4f8N52B+bctsLOAzfa2Oe/Ofo4UjYiw1x
/6MRoQ3dmTs2IkbCvvwWvy8xIPbi99zfc23h3MRdufcjmhLfLxTmTnCoscIf
5NYzzi2tHVyV2nd8Wlq7wYewnsgJst/KwnxudeFcEpoVeg6aMloyMT5cHX8E
d10Y98O6wvbkbuGGwpsK24spuff75sL24f64nohJsG/3Yr90rUN0zSWpNRj4
xYbC9uO+3HyiiOvv4bgfq0d//1zcr9tEvvFM3E8XlrZnVQvzgY2F7efkyDfS
uB+mxf2JftBN+KXc+Y79g7V5NEL4Rxn5ziO58xnzSmufvBP02JbCoxPnlAeo
/3Fp30g8AFeFs7I/l+b2pe/wzJl9KnovMSX+CM2S/N7fpXMTyxPHLsQwJ6q/
ILfW1TVYC0fzgq9Vi/zo2dz+cEthe/tAbv30ytJcF86Lf7pa+GvhWoVznXBY
uOuE3PaAGBP/sW3h2IcYiPzcHbnzJ9wfucfFqbUI4unH0RPVLtU5W0rHI8Ql
f6l/T2luvnVq/XJN6dwomhaxKjErsXn9aO/Gl/Zv1Qr7g4tL+7fqwu2I9dT+
TF0PgP8jh/WdxusU9n/kxJYI71zY9x8RnCuHA2D/u8X9vSi3/e4a98s30R90
ifbk6+hPukd78m30P53ifvgyt17VKVgbXsceIrZkvabOOcAtTgyOleAYzYV/
La3Fk8MiV0LOZJrwP7n1+wPUTkmcoyG/31Ht1MQ5nP9ygaW1tKywFoMmg1b+
UuZcNDlp4g1y0dQGcA3O/SKPWnPp3EzlwrmK86M9rlLEWojSuZxKRdSqS+eC
KiI/ukb4G+EdCmsfxEzESjUK1x6Qf+DeP8/NL8h5LhKuXTgfwfOTO0JD3Fe4
S3Du/3q1/dCGgtfWxBi/3FLa3pFjHB2sD/Ku9xRuq36P4Nz+nalzS/gcfE0/
/d/lpdcbWjkaH9oKGss7OndhZn97UWl+tE1hfZF4Ab2DNbZJY7WDtSj2wGXE
AsH5B/IQ8CtyxN9q/o7CZwRrrvjexpm1KzQsYoUfcvPPqzT/K43XLMznyOku
hh8Ujh/eEr4qcQ4Qe/pg9IebM8cv75WOT9D40HYeC+Zr8EXyL48H85P1UY+d
GaxfU4NAfQY1MtTGUONBvQc1NdTSdE5c94D+RmyApkh+5YlgfRP/j541Izjf
QnyHlvNsML9B06FWY3pwPEfNBvEGmg1aTd3E+uozwXoY/Ir3i31BW6mXWF9u
UTrfRc4Kfz032P6hmWAPZwVrO/An/NGLwXyqbuQDLwXzLzQFtKAXgrUkNCHi
3eeDtSk0Jvzl7GDtAc0B7eq5YG1q58gf5gX7u6aRX8wJjpf3ivzhlWCtBo2H
vYueRs6RPQyfeDlYy0DDQU9/Org2hRoh9NdpandlrpFBf38qOF6mhoX8BnuC
vfCC2si43tcn1mTJp2ATsYVvsv7jfvopcc3P1GDNE31reub8M/4NrQ7Njtim
WrC2Q4xzU5z/RGab/kfpPcbeokYFbQMNCu0JjQP9HH39gdSaJbYevW+/wjaf
fAj5hjKzJk++lD3PXqemiW99TnBuk29OvuXJ4PwhNVtoS+TP6ifWmMitoWGg
XVB78VhhDgF3IHdCLdL2wocm1lbHCy8oHfui2bE/55bO7aHBUh9A/gqthO9F
vPuuxm9InGO+Qv0Lg3Nh5MSoFyH/jb9CDyYfQzyMvkaO7ctgn4Yvw8ahDVHv
RE0BGhG5tKOC86Xk1C4Nzv/CJ7tn5pZwTLQSOAncBo7DXmHPwP3ggOtiDgPf
DwdAqyFmub5wPrUr9iA1V4IzEbugMaBrog+Si0LfhLvB4Yhl4ET4XnwwsQac
cNvSMRSxEzEQXAnORCwD5yePSz0fWiP5XHJ11EugrR4S9Wo4BbHFq4l9OT6d
2G5eYl+CTyHWhrPBheHExMJ8877B9XBcG02Tb8s3PqCw/eoTrOfyLHBIbCs2
ltieGBzfhl5PXgMfh63H5hNbwdm53vDgXBtrBm4ERyJ2/08DKJwrJHdJTRbc
Eo5JrEZMQKxCzIIWBSeF68J5iW2x2XBhbDi2mxiH/CwaOtr5kMy5MfJD9MmR
kTuFc8O1Xy+ciybnPjhzTpr6s2OCc1to8OTTqRnkew/KrIVfFtxHE+f9HKr2
fWrNm/dJzQu1LNQYUmsAB4V7ziqcb2TNs9bJMZO7J8dJbvPZqA2RwyR3gUZ0
dXA8gV7TL7O9RYPHHr6dm4vCSdFmiNmI3Yjh0P7Q8IgFiAnwLfiYjZGzo93B
uTdEzRGtkRiA+sch+P/UOWy4PJwe7ZA9BFeHs6MVEhNgz8lJYH/fzB1rEnOi
FcKZv9Q1Ps+sfXdJHWsQc+Db8HGXBGucaJvk3+HzrwbrD2jQbbD/pbkINYXs
FfYMz/Z8bn3wy8jvqMlD6xquY8cU1rz4tsQTxAJ8Y7RF8j3kHdEY+XbER/hm
viF67LEh+U/fIneKXvl5ab0NjZvcMDYJW3RH4XcF/6XWlHcGn7+3tFZP3oFc
LHwFW0heivwm90ZtCzVap0b7SSxDjhi++q3ws4lrfND7vol8kZoh4h/qAx8u
nF8mfqfecKHwPYn5MTknck3nJeZzvD9yKeR80S8XRX5KTRG5enL21AdQS0C+
86jCtTnUCMHF0IvxfXAy3g31GdTq8I6IRYiX8J3EJEOD9YT/7iWz3vh1aX2O
GqUB0T/A3X5Prbd+Jnxf4po5fBs+btfEOS347sul88PUppJP6VM4d/hpYr6+
uLS+Qw0f74J3gpZBLcUXat+pzczsg+DzD8NpMudY4e9zSuu37SJ//154fuKa
Efj6ksi/yVnA178rbWuxuXyLAfH7UWtA/uAj+FXiGsqvg2MGYgViMvSJ14Of
lxwO/9mjMH/lGdG/4bPkYsnpEj/eWDpfC3ckHvixdG0XOVHiix9K21JsKnov
OU1ymdS0kj8mR0VuijWK/vFasP8lR0y+khwkuUdyzOjJH5TW26nxJP/xYWn9
mxpR9PCvhB9MXEOKfkzNMbVk1RPbux+CazuoXaK2kXogag+ocSS3Br9B/6Cm
kFpB4pFliWsGiQXIP5KnJiaglgl7S+0BvhC+RD1v89QcbXZh/oD+Qm0S+jrx
P9oLdTTY+x+D60eomSH/837pfAQ1rcQzi4Jzy7xPbAc2hHdHLRr5iy9K6/3U
+MIvqNmhtueewrnJhXG9kaN8oTDfonaDWjDidTgjXJE6cez998H8gFwitRbE
2+TbyeVT+4m+wd6mBpTnoz4LbYHaIa5PfRpaCLVr5BqGVXjPknMgHnq7dD0C
OX1ql6kvQ/+ihhk+hz/Gt1OHzrlco27i2jxqeajpoT6G2h3s3ZLg3A61BMRn
cGS4MXUL/wd7MaQx
         "]], Polygon3DBox[CompressedData["
1:eJwt1ne8z1Ucx/Hfva5xcVGiskoPldWUVaKsNKyUHtGgMno8ikLSkrKllBUS
ZWuahVyyMiOjsmeL7BaiR8+P+/3j/fid9+v7Puf7/Z3vOefzLftY53s7padS
qaGUm/7OSKU+ypNKjc2VSv3jwlVYL/41qs8vcf1rKiD8KTZDrhDVlyvCF6ap
2g9jd8k9IbeDzvIP0kTXHuW30z/8fTQOa8fvpHN8K5oUY/Db6A++KY3EWvM/
0gm+MQ3HHuK30km+CY3A0vmPPctkPhdVxdpju+g/vjVNxnbInPCchbRv8luV
Wsn8QMdl7qFhrtWRy4578z1lPkkzLv8JPgXLoGpyaXyKavspgNWS7Sq3l/Jp
t8Nmu7ZV5nrsSuPcjpeja/mvaK1M2ZgHucb8t/QLX5t6Y035DfQbfxv1xZrw
6+lXvg71wZrx39FB/nbqh5XgZ7r3Qr5UzD/Wke9A07QfwT72LAXlPsNm8oWp
gWtPY7sp3fVHsU+xS/kZcl/xJakF1hL7ng7zjWgIdhu/JN4Tfz09i3Xh91De
WCfYLKw5v5EO8XWpP3YXv44O8LdQL+wlfj8V1PcpbCF2B78yxuSrUw+sv2cb
QM2s3bWya6ibzD7K1G4vN0duk3Z3rIX3sUJ2J5/Ff67vLJki1FCuIfZNzEO8
b3oeq88vj/XL30TPYeXiHvrOMc7cmC+sAbYi1mCsR+qO1eWXxn7gb6SuWD1+
Wewbvgp1w0YZK1dea8JY2Z5vIZWSmY0vkilDLeU6YauwDLlOWDY2ONYzVhIb
iO2OvR5rl6byp41VIdak640pzRxswTZTm3hmfU/LtaXP5KrGOsU2JM/cBftR
vzp0THuOfrMpb6whmi7zL18ptkacGzQNO4NVxK7m5xhvBXYVPYa1jXnGzoSn
z7Fq2ELsu2ReYq6qY9nYxmTuY66OeY7R+DD+oHsUxHbLtKCj/tsI14cmZ9jM
eMdy6ckZcQafhI3nD+lbEjuKjcKGYr9iBbBz2FRsAnYcK4P9i03GPsAOx/vB
zmJTsA+xo1hp7Dg2BhuO/Y5lpXLOoPewEdiR9Jzz6Aj2LvYO9jOWHyvPz/U/
vsGupsexw3Ij8bf5A3KZWBn+S1qMXUh3YpmxV+Nc5M/JXYNNMNZQqmtenqR1
6Tl7+gtaIJeVnO2X8/NjD/MX0d3Je1sQa58vkez9B2LtxjzHeqTx2GXYPPqa
Lxp1ITkjlsod4e9PakBJbFacs3zp4FiFeBZsJV+ensAqxXjYar4itccOmoNh
+Jv8rvTzR3DqEDYcewvbE+sR+x0bgQ3B9mH5sIoxVzqswipQu6gF8d+w9fwN
yXl1vqbQJP7vpDZWjnmRW4NVog5YvlhT9BF/Vq4yNlzmELV0//exsXRae6Lc
OLnf+BJyb8TZKVfCtQHxX7BT2hPw9/lf4v1EDZVpQ7n5abEWM3LO55VxTkQ7
OROj1i7HTvFtkjO7M7Y6+sp1xhZhz2BrsDzYM9hibBdfhX7S7ov3o55RZ7Ai
2i/JrXft1ahH2AXYy9gG7OU4s7FC2AvYOuyVqGXxjYC9iH2bnONrsSysB7YW
2xj7CJsY+8+aLB51IOoCVty1Pvw2uYHYZuySeDZsBzYA24RdjPXFtmODsC3Y
pVh/bCfWL2ojVgzrjW3F3oz6jpXCBsWawWrxe2lUnCk01vPcGLUIW86viDmU
+yv2Hw2OswnLlMuIdx7rwP+YTmWxHlG38Hky82mVvo3izA4edTbmEKsdZ12c
29iVUeOwbfrViGcxznNYeaohswjblNSUqD2FYx9FbeDzUE2sZpwFcpuTuhW1
p0hk4uzl89LN2AXh44zh80W9Tb4JP8Te4/f7HxfH/8U+wMZge7Hi2IXRL/Yr
lkm1sJtj37vvlqQmP5/U8yWxruJcypXzfbCH7xnfTcbKjn1Lr8c8U9H4hpJb
Jrddpg9Wzxw0xa+jt6L2Ro3Xbk575U7GPsNHxX21i8b3pEzr+Lblx9PptJy6
eiuN035IdktGzl4dFlyf/Njm6M+fjD3i+VZT7bScb4Zp+DK+Bt9R9s8YW250
1Fm8WLKer8CayEzGdvD/A6mNhsc=
         "]]}]}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1VVtLVGEUPeebMyMYBRrRRF7SLtBLvWhQ2pMPBdVLoBhN5t0pJ6NQZ5Si
nFGhOwQJ3etF6AdkmDpBpOioPamgj0GP+hOa1nIvHxbfPvvss7+9176citbb
l3uc53njQAg4FPG8N8AvyPfw4j4wB3kfXn4DLkFe9D2vL+x5E5A/w/Y1MAC7
duh7fPs2jucmfdsEXQK4CvkwbM8BcTy/xfkFeAG7LuC5M/0H6PLw343n7gDv
QnYXvzuib1PAAWA/8AB2CWexZfC8AZySTSH0F6GfhlwRNpuj8FECXIfuE849
QD/sPuJ8BZCQSX0bxfkbyAG1wBBQDVQBa4jtCk4POBgxv/S5BjQA1/CqErH/
BGKQe3EW4ptZyKW+8bIJeQFnI5AX/8eADjw34/5HznwuAfNADbAamP8t2H/H
WS8/xc7yZ3zrQFpyL/RjzmIe1L2sRRK6lDNu+S39f2XMuP8E0InnDuifOouH
NWftT/vG5y7oS3BOSWY89EFfvLcrsL4h5w3ipVx1WVX9aL87Yrn3Q17xjfOM
asiYl2VHm4yzuCfUh3udxZP0jQvycB7+xtmXzurG+s0qtmVx2C45L/2Scmfd
/4XND30vqr7kckH2teoHT1zk5L8J+V4ITBfDeTYwfnY4Yg9kfbuD/lnnCtV6
CHfdcdYzaXFSrX5bVx2Tio38ZFXHMnE/pXsy4p+51MFHOdAinnKKd8TZbO/M
ZlbxlCvOLeXCXm3UHDBmzhHvmpYNbX8oL+bLPq9XfjOyXxbXNdJnFfOI9NwV
ZyST2x7J1CWUY6numVL/kKe74mpDOTPfaslVmqdh+SkFB8eBZsijvs0sc8+J
F9axDO9Phi2XGcXKOKlrC0zPs1KzzBrFCxBjYL2cUr5RydxL5GJA8XP3TKtG
rG1a+XK35bXfOgusxpwb+qYN9x93y1jEZvY9zlDEeOCcFkUsx8fIo8VZju+g
K45Yn3LfZsLWn+xl7mrm2wfbYe0E7oY+ydwtf4A0np32JONn7NyNrDv33l9g
1FmPx9Xnz/Dc6WxvxHC+VI2K1OeM8yZ0D53xE1J/MhfOTUKzU6w9X6v6D6oW
rKNTPNv7KbC7yBm5Yxw3nN1B/9wnUdWCnM9rjtrVf+xJ9lGb4mSPsMbkkP+9
uGaE/5Zb+r9w/pKal3rVdlP6Sd3HeUlJZozc++SffcecdvqtTrO5ohyi6s1R
2bXCzxNnNg3qffLPeGOKuVE9vr0bw3Yf7/oPqLvf+g==
         "],
         VertexColors->None], 
        Polygon3DBox[{{1567, 1603, 447, 287}, {1685, 1695, 607, 238}, {1245, 
         951, 374, 657}, {1246, 1023, 385, 660}, {962, 802, 377, 341}, {621, 
         663, 444, 77}, {1128, 1085, 442, 375}, {1692, 1583, 661, 656}, {871, 
         1131, 386, 473}, {1583, 1691, 655, 661}, {632, 664, 459, 182}, {951, 
         1245, 639, 77}, {1123, 1251, 650, 352}, {345, 1238, 646, 648}, {1705,
          1691, 198, 606}, {1123, 1327, 603, 1251}, {789, 1127, 375, 468}, {
         1572, 1607, 462, 316}, {648, 645, 198, 345}, {1689, 1697, 612, 
         256}, {1253, 1238, 256, 612}, {1023, 1246, 643, 182}, {1685, 444, 
         663, 622}, {1132, 1099, 457, 386}, {640, 657, 374, 279}, {647, 641, 
         93, 342}, {1126, 1254, 653, 358}, {1689, 459, 664, 633}, {1608, 1693,
          287, 470}, {1693, 1608, 665, 659}, {1607, 1571, 197, 462}, {1554, 
         1692, 656, 635}, {1583, 1692, 316, 390}, {1250, 1237, 238, 607}, {
         1577, 1565, 285, 377}, {1564, 1573, 364, 285}, {1313, 1894, 1127, 
         77}, {951, 789, 468, 374}, {1582, 1570, 314, 388}, {644, 660, 385, 
         308}, {1085, 1116, 341, 442}, {1573, 1563, 91, 364}, {1603, 1566, 92,
          447}, {1034, 884, 388, 344}, {1574, 1568, 196, 366}, {1099, 1118, 
         344, 457}, {962, 1116, 284, 92}, {1569, 1574, 366, 314}, {1896, 1397,
          313, 1132}, {1539, 1693, 659, 624}, {1126, 1582, 388, 884}, {1034, 
         1118, 313, 197}, {1691, 1583, 390, 198}, {1123, 1577, 377, 802}, {
         342, 1237, 642, 647}, {1126, 1411, 605, 1254}, {1397, 1896, 1131, 
         182}, {1023, 871, 473, 385}, {1894, 1313, 284, 1128}},
         VertexColors->None], 
        Polygon3DBox[{{1538, 1565, 352, 609, 623}, {1690, 1568, 357, 652, 
         727}, {1550, 1696, 628, 308, 310}, {1411, 1571, 360, 654, 605}, {
         1327, 1566, 353, 651, 603}, {1702, 1608, 470, 93, 658}, {1569, 1553, 
         634, 613, 357}, {1564, 1538, 623, 608, 351}, {1553, 1570, 358, 614, 
         634}, {1567, 1539, 624, 610, 353}, {1686, 1563, 351, 649, 695}, {
         1535, 1694, 617, 279, 281}, {1572, 1554, 635, 615, 360}},
         VertexColors->None]}]}, {}, {}}, {{
      Line3DBox[{368, 1, 362, 264, 1255, 16, 519, 269, 466, 31, 363, 275, 
       1278, 46, 425, 61, 666, 1700, 667, 668, 669, 670, 1249, 671, 672, 673, 
       674, 675, 1701, 676, 1243, 677, 678, 679, 680, 681, 682, 683, 684, 
       1699, 685, 686, 687, 688, 689, 690, 1247, 691, 692, 693, 694, 696, 627,
        291, 106, 296, 1341, 121, 527, 298, 471, 136, 365, 304, 1362, 151, 
       432, 166, 697, 1703, 698, 699, 700, 701, 702, 1252, 703, 704, 705, 706,
        707, 1704, 708, 1244, 709, 710, 711, 712, 713, 714, 715, 1698, 716, 
       717, 718, 719, 720, 721, 722, 1248, 723, 724, 725, 726, 728, 638, 321, 
       392, 211, 367, 320, 895, 212, 417, 896, 213, 418, 897, 214, 420, 215, 
       898, 216, 899, 217, 900, 218, 901, 219, 902, 220, 903, 221, 904, 222, 
       905, 223, 906, 224, 1106, 325, 475, 225, 464, 329, 1423, 210, 1410, 
       195, 1396, 180, 1382, 165, 1373, 150, 1361, 135, 1351, 120, 1339, 105, 
       1326, 90, 1312, 75, 1298, 60, 1289, 45, 1277, 30, 1526, 267, 465, 15, 
       463, 327, 751, 14, 749, 13, 747, 12, 745, 11, 743, 10, 741, 9, 739, 8, 
       737, 7, 735, 6, 733, 5, 536, 4, 1196, 535, 3, 1148, 421, 2, 1072, 261, 
       368}], Line3DBox[{469, 76, 445, 286, 378, 91, 1686, 695, 649, 608, 623,
        609, 650, 1251, 603, 651, 610, 624, 659, 665, 1702, 658, 604, 611, 
       626, 625, 641, 647, 642, 1250, 607, 1695, 622, 663, 621, 620, 639, 
       1245, 657, 640, 618, 617, 1694, 619, 1535, 281, 469}], 
      Line3DBox[{474, 181, 460, 315, 389, 196, 1690, 727, 652, 613, 634, 614, 
       653, 1254, 605, 654, 615, 635, 656, 661, 655, 1705, 606, 616, 637, 636,
        645, 648, 646, 1253, 612, 1697, 633, 664, 632, 631, 643, 1246, 660, 
       644, 629, 662, 628, 1696, 630, 1550, 310, 474}]}, {
      Line3DBox[{1255, 1508, 1557, 907, 1524, 1509, 1881, 1424, 1525, 1510, 
       1587, 1757, 1897, 1425, 1586, 1575, 1892, 1426, 1256, 1815, 1427, 1257,
        1816, 1428, 1258, 1817, 1429, 1259, 1818, 1430, 1260, 1819, 1431, 
       1261, 1820, 1432, 1262, 1821, 1433, 1263, 1822, 1434, 1264, 1823, 1435,
        1265, 1755, 1884, 1436, 1526}], 
      Line3DBox[{466, 372, 1527, 340, 1890, 1559, 1528, 1529, 919, 1560, 1530,
        1531, 1885, 1437, 1266, 1649, 1650, 1438, 1267, 1824, 1439, 1268, 
       1825, 1440, 1269, 1826, 1441, 1270, 1706, 1764, 1271, 1827, 1442, 1272,
        1828, 1443, 1273, 1829, 1444, 1274, 1830, 1445, 1275, 1831, 1446, 
       1276, 1832, 1447, 1277}], 
      Line3DBox[{1278, 1598, 1511, 1588, 1601, 1633, 1153, 1532, 1602, 1634, 
       1512, 1589, 1609, 1898, 1610, 1533, 1513, 1591, 1160, 1611, 1590, 1576,
        1893, 1448, 1279, 1187, 1630, 1449, 1280, 1833, 1664, 1665, 1450, 
       1281, 1834, 1451, 1282, 1707, 1765, 1283, 1708, 1766, 1284, 1835, 1452,
        1285, 1836, 1453, 1286, 1837, 1454, 1287, 1838, 1455, 1288, 1839, 
       1456, 1289}], 
      Line3DBox[{425, 232, 1149, 426, 233, 1082, 277, 234, 1083, 278, 235, 
       332, 1109, 236, 484, 1165, 482, 1290, 1840, 1457, 1291, 1709, 1767, 
       1292, 1710, 1768, 1293, 1711, 1769, 1294, 1841, 1458, 1295, 1842, 1459,
        1296, 1843, 1460, 1297, 1844, 1461, 1298}], 
      Line3DBox[{1312, 1465, 1848, 1311, 1464, 1847, 1310, 1463, 1846, 1309, 
       1775, 1715, 1308, 1774, 1714, 1307, 1773, 1713, 1306, 1772, 1712, 1305,
        1462, 1845, 1304, 1667, 1676, 1666, 1909, 1677, 1303, 1668, 1615, 
       1616, 1163, 1302, 1661, 1613, 1614, 1612, 1301, 1194, 1635, 1300, 1771,
        1537, 1536, 1299, 1770, 1684, 1683, 1700}], 
      Line3DBox[{1326, 1467, 1850, 1325, 1781, 1721, 1324, 1780, 1720, 1323, 
       1779, 1719, 1322, 1778, 1718, 1321, 1777, 1717, 1320, 1776, 1716, 1319,
        1466, 1849, 1318, 963, 1317, 1653, 1905, 1761, 1316, 1579, 1642, 540, 
       1315, 538, 1903, 1636, 526, 1314, 1233, 1701}], 
      Line3DBox[{106, 403, 813, 107, 404, 814, 108, 405, 815, 109, 407, 110, 
       1151, 429, 111, 1222, 586, 112, 816, 113, 817, 114, 818, 115, 819, 116,
        820, 117, 821, 118, 822, 119, 823, 120}], 
      Line3DBox[{1339, 1788, 1728, 1338, 1787, 1727, 1337, 1786, 1726, 1336, 
       1785, 1725, 1335, 1784, 1724, 1334, 1783, 1723, 1333, 1782, 1722, 1332,
        973, 1331, 1669, 1908, 1763, 1330, 1580, 1654, 1207, 1655, 1329, 1651,
        1652, 1643, 1515, 1328, 1752, 1886, 1540, 1514, 1681, 1578, 1699}], 
      Line3DBox[{1341, 1541, 1558, 981, 1340, 1516, 1604, 1882, 1468, 1342, 
       1517, 1883, 1469, 1599, 1518, 1618, 1647, 1470, 1592, 1753, 1900, 1620,
        1648, 1471, 1619, 1758, 1910, 1678, 1472, 1343, 1851, 1473, 1344, 985,
        1345, 1852, 1474, 1346, 1853, 1475, 1347, 1854, 1476, 1348, 1855, 
       1477, 1349, 1856, 1478, 1350, 1857, 1479, 1351}], 
      Line3DBox[{471, 383, 1542, 343, 1891, 1561, 1543, 1544, 993, 1562, 1545,
        1546, 1887, 1480, 1352, 1617, 1644, 1481, 1662, 1759, 1899, 1482, 
       1670, 1223, 1483, 1353, 1858, 1484, 1354, 1729, 1789, 1355, 997, 1356, 
       1859, 1485, 1357, 1860, 1486, 1358, 1861, 1487, 1359, 1862, 1488, 1360,
        1863, 1489, 1361}], 
      Line3DBox[{1362, 1600, 1519, 1593, 1605, 1637, 1154, 1547, 1606, 1638, 
       1520, 1594, 1621, 1901, 1622, 1548, 1521, 1596, 1760, 1902, 1623, 1595,
        1581, 1895, 1490, 1363, 1864, 1631, 1632, 1491, 1364, 1865, 1671, 
       1672, 1492, 1365, 1866, 1493, 1366, 1730, 1790, 1367, 1731, 1791, 1368,
        1007, 1369, 1867, 1494, 1370, 1868, 1495, 1371, 1869, 1496, 1372, 
       1870, 1497, 1373}], 
      Line3DBox[{432, 250, 1143, 413, 251, 1096, 306, 252, 1097, 307, 253, 
       337, 1113, 254, 504, 1182, 502, 1374, 1871, 1498, 1375, 1732, 1792, 
       1376, 1733, 1793, 1377, 1734, 1794, 1378, 1019, 1379, 1872, 1499, 1380,
        1873, 1500, 1381, 1874, 1501, 1382}], 
      Line3DBox[{1396, 1505, 1878, 1395, 1504, 1877, 1394, 1503, 1876, 1393, 
       1801, 1738, 1392, 1800, 1737, 1391, 1799, 1736, 1390, 1798, 1735, 1389,
        1502, 1875, 1388, 1674, 1679, 1673, 1911, 1680, 1387, 1675, 1628, 
       1629, 1627, 1907, 1386, 1663, 1625, 1626, 1624, 1385, 1797, 1640, 1639,
        1384, 1796, 1552, 1551, 1383, 1795, 1688, 1597, 1687, 1703}], 
      Line3DBox[{1410, 1507, 1880, 1409, 1042, 1408, 1806, 1743, 1407, 1805, 
       1742, 1406, 1804, 1741, 1405, 1803, 1740, 1404, 1802, 1739, 1403, 1506,
        1879, 1402, 1035, 1401, 1658, 1906, 1762, 1400, 1584, 1645, 546, 1399,
        544, 1904, 1641, 534, 1398, 1234, 1704}], 
      Line3DBox[{1423, 1556, 1889, 1756, 1422, 1814, 1751, 1421, 1813, 1750, 
       1420, 1812, 1749, 1419, 1811, 1748, 1418, 1810, 1747, 1417, 1809, 1746,
        1416, 1808, 1745, 1415, 1807, 1744, 1414, 1585, 1659, 1211, 1660, 
       1413, 1656, 1657, 1646, 1523, 1412, 1754, 1888, 1555, 1522, 1682, 
       1698}]}, {
      Line3DBox[{536, 369, 1892, 732, 560, 1650, 561, 373, 1893, 769, 235, 
       481, 1614, 480, 539, 1642, 380, 541, 1643, 242, 407, 245, 1618, 491, 
       490, 1644, 542, 384, 1895, 851, 253, 501, 1626, 500, 545, 1645, 391, 
       547, 1646, 260, 420}], 
      Line3DBox[{733, 909, 1815, 734, 921, 1824, 756, 1186, 1187, 1188, 1189, 
       1058, 1109, 1059, 1166, 1163, 1212, 1164, 792, 1905, 1204, 1205, 1206, 
       1207, 1129, 1140, 1130, 1151, 1152, 1063, 1141, 1064, 1900, 1174, 1171,
        1213, 1172, 1899, 838, 1190, 1864, 1191, 1192, 1193, 1069, 1113, 1070,
        1183, 1180, 1907, 1214, 1181, 874, 1906, 1208, 1209, 1210, 1211, 1133,
        1147, 1134, 898}], 
      Line3DBox[{735, 910, 1816, 736, 922, 1825, 757, 1215, 1833, 1216, 1217, 
       581, 1165, 1162, 1230, 598, 1909, 1219, 1218, 793, 963, 804, 1908, 
       1220, 1221, 1222, 587, 1173, 1170, 1910, 1231, 600, 1224, 1223, 839, 
       1225, 1865, 1226, 1227, 593, 1182, 1179, 1232, 602, 1911, 1229, 1228, 
       875, 1035, 886, 1807, 1045, 899}], 
      Line3DBox[{737, 911, 1817, 738, 923, 1826, 758, 932, 1834, 770, 943, 
       1840, 781, 954, 1845, 794, 964, 1849, 805, 973, 816, 984, 1851, 827, 
       995, 1858, 840, 1004, 1866, 852, 1015, 1871, 863, 1026, 1875, 876, 
       1036, 1879, 887, 1808, 1046, 900}], 
      Line3DBox[{8, 1259, 23, 1270, 38, 1282, 53, 1291, 68, 1305, 83, 1319, 
       98, 1332, 113, 1344, 128, 1354, 143, 1366, 158, 1375, 173, 1389, 188, 
       1403, 203, 1416, 218}], 
      Line3DBox[{739, 912, 1818, 740, 1764, 924, 759, 1765, 933, 771, 1767, 
       944, 782, 1772, 955, 795, 1776, 965, 806, 1782, 974, 817, 985, 828, 
       1789, 996, 841, 1790, 1005, 853, 1792, 1016, 864, 1798, 1027, 877, 
       1802, 1037, 888, 1809, 1047, 901}], 
      Line3DBox[{741, 913, 1819, 742, 925, 1827, 760, 1766, 934, 772, 1768, 
       945, 783, 1773, 956, 796, 1777, 966, 807, 1783, 975, 818, 986, 1852, 
       829, 997, 842, 1791, 1006, 854, 1793, 1017, 865, 1799, 1028, 878, 1803,
        1038, 889, 1810, 1048, 902}], 
      Line3DBox[{743, 914, 1820, 744, 926, 1828, 761, 935, 1835, 773, 1769, 
       946, 784, 1774, 957, 797, 1778, 967, 808, 1784, 976, 819, 987, 1853, 
       830, 998, 1859, 843, 1007, 855, 1794, 1018, 866, 1800, 1029, 879, 1804,
        1039, 890, 1811, 1049, 903}], 
      Line3DBox[{745, 915, 1821, 746, 927, 1829, 762, 936, 1836, 774, 947, 
       1841, 785, 1775, 958, 798, 1779, 968, 809, 1785, 977, 820, 988, 1854, 
       831, 999, 1860, 844, 1008, 1867, 856, 1019, 867, 1801, 1030, 880, 1805,
        1040, 891, 1812, 1050, 904}], 
      Line3DBox[{747, 916, 1822, 748, 928, 1830, 763, 937, 1837, 775, 948, 
       1842, 786, 959, 1846, 799, 1780, 969, 810, 1786, 978, 821, 989, 1855, 
       832, 1000, 1861, 845, 1009, 1868, 857, 1020, 1872, 868, 1031, 1876, 
       881, 1806, 1041, 892, 1813, 1051, 905}], 
      Line3DBox[{749, 917, 1823, 750, 929, 1831, 764, 938, 1838, 776, 949, 
       1843, 787, 960, 1847, 800, 1781, 970, 811, 1787, 979, 822, 990, 1856, 
       833, 1001, 1862, 846, 1010, 1869, 858, 1021, 1873, 869, 1032, 1877, 
       882, 1042, 893, 1814, 1052, 906}], 
      Line3DBox[{751, 1076, 1077, 1884, 752, 930, 1832, 765, 939, 1839, 777, 
       950, 1844, 788, 961, 1848, 801, 971, 1850, 812, 1788, 980, 823, 991, 
       1857, 834, 1002, 1863, 847, 1011, 1870, 859, 1022, 1874, 870, 1033, 
       1878, 883, 1043, 1880, 894, 1889, 1104, 1105, 1106}], 
      Line3DBox[{895, 1044, 1101, 1240, 1248}], 
      Line3DBox[{896, 506, 1102, 361, 717}], 
      Line3DBox[{897, 1185, 1184, 1103, 1071, 1888, 885, 1146, 1145, 1144, 
       1100, 1904, 1198, 873, 1025, 1797, 1195, 862, 1014, 1097, 1068, 850, 
       1177, 1176, 1902, 1142, 1066, 1156, 837, 1887, 994, 1093, 826, 1883, 
       983, 1150, 1062, 815, 1169, 1168, 1089, 1060, 1886, 803, 1139, 1138, 
       1137, 1086, 1903, 1197, 791, 953, 1194, 780, 942, 1083, 1057, 768, 
       1161, 1160, 1136, 1055, 1155, 755, 1885, 920, 1079, 731, 1897, 1158, 
       1157, 1135, 1053, 1203, 1196}], 
      Line3DBox[{1072, 1119, 1120, 1073, 907, 729, 1074, 1107, 1115, 1890, 
       918, 753, 1121, 1122, 1080, 1153, 1159, 931, 766, 1199, 1200, 1149, 
       940, 778, 1235, 1770, 1110, 1241, 1249}], 
      Line3DBox[{1148, 423, 1075, 908, 1881, 730, 1078, 1108, 919, 754, 1054, 
       1081, 1898, 478, 767, 1056, 1082, 941, 779, 1084, 1771, 952, 790, 1233,
        1243}], 
      Line3DBox[{1244, 1234, 872, 1024, 1796, 1098, 861, 1013, 1096, 1067, 
       849, 497, 1901, 1095, 1065, 836, 993, 1112, 1092, 825, 1882, 982, 1061,
        814, 487, 1088, 379, 685}], 
      Line3DBox[{1247, 1239, 1087, 1167, 972, 813, 1090, 981, 824, 1091, 1111,
        1117, 1891, 992, 835, 1124, 1125, 1094, 1154, 1175, 1003, 848, 1201, 
       1202, 1143, 1178, 1012, 860, 1236, 1795, 1114, 1242, 1252}]}, {}, {}}},
   
   VertexNormals->CompressedData["
1:eJzsfGdQVF23JsEAKJKUIIgEIwiCgqiACwURBCSqCAiIIkgOgoiigBJFyQKi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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->
   NCache[{{0, 5}, {0, 4 Pi}, {-0.5757586853575312, 1.000211104840616}}, {{0, 
     5}, {0, 12.566370614359172`}, {-0.5757586853575312, 1.000211104840616}}],
  
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"NDSolve::bdord",
 CellLabel->"Out[3]=",
 CellID->352080987]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["sol", "MR"],
 "."
}], "ExampleText",
 CellID->29899912],

Cell[BoxData[
 RowBox[{"Clear", "[", "sol", "]"}]], "Input",
 CellTags->"NDSolve::bdord",
 CellLabel->"In[4]:=",
 CellID->8178]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bdord - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 55.7488446}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bdord", "synonyms" -> {}, "title" -> 
    "NDSolve::bdord", "type" -> "Message", "uri" -> "ref/message/bdord"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1784, 67, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->338333373]},
 "NDSolve::bdord"->{
  Cell[2519, 96, 1157, 36, 70, "Input",
   CellTags->"NDSolve::bdord",
   CellID->18066],
  Cell[3679, 134, 427, 9, 70, "Message",
   CellTags->"NDSolve::bdord",
   CellID->60053472],
  Cell[4109, 145, 1345, 46, 70, "Output",
   CellTags->"NDSolve::bdord",
   CellID->56852080],
  Cell[5631, 202, 1213, 37, 70, "Input",
   CellTags->"NDSolve::bdord",
   CellID->7972],
  Cell[6847, 241, 520, 18, 70, "Output",
   CellTags->"NDSolve::bdord",
   CellID->186437358],
  Cell[7484, 267, 484, 16, 70, "Input",
   CellTags->"NDSolve::bdord",
   CellID->6905],
  Cell[7971, 285, 116183, 1889, 70, "Output",
   CellTags->"NDSolve::bdord",
   CellID->352080987],
  Cell[124278, 2184, 127, 4, 70, "Input",
   CellTags->"NDSolve::bdord",
   CellID->8178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 125366, 2216},
 {"NDSolve::bdord", 125506, 2220}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->17576],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 266, 6, 70, "Message",
 CellID->110252621],
Cell[1527, 57, 220, 5, 70, "Notes",
 CellID->9395]
}, Closed]],
Cell[CellGroupData[{
Cell[1784, 67, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->338333373],
Cell[CellGroupData[{
Cell[2169, 81, 147, 5, 70, "ExampleSection",
 CellID->37098099],
Cell[2319, 88, 175, 4, 70, "ExampleText",
 CellID->524474159],
Cell[CellGroupData[{
Cell[2519, 96, 1157, 36, 70, "Input",
 CellTags->"NDSolve::bdord",
 CellID->18066],
Cell[3679, 134, 427, 9, 70, "Message",
 CellTags->"NDSolve::bdord",
 CellID->60053472],
Cell[4109, 145, 1345, 46, 70, "Output",
 CellTags->"NDSolve::bdord",
 CellID->56852080]
}, Open  ]],
Cell[5469, 194, 137, 4, 70, "ExampleText",
 CellID->52908370],
Cell[CellGroupData[{
Cell[5631, 202, 1213, 37, 70, "Input",
 CellTags->"NDSolve::bdord",
 CellID->7972],
Cell[6847, 241, 520, 18, 70, "Output",
 CellTags->"NDSolve::bdord",
 CellID->186437358]
}, Open  ]],
Cell[7382, 262, 77, 1, 70, "ExampleText",
 CellID->530030494],
Cell[CellGroupData[{
Cell[7484, 267, 484, 16, 70, "Input",
 CellTags->"NDSolve::bdord",
 CellID->6905],
Cell[7971, 285, 116183, 1889, 70, "Output",
 CellTags->"NDSolve::bdord",
 CellID->352080987]
}, Open  ]],
Cell[124169, 2177, 106, 5, 70, "ExampleText",
 CellID->29899912],
Cell[124278, 2184, 127, 4, 70, "Input",
 CellTags->"NDSolve::bdord",
 CellID->8178]
}, Open  ]]
}, Open  ]],
Cell[124432, 2192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

