(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7451,        262]
NotebookOptionsPosition[      5085,        184]
NotebookOutlinePosition[      6549,        229]
CellTagsIndexPosition[      6433,        223]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::chbvp", "ObjectName",
 CellID->30203],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"chbvp\"\>"}], ":", 
  " ", "\<\"The option Method -> Chasing is only legitimate for boundary \
value problems with values specified at two or more distinct points.\"\>"}]], \
"Message", "MSG",
 CellID->469556221],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData["\"\<Chasing\>\""], "InlineFormula"],
 " is used as the value of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option and the first argument in ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " is not a specification of a boundary value problem."
}], "Notes",
 CellID->22599]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115789295],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->99220135],

Cell["\<\
An error occurs in this example because the specified method is not designed \
for solving equations that are not boundary value problems.\
\>", "ExampleText",
 CellID->57973161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "^", "2"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "^", "2"}]}], " ", "\[Equal]", " ", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Method", "->", "\"\<Chasing\>\""}]}], "]"}]], "Input",
 CellTags->"NDSolve::chbvp",
 CellLabel->"In[1]:=",
 CellID->16952],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"chbvp\"\>"}], ":", 
  " ", "\<\"The option Method -> Chasing is only legitimate for boundary \
value problems with values specified at two or more distinct points.\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::chbvp",
 CellID->49948180],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"y", "[", "t", "]"}], "2"]}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\<\"Chasing\"\>"}]}], "]"}]], "Output",
 CellTags->"NDSolve::chbvp",
 CellLabel->"Out[1]=",
 CellID->61285356]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::chbvp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 2.7490238}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::chbvp", "synonyms" -> {}, "title" -> 
    "NDSolve::chbvp", "type" -> "Message", "uri" -> "ref/message/chbvp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2041, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->115789295]},
 "NDSolve::chbvp"->{
  Cell[2789, 106, 942, 29, 70, "Input",
   CellTags->"NDSolve::chbvp",
   CellID->16952],
  Cell[3734, 137, 296, 7, 70, "Message",
   CellTags->"NDSolve::chbvp",
   CellID->49948180],
  Cell[4033, 146, 986, 31, 70, "Output",
   CellTags->"NDSolve::chbvp",
   CellID->61285356]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5991, 206},
 {"NDSolve::chbvp", 6131, 210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->30203],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 268, 6, 70, "Message",
 CellID->469556221],
Cell[1529, 57, 475, 15, 70, "Notes",
 CellID->22599]
}, Closed]],
Cell[CellGroupData[{
Cell[2041, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115789295],
Cell[CellGroupData[{
Cell[2426, 91, 147, 5, 70, "ExampleSection",
 CellID->99220135],
Cell[2576, 98, 188, 4, 70, "ExampleText",
 CellID->57973161],
Cell[CellGroupData[{
Cell[2789, 106, 942, 29, 70, "Input",
 CellTags->"NDSolve::chbvp",
 CellID->16952],
Cell[3734, 137, 296, 7, 70, "Message",
 CellTags->"NDSolve::chbvp",
 CellID->49948180],
Cell[4033, 146, 986, 31, 70, "Output",
 CellTags->"NDSolve::chbvp",
 CellID->61285356]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5058, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

