(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11776,        393]
NotebookOptionsPosition[      8731,        291]
NotebookOutlinePosition[     10466,        345]
CellTagsIndexPosition[     10351,        339]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::eerr", "ObjectName",
 CellID->23224],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerr\"\>"}], ":", 
  " ", "\<\"Warning: Scaled local spatial error estimate of `1` at `2` = `3` \
in the direction of independent variable `4` is much greater than prescribed \
error tolerance. Grid spacing with `5` points may be too large to achieve the \
desired accuracy or precision.  A singularity may have formed or you may want \
to specify a smaller grid spacing using the MaxStepSize or MinPoints method \
options.\"\>"}]], "Message", "MSG",
 CellID->77345135],

Cell["\<\
Generated by excessive numerical error while solving   a partial differential \
equation.\
\>", "Notes",
 CellID->24722],

Cell[TextData[{
 "This error can   sometimes be avoided by reducing the value of the ",
 Cell[BoxData[
  ButtonBox["StartingStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartingStepSize"]], "InlineFormula"],
 " option to increase the number of grid points, or by lowering the value of  \
 the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " option to increase the error tolerance."
}], "Notes",
 CellID->6163]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204924484],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->334514549],

Cell["\<\
A warning is generated in this example because the default choice for grid \
spacing is not sufficient for computing a solution to within the default \
error tolerance.\
\>", "ExampleText",
 CellID->64460207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::eerr",
 CellLabel->"In[1]:=",
 CellID->26633],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerr\"\>"}], ":", 
  " ", "\<\"Warning: Scaled local spatial error estimate of \
\\!\\(104.57221301902693`\\) at \\!\\(t\\) = \\!\\(1.`\\) in the direction of \
independent variable \\!\\(x\\) is much greater than prescribed error \
tolerance. Grid spacing with \\!\\(25\\) points may be too large to achieve \
the desired accuracy or precision.  A singularity may have formed or you may \
want to specify a smaller grid spacing using the MaxStepSize or MinPoints \
method options.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::eerr",
 CellID->60993961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::eerr",
 CellLabel->"Out[1]=",
 CellID->76825934]
}, Open  ]],

Cell[TextData[{
 "This error can be avoided by lowering the value of the ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " option, which raises the error tolerance."
}], "ExampleText",
 CellID->52060170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::eerr",
 CellLabel->"In[2]:=",
 CellID->28051],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerr\"\>"}], ":", 
  " ", "\<\"Warning: Scaled local spatial error estimate of \
\\!\\(20.81941730364856`\\) at \\!\\(t\\) = \\!\\(1.`\\) in the direction of \
independent variable \\!\\(x\\) is much greater than prescribed error \
tolerance. Grid spacing with \\!\\(25\\) points may be too large to achieve \
the desired accuracy or precision.  A singularity may have formed or you may \
want to specify a smaller grid spacing using the MaxStepSize or MinPoints \
method options.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::eerr",
 CellID->83379104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::eerr",
 CellLabel->"Out[2]=",
 CellID->50811827]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::eerr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 10.9523588}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::eerr", "synonyms" -> {}, "title" -> 
    "NDSolve::eerr", "type" -> "Message", "uri" -> "ref/message/eerr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2602, 90, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->204924484]},
 "NDSolve::eerr"->{
  Cell[3381, 120, 1334, 41, 70, "Input",
   CellTags->"NDSolve::eerr",
   CellID->26633],
  Cell[4718, 163, 611, 11, 70, "Message",
   CellTags->"NDSolve::eerr",
   CellID->60993961],
  Cell[5332, 176, 501, 18, 70, "Output",
   CellTags->"NDSolve::eerr",
   CellID->76825934],
  Cell[6161, 209, 1387, 42, 70, "Input",
   CellTags->"NDSolve::eerr",
   CellID->28051],
  Cell[7551, 253, 610, 11, 70, "Message",
   CellTags->"NDSolve::eerr",
   CellID->83379104],
  Cell[8164, 266, 501, 18, 70, "Output",
   CellTags->"NDSolve::eerr",
   CellID->50811827]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9634, 313},
 {"NDSolve::eerr", 9773, 317}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->23224],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 525, 9, 70, "Message",
 CellID->77345135],
Cell[1785, 60, 130, 4, 70, "Notes",
 CellID->24722],
Cell[1918, 66, 647, 19, 70, "Notes",
 CellID->6163]
}, Closed]],
Cell[CellGroupData[{
Cell[2602, 90, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->204924484],
Cell[CellGroupData[{
Cell[2987, 104, 148, 5, 70, "ExampleSection",
 CellID->334514549],
Cell[3138, 111, 218, 5, 70, "ExampleText",
 CellID->64460207],
Cell[CellGroupData[{
Cell[3381, 120, 1334, 41, 70, "Input",
 CellTags->"NDSolve::eerr",
 CellID->26633],
Cell[4718, 163, 611, 11, 70, "Message",
 CellTags->"NDSolve::eerr",
 CellID->60993961],
Cell[5332, 176, 501, 18, 70, "Output",
 CellTags->"NDSolve::eerr",
 CellID->76825934]
}, Open  ]],
Cell[5848, 197, 288, 8, 70, "ExampleText",
 CellID->52060170],
Cell[CellGroupData[{
Cell[6161, 209, 1387, 42, 70, "Input",
 CellTags->"NDSolve::eerr",
 CellID->28051],
Cell[7551, 253, 610, 11, 70, "Message",
 CellTags->"NDSolve::eerr",
 CellID->83379104],
Cell[8164, 266, 501, 18, 70, "Output",
 CellTags->"NDSolve::eerr",
 CellID->50811827]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8704, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

