(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7284,        255]
NotebookOptionsPosition[      4912,        177]
NotebookOutlinePosition[      6379,        222]
CellTagsIndexPosition[      6263,        216]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::eerri", "ObjectName",
 CellID->21886],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerri\"\>"}], ":", 
  " ", "\<\"Warning: Estimated initial error on the specified spatial grid in \
the direction of independent variable `1` exceeds prescribed error tolerance.\
\"\>"}]], "Message", "MSG",
 CellID->284493682],

Cell["\<\
Generated by an excessive numerical error estimate in the numerical solution \
of a partial differential equation.\
\>", "Notes",
 CellID->15844]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208265731],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224246673],

Cell["\<\
A warning message is generated in this example because the sharp feature in \
the boundary condition cannot be reliably resolved within the indicated \
restrictions on the step size.\
\>", "ExampleText",
 CellID->111483798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"MinStepSize", "\[Rule]", "0.01"}], ",", 
         RowBox[{"MaxStepSize", "\[Rule]", "0.01"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::eerri",
 CellLabel->"In[1]:=",
 CellID->16934],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"eerri\"\>"}], ":", 
  " ", "\<\"Warning: Estimated initial error on the specified spatial grid in \
the direction of independent variable \\!\\(x\\) exceeds prescribed error \
tolerance.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::eerri",
 CellID->130945453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::eerri",
 CellLabel->"Out[1]=",
 CellID->312297141]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::eerri - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 10.8117302}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::eerri", "synonyms" -> {}, "title" -> 
    "NDSolve::eerri", "type" -> "Message", "uri" -> "ref/message/eerri"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1735, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->208265731]},
 "NDSolve::eerri"->{
  Cell[2529, 96, 1463, 44, 70, "Input",
   CellTags->"NDSolve::eerri",
   CellID->16934],
  Cell[3995, 142, 318, 7, 70, "Message",
   CellTags->"NDSolve::eerri",
   CellID->130945453],
  Cell[4316, 151, 530, 19, 70, "Output",
   CellTags->"NDSolve::eerri",
   CellID->312297141]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5819, 199},
 {"NDSolve::eerri", 5959, 203}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->21886],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 282, 6, 70, "Message",
 CellID->284493682],
Cell[1543, 57, 155, 4, 70, "Notes",
 CellID->15844]
}, Closed]],
Cell[CellGroupData[{
Cell[1735, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208265731],
Cell[CellGroupData[{
Cell[2120, 80, 148, 5, 70, "ExampleSection",
 CellID->224246673],
Cell[2271, 87, 233, 5, 70, "ExampleText",
 CellID->111483798],
Cell[CellGroupData[{
Cell[2529, 96, 1463, 44, 70, "Input",
 CellTags->"NDSolve::eerri",
 CellID->16934],
Cell[3995, 142, 318, 7, 70, "Message",
 CellTags->"NDSolve::eerri",
 CellID->130945453],
Cell[4316, 151, 530, 19, 70, "Output",
 CellTags->"NDSolve::eerri",
 CellID->312297141]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4885, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

