(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    121875,       2204]
NotebookOptionsPosition[    118209,       2082]
NotebookOutlinePosition[    120160,       2142]
CellTagsIndexPosition[    120037,       2136]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ibcinc", "ObjectName",
 CellID->17530],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ibcinc\"\>"}], ":", 
  " ", "\<\"Warning: Boundary and initial conditions are \
inconsistent.\"\>"}]], "Message", "MSG",
 CellID->147292331],

Cell["\<\
Generated when the boundary conditions and initial conditions in a partial \
differential equation give different values for the solution at a single \
point.\
\>", "Notes",
 CellID->11922],

Cell["\<\
Difficulties with inconsistent boundary and initial conditions can sometimes \
be resolved by approximating the inconsistent conditions with consistent \
conditions.\
\>", "Notes",
 CellID->17446],

Cell["\<\
Although inconsistent boundary and initial conditions are common in practical \
models, such conditions generally represent unphysical processes, such as an \
instantaneous change in temperature, and can lead to singular solutions that \
may be difficult to handle by numerical methods.\
\>", "Notes",
 CellID->4446]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->291080810],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->289100817],

Cell[TextData[{
 "A warning is generated in this example because the initial conditions and   \
boundary conditions give two different values for the value of ",
 StyleBox["f[0,0]", "MR"],
 ".  This example corresponds to a heat equation in which the temperature at  \
 one endpoint changes instantly."
}], "ExampleText",
 CellID->307917443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"1", "-", "x"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0.2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"In[1]:=",
 CellID->8808],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ibcinc\"\>"}], ":", 
  " ", "\<\"Warning: Boundary and initial conditions are \
inconsistent.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ibcinc",
 CellID->73244119],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"Out[1]=",
 CellID->19649481]
}, Open  ]],

Cell["\<\
One way to avoid the inconsistent conditions on the solution is to replace \
the discontinuous condition with a similar condition that changes quickly but \
smoothly.\
\>", "ExampleText",
 CellID->127545552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", 
       RowBox[{"1", "-", "x"}]}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "1000"}], " ", "t"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "0.2"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"In[2]:=",
 CellID->24359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"Out[2]=",
 CellID->926377370]
}, Open  ]],

Cell["This shows a plot of the solution.", "ExampleText",
 CellID->41481026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"In[3]:=",
 CellID->27947],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVnXdUFEvz9xERxRwRFcWEGTFitsxgwqwopmsGVFTEiAnFjEQTApKD5Jxh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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFm3f8V+P7x9/nnPucpBKFBkUoq4hU9E0pDVQiySqjRQMJSWhYCWkooaiE
0JCGhlEyMrP3zg5Fgyj5PV9ed4/fH9fnfp3rfZ/7nHOPa39qdb+00yVpqVQ6
IpRKGe1U/jwP5Ump1IAfMvBJ8L/OS6XWRalUhusW9D0M3BH+s1y/Bx1M/zX0
aQN/J66P4d6ytKfS5wf47eBX5PpHcHvwruAm9NmZthN9WoB3A58J/p4+J9Fn
F65bwq9Eexb83+GfDr8m119D9/PMa6Cf4HeAvwe8jrzboeBz6f8r/FPB1eGv
B58G3lvvxJj70l5En9/gd4Zfg+sN4C7gfcDrwJ3Ae4HnQB9Au/OstfBPhr8n
19+BTwRXAM+FPob2pM8YfSf0F+P/RDsd3lhoF/rfxPtNht+Ld6jPb0PBPcGH
g68D5/QZTJ/bwZvBZzF+bX7bAu4GPgj8J7gr+ECwFu8Y2pvp/y38E+CX53og
/KaZx7kYfDT4JvAFjL2UfpeAv4E3lfcaCh1Jn5TrE+H3AzcC3wDuD24MvhHc
F9wQfD24N/gI8DBwH/BR4BHgEs/vCTXgOqHtBTXRuPSpSnsBXX7m+R3hV+H6
rsR7pzL0Du/2Ofyf6fNv4rYc9Db8z+C/yhir9K3QHvBf0ntpXcAJv10PLg9+
gnu30F4DjeRZD0Ej4J0BNYP+hP8mY37CmC9zX0t+/x6c8dtb8D8FvwL/T65v
0ZrS/yxwU2gT+Fza/0EbwRXp9xZ0oNZU65v7Gd1p78rdryftxdCx2gP0fROq
Q/9rE/M2gy/n9yuhXlx/zDuM1B6E/3zq9/oCvBI8GP7n4OfAV4E/Az8Ovgf8
qr4d3Bf8Orgx4x0NbQMfwDd9A03it/n06Uf7Bvxj+L0J9A94Ie1xPPtkcJvU
Z/08cDP4zXNNcqk0D34f+K9xOY7r4xLv86nwx8JfBp4GHg9+CtyS33dKLFse
YYwntB5cd5V8gQ6EXuWZreFXos9G2jN4z/25YRpUn9/LQEdBhyeWS8sZ/0p+
+4T+K8CDwJ+CO/LbydAP4K9ov4zP2MSYZzLmATqT4HPBB4P/Bp8HPgT8IfgY
8DrGex/cGPwjuBr0k/Y6Y15B24y+d4ADv18IHSdZSXsR1AL8Bd8yFvw+ffeE
PtTZpv+X8MfB/4Dr6tBa6Ej4n8G/A/67XO8F/Qw1gL877bfQoeCPtEb0Wc/1
5dCxPGc0/I+1v+D/Bm9v6BedQ/iVaNdAB4Mr034DHQJ+j/4N6f8V1++CjwJ/
KbkLfQ0dRJ89aL+D6oI/593G0Oc9rj8Fjwa/A64CfST5RZ9HGedqqBb4Mdpr
oP3AN0lOQb9KR8C7CtoXvE/q5zeW/GHMuwo/ex34AfDfej747sLv/S14UuHv
KRvPxQH6FvCt8F+Dn4P3k6yGfxLPqQ1VAVflt4/j2tVM/a2NtDfoP57+n+i7
wXeCP9V8QX9BLeizBv4E+J9xXQ58SO4z204tVBXcgfYgqDq4Pe2BUDVweemg
3DLhE/BXjPO21iD197XU3Oqswf9Hcjf1HOv9tyeeY40zFzwHGgCVjd+ieS6l
3i967tuMc2Th9fiUudksnUD/IvVeq6G9mno/7l2ybNkZqg3eRN/H6Pso9FHw
/Gpuv2TMloz5L/eMps/LmWXmHbTfZpatW+lzPn0O5fpxnSWoKuP8A787/Hpc
bwNfAK4L/gp8PFiC4AjGTWhP4PI8nlkX/sVxrioE78MSbQq9wJgnQuWg7zTn
tOWh7zWHjPEbdCXXBzDmJuh/8CvQfp76G/en3Qg1Adei/V26ELwf7QbpTvAX
vFsL3mG75lDyG7wF/IlkNvhPcPnUe0HzUy71ftkfvHPqfaQ9P4J3eRRaCx5C
+wD0DXh6lGOSg22gnaFv4T8M/22oAteHMsZW6Hj4w+DNlA0BbshvlaDdon7U
Xtc+eZe2CF7TLPU5qAAezn2PQD+BD9P859ZTg7i/CbQB/Br3tYFfGbyMvs/p
TPHb/ol1jfTLi4x3tdZNcwUvTaxrBnPfVOkzrofQ1mN+LgW3hlrF75LMb5H4
28+jz3XSQ1F+S5avke6DNw26THucZ13Es16BPxt8ofYceAK4o/YX+E7wybKz
wM9w39PQo+CJ8E+BPw98L/h08JPgvfl9Ne/Wmetq4NfAp4Krg18HdwLvBX4D
fJrsJO49QXOnfcI7JYl1yr6J9Z50zWR+Xwj9KxsgtR06SLKacV5inNayS8Cr
wG2kO1PbklfRp1tqG/NK8Dmp7crLwZtZi9mF7dGzU9uqA+F3TW2rXgG+DdxW
ewK8FHwZ+H2tHXigbFPwU9IN0mPgQ3jfvRLr90XwL4b/FvhQeHtDq8HVEtsF
0uPjZW/m/vbqiW0B2Q/7w/tI68v9TzPOFbQfRVtiRfB6NaJ/TagGtB/9P+S3
S+h3TmJb+A/6VIH/MvyT4E9mnC60i0u2zernli06x/JBdJYfyG0PyRb6s7BN
NQw8Pve+0Z4Zm3v/ae9dSHtEbrmk8103+IzfIdmY2z7ZWnivruM5X9PeKptP
cqvwfr6Xce6VjwDtEccfA42S/VBYrw2I7zAOuhV8D+3d0HjNdWod1x88iLZH
bntxYG5bUHbgBsaZnttvuTS3vdgsjjM4ninZocfnPoffyvaH7uM9v6OtA90P
nsWzetOu0v6k77vwu3P9EPzzaVdIz8J/B/4FkvHwe9G+pL0N/z34PbieAv8M
2iXw7wOfCV4qnQ7uCX4RXIP+b9L/LK5rgt8Cny3ZRp9utM/Q50HweeDlkqWF
dfENXH8pO66wLSC7XrpSNr2+/ZLce6Qq7Sv81o4+62ln5PZJfpJ/A82HP4Px
z6V9NtpChwTr8brwf4VagdfS98zc+/tXfp9eWJdvBc+Ntt/f4DnRtmwfdYpU
0hvwT8jtU6wGn5jb5pf8lWzeqWR/oV3U+5Ktu0gnl+ybdIg2gL5t18Q+S86z
H+M5u4Dfl02dW4ZLN1SUDoj8jvBrluybSH8Okf7lvkXgwVCnuJe0J9fC/xma
oD0P9U7sk7aSDQS/G/f24bpLPHt3QlWgq0v2BRbyvKc1//Q/jP6jwKfAvy+3
/yXfp320YU6Iekpmv3yERcFrvTD1HL+pd84977o+C3x2bjmwXftPfgxtC3gv
BMui48DPB8sW6YuyyX9qvvQ6f9rm9uPka6wMlksa8xzdD17Ccwfwzu+V7K+9
GCzHDuL5v0BL9f2J9eVB0JHQEdG/WMC9/TP3f1p7Nuo1nffJuedpMX2ekj6G
/w7tL5n9vC78/mTw3mtOe39uf/W8xLKvLtQYqgPVjuvVlX596b+F61WpbdG2
qeMi54M38ftjheMapyf2KdX/EfBM6OzEvn8v+g2Av412XvT3/wE/EeMAo+lz
m2QXfSZFWXcPeDt95kcfR/GRIVB/+DfAv1kyC3x66niJ4gAdU8djLtSapvbL
9dwlue0z2WY3gm/I7VN3SR3/uBTcPnX8oye4Q+qYTS/wyanjPb3BGxhjZuF4
ULvU8Yke8DfCf7Rw3KcCYy8vHMu4LnXMQO9ZEf6KwrGM3lHO36r3j7pDe1ib
dGG0RUeBb9G8wN6Jdlnh2MSg1DGJsfB3lv1QOMZRgBcXjr+UAS8pHJf5l3db
EH3DRPs/2rFXwe+sZzBOqr0Rbd1K2qeS3eDK2p/gVuBdwc8V9tl20/4Ht9Q+
AA+FjmFtbkrtO05jzPLwni0crykLfqpwzKUc+JnCsRjJrnbRBr4xtQ86Vbo4
ta2quFzj1DbsKeCmqf2MziXryOaJ11G+mewyyT3tOcUi+oEP5jm/Qq8z7mFx
f2tvr5ROyHyu8mjPyZaTTVc/4q7x3AXowdwyXfJ8p9iH2//zKbqnfgfpyuuh
ixLryM6J7dWJ8Prp/IP7546fSK69y71HcW+HkvvqHvXplNi+bV/yeZLu1ZmS
/h0B9UwcT9F8S7ZnufeT9pK+64XsP7fqv/PcKNozfSN+F/6piZ+h8ZtELFu6
L2NMkN2QOPZwSuL4Q4e4RmXAl8nvyBwrkV/wKnQ8uG1i3+Y7+lybeb5PSjxW
5/hdb2X2ETTuH9DqzGM+GPeB9oDWQfERvX/3KAMrliwHhaV3+sV1/Lpk/+ny
eK9iUNdE+aD37RD5mxOPX8T+HeK36H3eyKwTX4nfIltffk2rqC9kn8lWkn8h
H1bXku2Do2zTHuvEy1bOjBtFeap5fjhxrE1rKNtIelE6sWrEshWP597AvV3B
U6ItoT7H7pCdJX/r+fF7NQfd4pwoHnRB1AsfMcYnmfee4pCyNzXmYtolULOS
5dL1ilOAB4B/Kxzvll91eO69qvE17/LTrsgdx+sdZXnv+D6yaWX/3R/7dAh+
ls5K1/g+DSLW2dGePyd4fjYk9tNlH8pWkT81MLGtIhmitZQdLL9fMTT1kx26
m2Rgatu0Vsn2zsC43zZqP2W+7wPG2ci7rU5tN+icyW4fxtjzoSsS6yat3+5x
fa5OfMZ0FjfH89g47rM68dzo/Mg3kF2/ILdt/2GwPa390ZD7/kgdb3w/87pq
TurQ/gA1By+SfJYc1JmAt3tmfSTdfFXi8y+5eptsvpJtCp0t2RWSOfJFvwHX
5t7vU6/p7MzP1nMVd5Sdr3mTTyzbXvt2AffNh26C1kProNHQHH4/N/i8rOD6
BuhacMjtU9zI9TDG/pdn3JI4xj4szqeub06so0fT58TMPqzOx9x4ZjT+XGhe
Yr39eDybc2IfnaO7NUbiOV9J33q5ZZHeeWRi3SfbYGbua63f3bG/chArcn/X
n8F6XXJ4dnyunrcF/h+y4zPHECTf7kgsvxTzlcwcG7F8q1a5/SDttz+Cz6TO
Y694rirHdlJi22lSvO4aZanGllx9ifbJxPaY5L/i52MSj/kX71Mr2ktjonwY
qnhP5vlUfH94YntA3yW/UfOudRkV7QHtvVm54zbKs8zT2da8p87RjIjfNDZ+
Y13ZhrnXXXGv7zLrT6378sT3toh7THpN8TedqdlxLWcl3ksJz/09nscyPOv1
1LFQ5Yg2ZJ7DHfJi9/j86fEdzo58yZCZ8Ryqz5zoI0he9oztpjgP0+NcSMdt
Yx6mxX3xQNwbp6WW+9pXsvElu/N4dmSXK4bTKuIQ5Yb0lHTBDNmUmWWIeG0j
/0kGODnYB5Etf1G051vF8TWm8mLSg3oPxcZ+zXw2Ff+XHy4fXLEytbIl/soc
V9yxJ9TKn9FcvpR6PiWTFsU5eThiySfltHSGrksc35T83CEbhSUfJfcUs1bs
TvOzIJ73+RFrrnrIdsqcU9rxm3Jq6zPHLO5L7L8oljUl8XxOid8rOSF/VvOs
vTA77gfFU7Um0mWaM8UENG+XxHetFL9La631l48mv0NnXnnPa+N+OJ97l+WW
P7I/b1cMveR41B3gB6Wjac/l+h3wGt2fWL8oZpHHed6Xub+lcLxvlfRS7nhR
DfnxhWNMj6SOA62Evze86wvHoRQHKRu/96Xg2IV8w2qKmRSO5SlmsSRzDHEf
xQMKx5L21PnSGtB/eBrjQ9rDqeMBU8B70PeqwnGNSanjGU9IBqaOecwH1+T3
GwvHv55jvP/lzoXdkzrOsaDkGMrizHG96vS9tnDMsSrtkMLxlD1pBxeOfSj+
Xy04n/IO4zWA/wXj/aT4dHCc9kfaA4Pj+cpl1IhxJ+Uv9gmOOX9Pu29wXFp2
RaPCuk15jZrB8WfFKxoG58p/pj08OOf+C219xR3Aa2kPC87PzkwdY3tOMl/v
mDvXVkVrWDjWsxft8MKxv+vp3157lT5LguMkK0r2nbVmWq8P4B1dOJ4ie142
pexJ+fiLg2M7isWsyBxb/AFeLaipZAj39S8cny1D27dwLFV97i2cT9I83FM4
p7Vf8Fw0i3M4uXA+THM7pXAOTN97f+EY/WGpc19t6H946nxXW3D91PE+5REO
Sp2nawGulzqP1xp8YOo83nEl2+yy46UrZV/Lzpb91ix1rqML+NjUeYDTwb/z
Dg8XroH4DfxQ4Rz5ep2twjmM6zLb4rKZZd9I10rPNtfkwT8jrunUwnkIrem0
wrkKxfjqJc7tyv6fEeVqOa1b4dh3ecVTC8e4R6aOYU+nzzWp480TdG/qePNE
8JDUfued4IL7+hSOHV+d2jcdL9mS2gcdJ7mhs1g4ljcO/jnSX/Arw7uycNxt
TOr4n85pRZ37wnHDXWTHFY7nKk4qe0vyvAK8SwvH4n+Atme2e0aljrXPkC2U
Ogb/n7yi76DCMcSxqeOLs+DvKtlTOC55a+pYvmSa/OvRweMob9gouIZE8YR2
wXUdynXuFZyDU66zenD+TnEjxVFXx3M9sXCuqEbq892w5PzvAcH5TcUFaxX2
kRXTVI3BLyXn3SoH63HFVGeDny9F+6KwjaEY7GPB53Q3ySeoa2Y/WHpuTdQj
taNdmgXnjJUvXkmfl6HnoM8y28SyhxVjXxYcp1JcTfFhxdZ0RhUv1TlV3P6p
YJmv+PCsYLmt3KlqJ+QHK5b7YLDcUIx3RnDuXjmRKcEyU3mTe4PlrfImk4Pl
rXIr94EXlhzfGBksWxSruTlEuS3bTWdG3yX5CjXPbJuoJkb2ifICE4LXWnHg
icF7ryx9+0EdMsdDRgTv7X/BPeAfmTlWMyQ4F68YztXBOXHFdoYF73/Zbyuj
baxYytDg/a+cy9nQ4JLjKsODz9GazDavbAbFLGS7y25XHOm64PPyGbg577CN
9fhOeg96EOoTbUXJF+m1pIzXTmuotVSMTmdBfsHzkb8qrq/sQ+U6X4x2iXKe
sm3kW8jWlJ2pmokX47NkF12Q2sbW2M/H8ZfH/rIHlOOuElxjsI3+BbQssf8p
G0L2w1eZ/Sn5GYpJtof6SJfx/m35xnJR1jUNrsuSDDw2uBZLMb1WwfU8A6Iv
3COxzGym+S05t141uJ5B36D3U41T69TvoxotvZN8O9k/t2fOk/9ecn6/THD+
WvaactWaG9VLVAyuZ3iLZx5RuMZC9Qm7BNc8qAZjt/D/NQy7BtdRqAajElQP
/Cb31i9cu7Na71+4LmdVXBvN5y/wT4FfLXMsQf6t4mHyi+XPLk0cJ1gaddmT
0Vd9OnHtyReJfXrFV8TTPCumqkDKs3Ht9bzJca2fiWunPLtsTl3/pTOau3+3
4PyU4vnKnUxM7K/rTMmHkb+gPHuTYP0o/+aW6OM8njt+q72t8ZbFMbXWjxSu
w5NNrfqchYlr9k4I1onay8q36n317kvjvar3axkcY1R9oOoCFXtsAH6/cD1Q
Q/AHheuBZJ/MCc7PnpR6f3Uv2R57Ijj3JHvs8eD8oGzIecH5qe2Faw61lyVL
3y6sq2SzzaXPopLrBtsG627V5rUJjnmq5vDEYF2sWkHVCGrvDS1cHzVRZx7c
SGc4c93CZcG5XdUDNAi2H1TzcGlwDld1DpcH53aHFa6huot7/5daNpwWZcWM
wnl91Xs0Ds5Vqd7g6GD7RLUWxwTbNqrfax18r2p7Dg2uk5G/rji//A/VKR0c
rKdUn3BksF5YnjuXodyQ9OnM4Ly59PjDwXlz2dKPBOfK1xXWa7JfpK+nytaR
jC1cPynZIP07PThG8U/hOg3JSMnnVwvblLIHpgXnjmUP3B+cp5YNMyk4Li37
8C7ZcyXbM3cHx7oVPx8EHllyjP2K4DpGOaMDg+sVx6fWA3NKjierlk5xvg8z
12TK95WPqxo/+VS/yz7JHU/aDD6kcJxPOmhl4fotxcNUt1Sr5DquW3jWGPDr
0vu547fdaD8unBOSv/N0cD5UvsazIeZeC/tL8pXWRX92Mu8wNHPtoOLMssNl
c68Av5bZd1ZuTXVo/YJrAORnPROcn5V/tDy4/kG29NjgPIhqzEYF5y9uSK1L
NZ86s4q/SF/I3htHn0ng6altDeX7VId5Y3DO4u7MNYDK0cn2eyh4blULd3Fw
vcGVqXWs5uRm+hwrOyD6ndIdkmeyJVQTcwB9RmXOdSnPpVi75l/rcmvmWpza
8bnPpK4f0DiKQWgdletUHFg+u56h+kLl/hbF38SflbmeSbpgXub6w60l17mo
TlP52AWZ89ZaI9Xh/JM4D/tE5npI1Tps571+LJz7fBN6KHNsWzU7qi1dG/so
v6M4w446VNWUDov2gOIK0hcHQ+t1ljPHP1Vfozyo8qOrowyUX/Y3eBx95qau
l2gK7+fC9ZrSa4rtVorjqJ5JPoTivtq3iv0qPq26YsWoVROkelXlpR9mnDWF
40fSm9sS522l11Sr9lvJ9Q3KPShudxv478T567RwHlA2mGSfcvnK7Up+Kdeu
XKfktuSh5lkyUftJe2lC5npT+dfKM14SXCe8PHNNqWpH5CMq3yo/UbW+pwbn
PRVXVMxCOk711Z2D84CqzT49OIeoeuwuwTlE1VqfElyDqrpQ1S4rX6l6zh7B
+cezUuvny0qu9z4tWKdId88qXHOs2uk+wXU1siGXFq5dVuDqGvjDS679PjM4
B6r6q78S5/dHFq59nZK57vrC4GddyHPrZL53VGG5oXOvGvUzgvOef4AfL1y/
rbqsrYnz/rL/VduqV9gS9a50rvxB1fuq/kp1WS+k9g0lixTDUQ5O+0fnUTVI
qkd6NnWeXe+n2l/l1lXPpXy4arq0z5UzUm3sk5lrZVXPJH//vsI1o8r3qU5L
uUDlfOTPKuYnebUpcYxPsvGHwvls9VF+SPkixXVUk6zYjnKD+t8B5TQWZa7R
1Xsq7qJaZcVelFcdEFxPvlPhuiP5hsq5638JFB+WH187uG5TcQLFC+QTvUHf
rIzjp6pzVL5CMTPVmaoOXPlM2YSv6l0T5837BtelK2/eP7h2/bbC9RiSK7Kv
ugfbpaoP6Rlck6+1O6fwGquGpHdwrbvkkmKvijeOKFzzINmzKeoV2aj6rrSM
4/s6a1sKx6lVU6C8lXIXquXQ/wzIftsR95T/rFqMU3PHzFXroZi3dLpqP/cI
1lk6+4rtz4C/NXM9rnxV9dkzztvthWWUZLByOMNzxyY2Zs5PKBehvaf/91Ac
sFXh5yo3Ij2qGKXyxE0L3ysfVOtSJzjGotin8g6KfyoGUy84DqP41uL4Xv8H
rJtKlw==
         "]], Polygon3DBox[CompressedData["
1:eJwtm3ngF8Mfxnd3dhYhN5WrUuQoKiUUUUSuSiFHiBSiFBIdhNyVK4Qk5cid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         "]], Polygon3DBox[CompressedData["
1:eJwt13n81VMex/Fbv9sNabWkTdpps0TJUmMpVKKQpIWyTJZCMsOMrUGh7KmR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         "]], 
        Polygon3DBox[{{1120, 1272, 802, 994, 1580, 1119}, {1321, 1486, 719, 
         526, 525, 906}, {1334, 1333, 914, 672, 673, 915}, {1316, 1484, 711, 
         504, 503, 894}, {1341, 1340, 921, 687, 688, 922}}]}]}, {}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{1059, 395, 61}, {1480, 1473, 463}, {460, 473, 396}, {
         395, 396, 61}, {395, 1476, 462}, {1028, 1473, 16}, {473, 470, 396}, {
         476, 474, 16}, {458, 461, 31}, {457, 465, 1}, {471, 496, 61}, {395, 
         1059, 46}, {1032, 1475, 31}, {466, 464, 262}, {470, 472, 396}, {1476,
          395, 469}, {1478, 1475, 475}},
         VertexColors->None], 
        Polygon3DBox[{{472, 471, 61, 396}, {459, 469, 395, 46}, {1477, 1044, 
         31, 461}, {1044, 1477, 459, 46}, {465, 468, 344, 1}, {1473, 1480, 
         476, 16}, {1475, 1478, 458, 31}, {462, 460, 396, 395}, {468, 466, 
         262, 344}},
         VertexColors->None], 
        Polygon3DBox[{{1475, 1032, 16, 474, 475}, {1473, 1028, 262, 464, 
         463}},
         VertexColors->None]}]}, {}}, {{
      Line3DBox[{457, 1, 344, 262, 1028, 16, 1032, 31, 1044, 46, 1059, 61, 
       496, 471, 472, 470, 473, 460, 462, 1476, 469, 459, 1477, 461, 458, 
       1478, 475, 474, 476, 1480, 463, 464, 466, 468, 465, 457}], 
      Line3DBox[{263, 2, 964, 306, 295, 353, 477, 478, 479, 480, 481, 482, 
       1479, 483, 484, 485, 1481, 486, 487, 1482, 488, 489, 1483, 490, 491, 
       492, 493, 494, 495, 467, 1385, 337, 76, 1386, 339, 91, 1387, 341, 106, 
       1116, 1117, 121, 1143, 136, 1156, 151, 1169, 166, 1183, 181, 1198, 196,
        1371, 286, 362, 211, 351, 300, 696, 212, 697, 213, 698, 214, 699, 215,
        700, 216, 701, 217, 702, 703, 218, 704, 219, 705, 220, 706, 221, 707, 
       222, 708, 223, 709, 224, 957, 294, 363, 225, 352, 302, 1225, 210, 1211,
        195, 1196, 180, 1181, 165, 1167, 150, 1154, 135, 1142, 1141, 120, 
       1114, 105, 1100, 90, 1086, 75, 1072, 60, 1057, 45, 1042, 30, 1359, 274,
        354, 15, 349, 296, 517, 14, 515, 13, 513, 12, 511, 11, 509, 10, 507, 
       9, 505, 8, 973, 334, 502, 7, 331, 501, 6, 327, 500, 5, 324, 4, 969, 
       321, 3, 928, 263}]}, {
      Line3DBox[{1042, 1247, 1681, 1041, 1246, 1680, 1040, 1245, 1679, 1039, 
       1244, 1678, 1038, 1243, 1677, 1037, 1242, 1760, 1323, 1036, 1584, 1487,
        1322, 1035, 1583, 1486, 1321, 1676, 1034, 1241, 903, 1033, 1240, 1759,
        1571, 1451, 1239, 1780, 1403, 1450, 1238, 1779, 1401, 1449, 717, 1399,
        1470, 1795, 1485, 1481}], 
      Line3DBox[{1057, 1255, 1690, 1056, 1254, 1689, 1055, 1253, 1688, 1054, 
       1252, 1687, 1053, 1251, 1686, 1052, 1589, 1492, 1051, 1588, 1491, 1050,
        1587, 1490, 1685, 1049, 1250, 1684, 1048, 1249, 1683, 1047, 1248, 
       1682, 1046, 729, 1045, 1586, 1489, 1043, 1585, 1488, 1482}], 
      Line3DBox[{1072, 1260, 1696, 1071, 1259, 1695, 1070, 1258, 1694, 1069, 
       753, 1068, 1595, 1497, 1067, 1594, 1496, 1066, 1593, 1495, 1065, 1592, 
       1494, 1693, 1064, 1257, 1692, 1063, 1256, 1691, 1062, 745, 1061, 1591, 
       1493, 1060, 1590, 439, 1058, 1796, 1483}], 
      Line3DBox[{1086, 1265, 1702, 1085, 1264, 1701, 1084, 1263, 1700, 1083, 
       1603, 1504, 1082, 1602, 1503, 1081, 1601, 1502, 1080, 1600, 1501, 1079,
        1599, 1500, 1699, 1078, 1262, 1698, 1077, 1261, 1697, 1076, 1598, 
       1499, 1075, 1597, 1498, 1074, 1596, 1408, 1458, 1407, 1459, 1073, 1008,
        1325, 1474, 1324, 1427, 1385}], 
      Line3DBox[{1100, 1268, 1706, 1099, 1267, 1705, 1098, 1612, 1512, 1097, 
       1611, 1511, 1096, 1610, 1510, 1095, 1609, 1509, 1094, 1608, 1508, 1093,
        1607, 1507, 1704, 1092, 1266, 1703, 1091, 1606, 1506, 1090, 1605, 
       1505, 1089, 1582, 1790, 1460, 1088, 1604, 1361, 1437, 1360, 1438, 1087,
        1776, 1392, 1327, 1377, 1326, 1428, 1386}], 
      Line3DBox[{1114, 1269, 1708, 1113, 1622, 1522, 1112, 1621, 1521, 1111, 
       1620, 1520, 1110, 1619, 1519, 1109, 1618, 1518, 1108, 1617, 1517, 1107,
        1616, 1516, 1707, 1106, 1615, 1515, 1105, 1614, 1514, 1104, 1613, 
       1513, 1103, 1579, 1791, 1461, 1463, 1462, 1102, 1441, 1778, 1442, 1395,
        1397, 1396, 1101, 1777, 1393, 1409, 1394, 1378, 1430, 1429, 1387}], 
      Line3DBox[{1117, 1363, 1434, 1435, 1471, 1785, 1270, 1436, 1390, 1391, 
       1381, 1413, 1783, 1271, 1412, 1411, 1455, 1782, 1272, 1120, 1466, 1467,
        1273, 1122, 1709, 1274, 1124, 1710, 1275, 1126, 1711, 1526, 1627, 
       1128, 1712, 1276, 1130, 1713, 1277, 1132, 1714, 1278, 1134, 1715, 1279,
        1136, 1716, 1280, 1138, 1717, 1281, 1140, 1718, 1282, 1142}], 
      Line3DBox[{1141, 1634, 1533, 1139, 1633, 1532, 1137, 1632, 1531, 1135, 
       1631, 1530, 1133, 1630, 1529, 1131, 1629, 1528, 1129, 1628, 1527, 1127,
        1626, 1625, 1525, 1125, 1624, 1524, 1123, 1623, 1523, 1121, 1465, 
       1792, 1464, 1119, 1580, 1789, 1452, 1454, 1453, 1118, 1443, 1775, 1444,
        1380, 1389, 1388, 1115, 1578, 1781, 1410, 1398, 1379, 1362, 1116}], 
      Line3DBox[{1143, 1364, 1534, 1768, 1365, 1328, 1415, 1445, 1788, 1283, 
       1382, 1329, 1383, 1761, 1418, 1284, 1417, 1416, 1456, 1285, 1144, 1719,
        1286, 1145, 1720, 1287, 1146, 1721, 1535, 1635, 1147, 1536, 1636, 
       1148, 1722, 1288, 1149, 1723, 1289, 1150, 1724, 1290, 1151, 1725, 1291,
        1152, 1726, 1292, 1153, 1727, 1293, 1154}], 
      Line3DBox[{1156, 1537, 1637, 1155, 1414, 1538, 1784, 1431, 1330, 1422, 
       1762, 1446, 1447, 1421, 1419, 1472, 1294, 1157, 1728, 1295, 1158, 1729,
        1296, 1159, 1730, 1539, 1638, 1160, 1540, 1639, 1161, 1541, 1640, 
       1162, 1731, 1297, 1163, 1732, 1298, 1164, 1733, 1299, 1165, 1734, 1300,
        1166, 1735, 1301, 1167}], 
      Line3DBox[{1169, 1542, 1641, 1168, 1543, 1642, 1170, 1420, 1544, 1794, 
       1469, 1468, 1793, 1302, 1171, 1736, 1303, 1172, 1737, 1304, 1173, 1738,
        1545, 1643, 1174, 1546, 1644, 1175, 1547, 1645, 1176, 1548, 1646, 
       1177, 1739, 1305, 1178, 1740, 1306, 1179, 1741, 1307, 1180, 1742, 1308,
        1181}], 
      Line3DBox[{1183, 1549, 1647, 1182, 1550, 1648, 1184, 1551, 1649, 1185, 
       1552, 1650, 1186, 1743, 1309, 1187, 1744, 1310, 1188, 1745, 1553, 1651,
        1189, 1554, 1652, 1190, 1555, 1653, 1191, 1556, 1654, 1192, 1557, 
       1655, 1193, 1746, 1311, 1194, 1747, 1312, 1195, 1748, 1313, 1196}], 
      Line3DBox[{1198, 1558, 1656, 1197, 1559, 1657, 1199, 1560, 1658, 1200, 
       1561, 1659, 1201, 1562, 1660, 1202, 1749, 1331, 1332, 1203, 1750, 1333,
        1334, 1661, 1204, 1335, 1336, 1662, 1205, 1337, 1338, 1663, 1206, 
       1366, 1769, 1575, 1207, 1367, 1770, 1368, 1208, 1563, 1664, 1209, 1751,
        1314, 1210, 1752, 1315, 1211}], 
      Line3DBox[{1225, 1374, 1373, 1753, 1224, 1672, 1568, 1223, 1372, 1772, 
       1576, 1222, 1347, 1766, 1346, 1221, 1574, 1765, 1345, 1220, 1573, 1764,
        1344, 1219, 1671, 1343, 1342, 1218, 1670, 1341, 1340, 1771, 1217, 
       1339, 1763, 1572, 1216, 1669, 1567, 1215, 1668, 1566, 1214, 1667, 1565,
        1213, 1666, 1564, 1212, 1665, 1370, 1369, 1371}], 
      Line3DBox[{1359, 1237, 1358, 1675, 1031, 1236, 1674, 1030, 1235, 1758, 
       1570, 1029, 1234, 1757, 1320, 1357, 1233, 1756, 1319, 1356, 1232, 1755,
        1318, 1355, 1231, 1754, 1317, 1354, 1767, 1484, 1316, 1673, 1353, 
       1230, 1406, 1376, 1774, 1569, 1352, 1229, 1405, 1375, 1577, 1773, 1384,
        1351, 1228, 1440, 1404, 1426, 1425, 1350, 1227, 1787, 1581, 1402, 
       1424, 1423, 1349, 1226, 1786, 1439, 1400, 1433, 1432, 1348, 710, 1457, 
       1448, 1479}]}, {
      Line3DBox[{324, 228, 1404, 369, 368, 1780, 522, 730, 1682, 537, 745, 
       552, 1598, 760, 567, 1605, 775, 582, 1613, 789, 597, 1792, 446, 1467, 
       447, 386, 1456, 434, 389, 1472, 455, 449, 1793, 654, 1650, 856, 669, 
       1659, 871, 684, 1668, 883, 699}], 
      Line3DBox[{500, 971, 891, 931, 892, 972, 1773, 966, 900, 1015, 901, 
       1759, 523, 731, 1683, 538, 746, 1691, 553, 761, 1697, 568, 1606, 776, 
       583, 1614, 790, 598, 1623, 803, 1709, 612, 815, 1719, 626, 828, 1728, 
       640, 842, 1736, 655, 857, 1743, 670, 1660, 872, 685, 1669, 884, 700}], 
      Line3DBox[{501, 332, 932, 893, 1774, 967, 902, 903, 524, 732, 1684, 539,
        747, 1692, 554, 762, 1698, 569, 777, 1703, 584, 1615, 791, 599, 1624, 
       804, 1710, 613, 816, 1720, 627, 829, 1729, 641, 843, 1737, 656, 858, 
       1744, 671, 912, 1749, 913, 686, 1763, 919, 920, 701}], 
      Line3DBox[{502, 974, 975, 933, 1673, 894, 503, 904, 1676, 906, 525, 733,
        1685, 540, 748, 1693, 555, 763, 1699, 570, 778, 1704, 585, 792, 1707, 
       600, 1625, 805, 1711, 614, 817, 1721, 628, 830, 1730, 642, 844, 1738, 
       657, 859, 1745, 672, 914, 1750, 916, 687, 921, 1771, 948, 923, 702}], 
      Line3DBox[{505, 895, 935, 712, 1754, 506, 907, 1584, 720, 527, 1588, 
       735, 542, 1593, 750, 557, 1600, 765, 572, 1608, 780, 587, 1617, 794, 
       602, 1628, 807, 1712, 616, 1636, 819, 630, 1639, 832, 644, 1644, 846, 
       659, 1652, 861, 674, 917, 1662, 945, 874, 689, 924, 1671, 950, 886, 
       704}], Line3DBox[{507, 896, 936, 713, 1755, 508, 908, 721, 1760, 528, 
       1589, 736, 543, 1594, 751, 558, 1601, 766, 573, 1609, 781, 588, 1618, 
       795, 603, 1629, 808, 1713, 617, 820, 1722, 631, 1640, 833, 645, 1645, 
       847, 660, 1653, 862, 675, 918, 1663, 959, 875, 690, 1764, 925, 951, 
       887, 705}], 
      Line3DBox[{509, 897, 937, 714, 1756, 510, 722, 1677, 529, 737, 1686, 
       544, 1595, 752, 559, 1602, 767, 574, 1610, 782, 589, 1619, 796, 604, 
       1630, 809, 1714, 618, 821, 1723, 632, 834, 1731, 646, 1646, 848, 661, 
       1654, 863, 676, 1769, 946, 960, 876, 691, 1765, 926, 952, 888, 706}], 
      Line3DBox[{511, 235, 1757, 512, 723, 1678, 530, 738, 1687, 545, 753, 
       560, 1603, 768, 575, 1611, 783, 590, 1620, 797, 605, 1631, 810, 1715, 
       619, 822, 1724, 633, 835, 1732, 647, 849, 1739, 662, 1655, 864, 677, 
       1770, 284, 692, 1766, 259, 707}], 
      Line3DBox[{513, 898, 899, 1758, 514, 724, 1679, 531, 739, 1688, 546, 
       754, 1694, 561, 769, 1700, 576, 1612, 784, 591, 1621, 798, 606, 1632, 
       811, 1716, 620, 823, 1725, 634, 836, 1733, 648, 850, 1740, 663, 865, 
       1746, 678, 1664, 877, 693, 1772, 953, 961, 954, 708}], 
      Line3DBox[{515, 715, 1674, 516, 725, 1680, 532, 740, 1689, 547, 755, 
       1695, 562, 770, 1701, 577, 785, 1705, 592, 1622, 799, 607, 1633, 812, 
       1717, 621, 824, 1726, 635, 837, 1734, 649, 851, 1741, 664, 866, 1747, 
       679, 878, 1751, 694, 1672, 889, 709}], 
      Line3DBox[{517, 938, 1675, 939, 518, 726, 1681, 533, 741, 1690, 548, 
       756, 1696, 563, 771, 1702, 578, 786, 1706, 593, 800, 1708, 608, 1634, 
       813, 1718, 622, 825, 1727, 636, 838, 1735, 650, 852, 1742, 665, 867, 
       1748, 680, 879, 1752, 695, 955, 1753, 956, 957}], 
      Line3DBox[{696, 880, 1665, 947, 681, 868, 1656, 666, 853, 1647, 651, 
       839, 1641, 637, 826, 1637, 623, 814, 1768, 943, 1018, 1017, 609, 1785, 
       801, 1003, 1002, 942, 985, 986, 984, 1781, 594, 787, 991, 437, 941, 
       982, 983, 1777, 981, 579, 772, 1004, 978, 958, 980, 1776, 979, 564, 
       757, 990, 989, 1008, 1007, 549, 742, 1796, 1027, 534, 727, 1585, 519, 
       716, 1795, 1024, 1026, 1025, 497, 710, 1016, 927, 963, 965, 962, 964}],
       Line3DBox[{697, 881, 1666, 682, 869, 1657, 667, 854, 1648, 652, 840, 
       1642, 638, 827, 1784, 1001, 417, 624, 1788, 416, 968, 909, 610, 1783, 
       383, 995, 415, 1775, 595, 380, 993, 414, 1778, 580, 773, 1604, 940, 
       565, 758, 1596, 988, 550, 743, 1590, 1019, 535, 728, 1586, 520, 717, 
       1012, 426, 498, 1786, 410, 929, 304, 928}], 
      Line3DBox[{698, 882, 1667, 683, 870, 1658, 668, 855, 1649, 653, 841, 
       1794, 1022, 999, 1023, 639, 1011, 1762, 1010, 1000, 911, 1009, 625, 
       998, 1761, 997, 996, 910, 1021, 611, 1782, 802, 994, 1789, 596, 788, 
       992, 1791, 581, 774, 1020, 1790, 566, 759, 1597, 551, 744, 1591, 536, 
       729, 521, 1779, 718, 1013, 987, 1014, 499, 1787, 1006, 1005, 930, 890, 
       970, 969}], 
      Line3DBox[{703, 885, 949, 1670, 922, 688, 873, 944, 1661, 915, 673, 860,
        1651, 658, 845, 1643, 643, 831, 1638, 629, 818, 1635, 615, 806, 1627, 
       1626, 601, 793, 1616, 586, 779, 1607, 571, 764, 1599, 556, 749, 1592, 
       541, 734, 1587, 526, 719, 1583, 905, 504, 711, 1767, 934, 977, 976, 
       973}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJzcu3k4le37PioN5hIloUSFJEWUsSuizBSiEElRQqOECslQSkKGyJwMCckU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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 0.2}, {0, 1}, {0., 0.6979462770780432}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"Out[3]=",
 CellID->66181903]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["sol", "MR"],
 "."
}], "ExampleText",
 CellID->135038103],

Cell[BoxData[
 RowBox[{"Clear", "[", "sol", "]"}]], "Input",
 CellTags->"NDSolve::ibcinc",
 CellLabel->"In[4]:=",
 CellID->5421]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ibcinc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 26.2965016}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ibcinc", "synonyms" -> {}, "title" -> 
    "NDSolve::ibcinc", "type" -> "Message", "uri" -> "ref/message/ibcinc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2232, 81, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->291080810]},
 "NDSolve::ibcinc"->{
  Cell[3134, 113, 1021, 32, 70, "Input",
   CellTags->"NDSolve::ibcinc",
   CellID->8808],
  Cell[4158, 147, 225, 6, 70, "Message",
   CellTags->"NDSolve::ibcinc",
   CellID->73244119],
  Cell[4386, 155, 504, 18, 70, "Output",
   CellTags->"NDSolve::ibcinc",
   CellID->19649481],
  Cell[5147, 185, 1167, 36, 70, "Input",
   CellTags->"NDSolve::ibcinc",
   CellID->24359],
  Cell[6317, 223, 505, 18, 70, "Output",
   CellTags->"NDSolve::ibcinc",
   CellID->926377370],
  Cell[6938, 249, 461, 15, 70, "Input",
   CellTags->"NDSolve::ibcinc",
   CellID->27947],
  Cell[7402, 266, 110500, 1796, 70, "Output",
   CellTags->"NDSolve::ibcinc",
   CellID->66181903],
  Cell[118027, 2072, 128, 4, 70, "Input",
   CellTags->"NDSolve::ibcinc",
   CellID->5421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 119120, 2104},
 {"NDSolve::ibcinc", 119261, 2108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->17530],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 196, 5, 70, "Message",
 CellID->147292331],
Cell[1458, 56, 199, 5, 70, "Notes",
 CellID->11922],
Cell[1660, 63, 206, 5, 70, "Notes",
 CellID->17446],
Cell[1869, 70, 326, 6, 70, "Notes",
 CellID->4446]
}, Closed]],
Cell[CellGroupData[{
Cell[2232, 81, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->291080810],
Cell[CellGroupData[{
Cell[2617, 95, 148, 5, 70, "ExampleSection",
 CellID->289100817],
Cell[2768, 102, 341, 7, 70, "ExampleText",
 CellID->307917443],
Cell[CellGroupData[{
Cell[3134, 113, 1021, 32, 70, "Input",
 CellTags->"NDSolve::ibcinc",
 CellID->8808],
Cell[4158, 147, 225, 6, 70, "Message",
 CellTags->"NDSolve::ibcinc",
 CellID->73244119],
Cell[4386, 155, 504, 18, 70, "Output",
 CellTags->"NDSolve::ibcinc",
 CellID->19649481]
}, Open  ]],
Cell[4905, 176, 217, 5, 70, "ExampleText",
 CellID->127545552],
Cell[CellGroupData[{
Cell[5147, 185, 1167, 36, 70, "Input",
 CellTags->"NDSolve::ibcinc",
 CellID->24359],
Cell[6317, 223, 505, 18, 70, "Output",
 CellTags->"NDSolve::ibcinc",
 CellID->926377370]
}, Open  ]],
Cell[6837, 244, 76, 1, 70, "ExampleText",
 CellID->41481026],
Cell[CellGroupData[{
Cell[6938, 249, 461, 15, 70, "Input",
 CellTags->"NDSolve::ibcinc",
 CellID->27947],
Cell[7402, 266, 110500, 1796, 70, "Output",
 CellTags->"NDSolve::ibcinc",
 CellID->66181903]
}, Open  ]],
Cell[117917, 2065, 107, 5, 70, "ExampleText",
 CellID->135038103],
Cell[118027, 2072, 128, 4, 70, "Input",
 CellTags->"NDSolve::ibcinc",
 CellID->5421]
}, Open  ]]
}, Open  ]],
Cell[118182, 2080, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

