(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7426,        251]
NotebookOptionsPosition[      4380,        161]
NotebookOutlinePosition[      6429,        218]
CellTagsIndexPosition[      6268,        211]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NDSolve::icord
NDSolve`Reinitialize::icord\
\>", "ObjectName",
 CellID->16281],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"icord\"\>"}], ":", 
  " ", "\<\"The differential order of the functions in the initial or \
boundary conditions should be strictly less than in the differential \
equations.\"\>"}]], "Message", "MSG",
 CellID->255285109],

Cell["\<\
Generated when an initial condition includes a derivative of higher \
differential order than that of the differential equation.\
\>", "Notes",
 CellID->8950]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20404756],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->53541816],

Cell["\<\
An error occurs in this example because the order of the derivative in the \
initial condition is higher than the order of the highest derivative in the \
differential equation.\
\>", "ExampleText",
 CellID->135256632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'''"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
    "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellLabel->"In[1]:=",
 CellID->9867],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"icord\"\>"}], ":", 
  " ", "\<\"The differential order of the functions in the initial or \
boundary conditions should be strictly less than in the differential \
equations.\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellID->239495285],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", 
        TagBox[
         RowBox[{"(", "3", ")"}],
         Derivative],
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}],
    ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellLabel->"Out[1]=",
 CellID->123902]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::icord - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 27.1558986}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::icord NDSolve`Reinitialize::icord", 
    "synonyms" -> {}, "title" -> "NDSolve::icord", "type" -> "Message", "uri" -> 
    "ref/message/icord"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1799, 70, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20404756]},
 "NDSolve::icord"->{
  Cell[2586, 100, 632, 19, 70, "Input",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->9867],
  Cell[3221, 121, 338, 7, 70, "Message",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->239495285],
  Cell[3562, 130, 752, 24, 70, "Output",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->123902]},
 "NDSolve`Reinitialize::icord"->{
  Cell[2586, 100, 632, 19, 70, "Input",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->9867],
  Cell[3221, 121, 338, 7, 70, "Message",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->239495285],
  Cell[3562, 130, 752, 24, 70, "Output",
   CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
   CellID->123902]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5320, 184},
 {"NDSolve::icord", 5459, 188},
 {"NDSolve`Reinitialize::icord", 5869, 198}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 88, 4, 70, "ObjectName",
 CellID->16281],
Cell[CellGroupData[{
Cell[816, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1294, 52, 297, 7, 70, "Message",
 CellID->255285109],
Cell[1594, 61, 168, 4, 70, "Notes",
 CellID->8950]
}, Closed]],
Cell[CellGroupData[{
Cell[1799, 70, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20404756],
Cell[CellGroupData[{
Cell[2183, 84, 147, 5, 70, "ExampleSection",
 CellID->53541816],
Cell[2333, 91, 228, 5, 70, "ExampleText",
 CellID->135256632],
Cell[CellGroupData[{
Cell[2586, 100, 632, 19, 70, "Input",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellID->9867],
Cell[3221, 121, 338, 7, 70, "Message",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellID->239495285],
Cell[3562, 130, 752, 24, 70, "Output",
 CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"},
 CellID->123902]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4353, 159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

