(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7491,        263]
NotebookOptionsPosition[      5115,        185]
NotebookOutlinePosition[      6587,        230]
CellTagsIndexPosition[      6470,        224]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::molpde", "ObjectName",
 CellID->9990],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"molpde\"\>"}], ":", 
  " ", "\<\"The option Method -> MethodOfLines is only legitimate for partial \
differential equations with more than one independent variable.\"\>"}]], \
"Message", "MSG",
 CellID->104669365],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData["\"\<MethodOfLines\>\""], "InlineFormula"],
 " is used as the value of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option and the first argument in ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " is not a specification of a partial differential equation."
}], "Notes",
 CellID->23327]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->677504633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->309143104],

Cell["\<\
An error occurs in this example because the specified method is not designed \
for solving equations with only one independent variable.\
\>", "ExampleText",
 CellID->131542082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "^", "2"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "^", "2"}]}], " ", "\[Equal]", " ", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Method", "->", "\"\<MethodOfLines\>\""}]}], "]"}]], "Input",
 CellTags->"NDSolve::molpde",
 CellLabel->"In[1]:=",
 CellID->15402],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"molpde\"\>"}], ":", 
  " ", "\<\"The option Method -> MethodOfLines is only legitimate for partial \
differential equations with more than one independent variable.\"\>"}]], \
"Message", "MSG",
 CellTags->"NDSolve::molpde",
 CellID->18284],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"x", "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"y", "[", "t", "]"}], "2"]}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\<\"MethodOfLines\"\>"}]}], "]"}]], "Output",\

 CellTags->"NDSolve::molpde",
 CellLabel->"Out[1]=",
 CellID->381318339]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::molpde - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 42.7344224}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::molpde", "synonyms" -> {}, "title" -> 
    "NDSolve::molpde", "type" -> "Message", "uri" -> "ref/message/molpde"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2055, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->677504633]},
 "NDSolve::molpde"->{
  Cell[2803, 106, 949, 29, 70, "Input",
   CellTags->"NDSolve::molpde",
   CellID->15402],
  Cell[3755, 137, 295, 7, 70, "Message",
   CellTags->"NDSolve::molpde",
   CellID->18284],
  Cell[4053, 146, 996, 32, 70, "Output",
   CellTags->"NDSolve::molpde",
   CellID->381318339]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6026, 207},
 {"NDSolve::molpde", 6167, 211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->9990],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 269, 6, 70, "Message",
 CellID->104669365],
Cell[1530, 57, 488, 15, 70, "Notes",
 CellID->23327]
}, Closed]],
Cell[CellGroupData[{
Cell[2055, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->677504633],
Cell[CellGroupData[{
Cell[2440, 91, 148, 5, 70, "ExampleSection",
 CellID->309143104],
Cell[2591, 98, 187, 4, 70, "ExampleText",
 CellID->131542082],
Cell[CellGroupData[{
Cell[2803, 106, 949, 29, 70, "Input",
 CellTags->"NDSolve::molpde",
 CellID->15402],
Cell[3755, 137, 295, 7, 70, "Message",
 CellTags->"NDSolve::molpde",
 CellID->18284],
Cell[4053, 146, 996, 32, 70, "Output",
 CellTags->"NDSolve::molpde",
 CellID->381318339]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5088, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

